/*
 * Decompiled with CFR 0.152.
 */
package net.bitform.oilink;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import net.bitform.oilink.BasicIO;
import net.bitform.oilink.FileChannelToBasicIO;

public class FileToBasicIO
implements BasicIO {
    private final File file;
    private RandomAccessFile raf;
    private FileInputStream fis;
    private FileChannel fc;
    private FileChannelToBasicIO bio;
    private final boolean writable;

    public FileToBasicIO(File file, boolean bl) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("The file parameter may not be null");
        }
        this.file = file;
        this.writable = bl;
    }

    @Override
    public void open() throws IOException {
        if (this.writable) {
            this.raf = new RandomAccessFile(this.file, "rw");
            this.fis = null;
            this.fc = this.raf.getChannel();
        } else {
            this.fis = new FileInputStream(this.file);
            this.raf = null;
            this.fc = this.fis.getChannel();
        }
        this.bio = new FileChannelToBasicIO(this.fc);
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return this.writable;
    }

    @Override
    public int readAt(long l, ByteBuffer byteBuffer) throws IOException {
        return this.bio.readAt(l, byteBuffer);
    }

    @Override
    public void writeAt(long l, ByteBuffer byteBuffer) throws IOException {
        this.bio.writeAt(l, byteBuffer);
    }

    @Override
    public long getSize() throws IOException {
        return this.bio.getSize();
    }

    @Override
    public void close() {
        if (this.bio != null) {
            this.bio.close();
        }
        try {
            if (this.fc != null) {
                this.fc.close();
            }
            if (this.raf != null) {
                this.raf.close();
            }
            if (this.fis != null) {
                this.fis.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getUnderlyingFileName() {
        return this.file.getName();
    }

    @Override
    public File getUnderlyingFile() {
        return this.file;
    }
}

