/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.outsidein.annotations;

import com.oracle.outsidein.ColorInfo;
import com.oracle.outsidein.annotations.CharAttributeValues;
import java.util.EnumSet;
import net.bitform.oilink.OILinkMessages;

public class HighlightTextAnnotation {
    long m_startCharCount;
    long m_endCharCount;
    ColorInfo m_foreground;
    ColorInfo m_background;
    EnumSet<CharAttributeValues> m_charAttrs;
    EnumSet<CharAttributeValues> m_charMask;

    public HighlightTextAnnotation(long l, long l2, ColorInfo colorInfo, ColorInfo colorInfo2) {
        this.init(l, l2, colorInfo, colorInfo2, EnumSet.of(CharAttributeValues.NORMAL), EnumSet.allOf(CharAttributeValues.class));
    }

    public HighlightTextAnnotation(long l, long l2, EnumSet<CharAttributeValues> enumSet, EnumSet<CharAttributeValues> enumSet2) {
        this.init(l, l2, null, null, enumSet, enumSet2);
    }

    public HighlightTextAnnotation(long l, long l2, ColorInfo colorInfo, ColorInfo colorInfo2, EnumSet<CharAttributeValues> enumSet, EnumSet<CharAttributeValues> enumSet2) {
        this.init(l, l2, colorInfo, colorInfo2, enumSet, enumSet2);
    }

    private void init(long l, long l2, ColorInfo colorInfo, ColorInfo colorInfo2, EnumSet<CharAttributeValues> enumSet, EnumSet<CharAttributeValues> enumSet2) {
        this.m_startCharCount = l;
        this.m_endCharCount = l2;
        this.m_foreground = colorInfo;
        this.m_background = colorInfo2;
        this.m_charAttrs = enumSet;
        this.m_charMask = enumSet2;
    }

    public OILinkMessages.HiliteText getOILinkHiliteText() {
        OILinkMessages.Color.Builder builder = null;
        OILinkMessages.HiliteText.Builder builder2 = OILinkMessages.HiliteText.newBuilder().setStartACC(this.m_startCharCount).setEndACC(this.m_endCharCount);
        if (null != this.m_foreground) {
            builder = OILinkMessages.Color.newBuilder().setBlue(this.m_foreground.getBlue()).setGreen(this.m_foreground.getGreen()).setRed(this.m_foreground.getRed());
            builder2.setForegroundColor(builder.build());
        }
        if (null != this.m_background) {
            builder = OILinkMessages.Color.newBuilder().setBlue(this.m_background.getBlue()).setGreen(this.m_background.getGreen()).setRed(this.m_background.getRed());
            builder2.setBackgroundColor(builder.build());
        }
        if (this.m_charMask.contains((Object)CharAttributeValues.UNDERLINE)) {
            builder2.setCharUnderline(this.m_charAttrs.contains((Object)CharAttributeValues.UNDERLINE));
        }
        if (this.m_charMask.contains((Object)CharAttributeValues.ITALIC)) {
            builder2.setCharItalic(this.m_charAttrs.contains((Object)CharAttributeValues.ITALIC));
        }
        if (this.m_charMask.contains((Object)CharAttributeValues.BOLD)) {
            builder2.setCharBold(this.m_charAttrs.contains((Object)CharAttributeValues.BOLD));
        }
        if (this.m_charMask.contains((Object)CharAttributeValues.STRIKEOUT)) {
            builder2.setCharStrikeout(this.m_charAttrs.contains((Object)CharAttributeValues.STRIKEOUT));
        }
        if (this.m_charMask.contains((Object)CharAttributeValues.SMALLCAPS)) {
            builder2.setCharSmallcaps(this.m_charAttrs.contains((Object)CharAttributeValues.SMALLCAPS));
        }
        if (this.m_charMask.contains((Object)CharAttributeValues.OUTLINE)) {
            builder2.setCharOutline(this.m_charAttrs.contains((Object)CharAttributeValues.OUTLINE));
        }
        if (this.m_charMask.contains((Object)CharAttributeValues.SHADOW)) {
            builder2.setCharShadow(this.m_charAttrs.contains((Object)CharAttributeValues.SHADOW));
        }
        if (this.m_charMask.contains((Object)CharAttributeValues.CAPS)) {
            builder2.setCharCaps(this.m_charAttrs.contains((Object)CharAttributeValues.CAPS));
        }
        if (this.m_charMask.contains((Object)CharAttributeValues.SUBSCRIPT)) {
            builder2.setCharSubscript(this.m_charAttrs.contains((Object)CharAttributeValues.SUBSCRIPT));
        }
        if (this.m_charMask.contains((Object)CharAttributeValues.SUPERSCRIPT)) {
            builder2.setCharSuperscript(this.m_charAttrs.contains((Object)CharAttributeValues.SUPERSCRIPT));
        }
        if (this.m_charMask.contains((Object)CharAttributeValues.DUNDERLINE)) {
            builder2.setCharDoubleUnderline(this.m_charAttrs.contains((Object)CharAttributeValues.DUNDERLINE));
        }
        if (this.m_charMask.contains((Object)CharAttributeValues.WORDUNDERLINE)) {
            builder2.setCharWordUnderline(this.m_charAttrs.contains((Object)CharAttributeValues.WORDUNDERLINE));
        }
        if (this.m_charMask.contains((Object)CharAttributeValues.DOTUNDERLINE)) {
            builder2.setCharDotUnderline(this.m_charAttrs.contains((Object)CharAttributeValues.DOTUNDERLINE));
        }
        return builder2.build();
    }
}

