/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.javapatcher.patcher;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassMap;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.Mnemonic;
import javassist.expr.Cast;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.Handler;
import javassist.expr.Instanceof;
import javassist.expr.MethodCall;
import javassist.expr.NewArray;
import javassist.expr.NewExpr;
import me.nallar.javapatcher.PatcherLog;
import me.nallar.javapatcher.mappings.Mappings;
import me.nallar.javapatcher.mappings.MethodDescription;
import me.nallar.javapatcher.patcher.CollectionsUtil;
import me.nallar.javapatcher.patcher.Patch;
import me.nallar.javapatcher.patcher.Throw;
import org.omg.CORBA.IntHolder;

public class Patches {
    private final ClassPool classPool;
    private final Mappings mappings;

    public Patches(ClassPool classPool, Mappings mappings) {
        this.classPool = classPool;
        this.mappings = mappings;
    }

    private static String classSignatureToName(String signature) {
        return signature.substring(1, signature.length() - 1).replace("/", ".");
    }

    @Patch(requiredAttributes="class")
    public void mixin(CtClass ctClass, Map<String, String> attributes) throws NotFoundException {
        String fromClass = attributes.get("class");
        CtClass from = this.classPool.get(fromClass);
    }

    public void transformClassStaticMethods(CtClass ctClass, String className) {
        for (CtMethod ctMethod : ctClass.getDeclaredMethods()) {
            MethodDescription methodDescription = new MethodDescription(className, ctMethod.getName(), ctMethod.getSignature());
            MethodDescription mapped = this.mappings.map(methodDescription);
            if (mapped != null && !mapped.name.equals(ctMethod.getName())) {
                if ((ctMethod.getModifiers() & 8) == 8) {
                    try {
                        CtMethod replacement = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctClass, null);
                        ctMethod.setName(mapped.name);
                        replacement.setBody("{return " + mapped.name + "($$);}");
                        ctClass.addMethod(replacement);
                    }
                    catch (CannotCompileException e) {
                        PatcherLog.error("Failed to compile", e);
                    }
                } else {
                    PatcherLog.error("Would remap " + methodDescription + " -> " + mapped + ", but not static.");
                }
            }
            if (ctMethod.getName().length() != 1) continue;
            PatcherLog.error("1 letter length name " + ctMethod.getName() + " in " + ctClass.getName());
        }
    }

    @Patch
    public void disableMethod(CtMethod ctMethod) throws NotFoundException, CannotCompileException {
        ctMethod.setBody("{ }");
    }

    @Patch
    public void removeMethod(CtMethod ctMethod) throws NotFoundException {
        ctMethod.getDeclaringClass().removeMethod(ctMethod);
    }

    @Patch(requiredAttributes="name")
    public void renameMethod(CtMethod ctMethod, Map<String, String> attributes) {
        ctMethod.setName(attributes.get("name"));
    }

    @Patch(requiredAttributes="code")
    public void addMethod(CtClass ctClass, Map<String, String> attributes) throws CannotCompileException {
        block2: {
            try {
                ctClass.addMethod(CtNewMethod.make((String)attributes.get("code"), (CtClass)ctClass));
            }
            catch (DuplicateMemberException e) {
                if (attributes.containsKey("ignoreDuplicate")) break block2;
                throw e;
            }
        }
    }

    @Patch(requiredAttributes="code,returnType,name")
    public void addMethodWithGivenTypes(CtClass ctClass, Map<String, String> attributes) throws NotFoundException, CannotCompileException {
        String name = attributes.get("name");
        String return_ = attributes.get("returnType");
        String code = attributes.get("code");
        String parameterNamesList = attributes.get("parameterTypes");
        parameterNamesList = parameterNamesList == null ? "" : parameterNamesList;
        ArrayList<CtClass> parameterList = new ArrayList<CtClass>();
        for (String parameterName : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)parameterNamesList)) {
            parameterList.add(this.classPool.get(parameterName));
        }
        CtMethod newMethod = new CtMethod(this.classPool.get(return_), name, parameterList.toArray(new CtClass[parameterList.size()]), ctClass);
        newMethod.setBody('{' + code + '}');
        ctClass.addMethod(newMethod);
    }

    @Patch
    public void replaceMethod(CtBehavior method, Map<String, String> attributes) throws NotFoundException, CannotCompileException, BadBytecode {
        String fromClass = attributes.get("fromClass");
        String code = attributes.get("code");
        String field = attributes.get("field");
        if (field != null) {
            code = code.replace("$field", field);
        }
        if (fromClass != null) {
            String fromMethod = attributes.get("fromMethod");
            CtBehavior replacingMethod = fromMethod == null ? this.classPool.get(fromClass).getDeclaredMethod(method.getName(), method.getParameterTypes()) : MethodDescription.fromString(fromClass, fromMethod).inClass(this.classPool.get(fromClass));
            this.replaceMethod((CtMethod)method, (CtMethod)replacingMethod);
        } else if (code != null) {
            method.setBody(code);
        } else {
            PatcherLog.error("Missing required attributes for replaceMethod");
        }
    }

    private void replaceMethod(CtMethod oldMethod, CtMethod newMethod) throws CannotCompileException, BadBytecode {
        ClassMap classMap = new ClassMap();
        classMap.put(newMethod.getDeclaringClass().getName(), oldMethod.getDeclaringClass().getName());
        oldMethod.setBody(newMethod, classMap);
        oldMethod.getMethodInfo().rebuildStackMap(this.classPool);
        oldMethod.getMethodInfo().rebuildStackMapForME(this.classPool);
    }

    @Patch(requiredAttributes="field")
    public void removeField(CtClass ctClass, Map<String, String> attributes) throws NotFoundException {
        ctClass.removeField(ctClass.getDeclaredField(attributes.get("field")));
    }

    @Patch(requiredAttributes="field")
    public void removeFieldAndInitializers(CtClass ctClass, Map<String, String> attributes) throws CannotCompileException, NotFoundException {
        CtField ctField;
        try {
            ctField = ctClass.getDeclaredField(attributes.get("field"));
        }
        catch (NotFoundException e) {
            if (!attributes.containsKey("silent")) {
                PatcherLog.error("Couldn't find field " + attributes.get("field"));
            }
            return;
        }
        for (CtConstructor ctBehavior : ctClass.getDeclaredConstructors()) {
            this.removeInitializers((CtBehavior)ctBehavior, ctField);
        }
        CtConstructor ctBehavior = ctClass.getClassInitializer();
        if (ctBehavior != null) {
            this.removeInitializers((CtBehavior)ctBehavior, ctField);
        }
        ctClass.removeField(ctField);
    }

    @Patch(requiredAttributes="type,field")
    public void changefieldClass(final CtClass ctClass, Map<String, String> attributes) throws CannotCompileException, NotFoundException {
        final String field = attributes.get("field");
        CtField oldField = ctClass.getDeclaredField(field);
        oldField.setName(field + "_old");
        String newType = attributes.get("type");
        CtField ctField = new CtField(this.classPool.get(newType), field, ctClass);
        ctField.setModifiers(oldField.getModifiers());
        ctClass.addField(ctField);
        HashSet<CtConstructor> allBehaviours = new HashSet<CtConstructor>();
        Collections.addAll(allBehaviours, ctClass.getDeclaredConstructors());
        Collections.addAll(allBehaviours, ctClass.getDeclaredMethods());
        CtConstructor initializer = ctClass.getClassInitializer();
        if (initializer != null) {
            allBehaviours.add(initializer);
        }
        final boolean remove = attributes.containsKey("remove");
        for (CtBehavior ctBehavior : allBehaviours) {
            ctBehavior.instrument(new ExprEditor(){

                public void edit(FieldAccess fieldAccess) throws CannotCompileException {
                    if (fieldAccess.getClassName().equals(ctClass.getName()) && fieldAccess.getFieldName().equals(field)) {
                        if (fieldAccess.isReader()) {
                            if (remove) {
                                fieldAccess.replace("$_ = null;");
                            } else {
                                fieldAccess.replace("$_ = $0." + field + ';');
                            }
                        } else if (fieldAccess.isWriter()) {
                            if (remove) {
                                fieldAccess.replace("$_ = null;");
                            } else {
                                fieldAccess.replace("$0." + field + " = $1;");
                            }
                        }
                    }
                }
            });
        }
    }

    @Patch(requiredAttributes="field", emptyConstructor=false)
    public void replaceFieldInitializer(Object o, Map<String, String> attributes) throws CannotCompileException, NotFoundException {
        String ctFieldClass;
        final String field = attributes.get("field");
        CtClass ctClass = o instanceof CtClass ? (CtClass)o : null;
        CtBehavior ctBehavior = null;
        if (ctClass == null) {
            ctBehavior = (CtBehavior)o;
            ctClass = ctBehavior.getDeclaringClass();
        }
        if ((ctFieldClass = attributes.get("classContainingField")) != null) {
            if (ctClass == o) {
                PatcherLog.warn("Must set methods to run on if using fieldClass.");
                return;
            }
            ctClass = this.classPool.get(ctFieldClass);
        }
        final CtField ctField = ctClass.getDeclaredField(field);
        String code = attributes.get("code");
        String clazz = attributes.get("fieldClass");
        if (code == null && clazz == null) {
            throw new NullPointerException("Must give code or class");
        }
        final String newInitializer = code == null ? "$_ = new " + clazz + "();" : code;
        HashSet<Object> allBehaviours = new HashSet<Object>();
        if (ctBehavior == null) {
            Collections.addAll(allBehaviours, ctClass.getDeclaredConstructors());
            CtConstructor initializer = ctClass.getClassInitializer();
            if (initializer != null) {
                allBehaviours.add(initializer);
            }
        } else {
            allBehaviours.add(ctBehavior);
        }
        final IntHolder replaced = new IntHolder();
        for (CtBehavior ctBehavior2 : allBehaviours) {
            final HashMap newExprType = new HashMap();
            ctBehavior2.instrument(new ExprEditor(){
                NewExpr lastNewExpr;
                int newPos = 0;

                public void edit(NewExpr e) {
                    this.lastNewExpr = null;
                    ++this.newPos;
                    try {
                        if (Patches.this.classPool.get(e.getClassName()).subtypeOf(ctField.getType())) {
                            this.lastNewExpr = e;
                        }
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                }

                public void edit(FieldAccess e) {
                    NewExpr myLastNewExpr = this.lastNewExpr;
                    this.lastNewExpr = null;
                    if (myLastNewExpr != null && e.getFieldName().equals(field)) {
                        newExprType.put(this.newPos, Patches.classSignatureToName(e.getSignature()));
                    }
                }

                public void edit(MethodCall e) {
                    this.lastNewExpr = null;
                }

                public void edit(NewArray e) {
                    this.lastNewExpr = null;
                }

                public void edit(Cast e) {
                    this.lastNewExpr = null;
                }

                public void edit(Instanceof e) {
                    this.lastNewExpr = null;
                }

                public void edit(Handler e) {
                    this.lastNewExpr = null;
                }

                public void edit(ConstructorCall e) {
                    this.lastNewExpr = null;
                }
            });
            ctBehavior2.instrument(new ExprEditor(){
                int newPos = 0;

                public void edit(NewExpr e) throws CannotCompileException {
                    ++this.newPos;
                    if (newExprType.containsKey(this.newPos)) {
                        String assignedType = (String)newExprType.get(this.newPos);
                        String block = '{' + newInitializer + '}';
                        PatcherLog.trace(assignedType + " at " + e.getFileName() + ':' + e.getLineNumber() + " replaced with " + block);
                        e.replace(block);
                        ++replaced.value;
                    }
                }
            });
        }
        if (replaced.value == 0 && !attributes.containsKey("silent")) {
            PatcherLog.error("No field initializers found for replacement");
        }
    }

    @Patch(requiredAttributes="oldClass", emptyConstructor=false)
    public void replaceNewExpression(Object o, Map<String, String> attributes) throws CannotCompileException, NotFoundException {
        final String type = attributes.get("oldClass");
        String code = attributes.get("code");
        String clazz = attributes.get("newClass");
        if (code == null && clazz == null) {
            throw new NullPointerException("Must give code or class");
        }
        final String newInitializer = code == null ? "$_ = new " + clazz + "();" : code;
        HashSet<CtBehavior> allBehaviours = new HashSet<CtBehavior>();
        if (o instanceof CtClass) {
            CtClass ctClass = (CtClass)o;
            allBehaviours.addAll(Arrays.asList(ctClass.getDeclaredBehaviors()));
        } else {
            allBehaviours.add((CtBehavior)o);
        }
        final IntHolder done = new IntHolder();
        for (CtBehavior ctBehavior : allBehaviours) {
            ctBehavior.instrument(new ExprEditor(){

                public void edit(NewExpr e) throws CannotCompileException {
                    if (e.getClassName().equals(type)) {
                        e.replace(newInitializer);
                        ++done.value;
                    }
                }
            });
        }
        if (done.value == 0) {
            PatcherLog.error("No new expressions found for replacement.");
        }
    }

    @Patch(requiredAttributes="field")
    public void setVolatile(CtClass ctClass, Map<String, String> attributes) throws NotFoundException {
        String field = attributes.get("field");
        if (field == null) {
            for (CtField ctField : ctClass.getDeclaredFields()) {
                if (!ctField.getType().isPrimitive()) continue;
                ctField.setModifiers(ctField.getModifiers() | 0x40);
            }
        } else {
            CtField ctField = ctClass.getDeclaredField(field);
            ctField.setModifiers(ctField.getModifiers() | 0x40);
        }
    }

    @Patch(requiredAttributes="field")
    public void unsetVolatile(CtClass ctClass, Map<String, String> attributes) throws NotFoundException {
        String field = attributes.get("field");
        if (field == null) {
            for (CtField ctField : ctClass.getDeclaredFields()) {
                if (!ctField.getType().isPrimitive()) continue;
                ctField.setModifiers(ctField.getModifiers() & 0xFFFFFFBF);
            }
        } else {
            CtField ctField = ctClass.getDeclaredField(field);
            ctField.setModifiers(ctField.getModifiers() & 0xFFFFFFBF);
        }
    }

    @Patch(name="final")
    public void setFinal(CtClass ctClass, Map<String, String> attributes) throws NotFoundException {
        String field = attributes.get("field");
        if (field == null) {
            for (CtField ctField : ctClass.getDeclaredFields()) {
                if (!ctField.getType().isPrimitive()) continue;
                ctField.setModifiers(ctField.getModifiers() | 0x10);
            }
        } else {
            CtField ctField = ctClass.getDeclaredField(field);
            ctField.setModifiers(ctField.getModifiers() | 0x10);
        }
    }

    @Patch(emptyConstructor=false)
    public void unsetFinal(Object o, Map<String, String> attributes) throws NotFoundException {
        String field = attributes.get("field");
        if (field != null) {
            CtClass ctClass = (CtClass)o;
            CtField ctField = ctClass.getDeclaredField(field);
            ctField.setModifiers(Modifier.clear((int)ctField.getModifiers(), (int)16));
        } else if (o instanceof CtClass) {
            CtClass ctClass = (CtClass)o;
            ctClass.setModifiers(Modifier.setPublic((int)ctClass.getModifiers()));
            for (CtConstructor ctConstructor : ctClass.getDeclaredConstructors()) {
                this.setPublic(ctConstructor, Collections.emptyMap());
            }
        } else {
            CtBehavior ctBehavior = (CtBehavior)o;
            ctBehavior.setModifiers(Modifier.clear((int)ctBehavior.getModifiers(), (int)16));
        }
    }

    @Patch(requiredAttributes="class")
    public CtClass replaceClass(CtClass clazz, Map<String, String> attributes) throws NotFoundException, CannotCompileException, BadBytecode {
        String fromClass = attributes.get("class");
        String oldName = clazz.getName();
        clazz.setName(oldName + "_old");
        CtClass newClass = this.classPool.get(fromClass);
        ClassFile classFile = newClass.getClassFile2();
        if (classFile.getSuperclass().equals(oldName)) {
            classFile.setSuperclass(null);
            for (CtConstructor ctBehavior : newClass.getDeclaredConstructors()) {
                MethodInfo methodInfo = ctBehavior.getMethodInfo2();
                CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
                if (codeAttribute == null) continue;
                CodeIterator iterator = codeAttribute.iterator();
                int pos = iterator.skipSuperConstructor();
                if (pos >= 0) {
                    int mref = iterator.u16bitAt(pos + 1);
                    ConstPool constPool = codeAttribute.getConstPool();
                    iterator.write16bit(constPool.addMethodrefInfo(constPool.addClassInfo("java.lang.Object"), "<init>", "()V"), pos + 1);
                    String desc = constPool.getMethodrefType(mref);
                    int num = Descriptor.numOfParameters((String)desc) + 1;
                    pos = iterator.insertGapAt((int)pos, (int)num, (boolean)false).position;
                    Descriptor.Iterator i$ = new Descriptor.Iterator(desc);
                    i$.next();
                    while (i$.isParameter()) {
                        iterator.writeByte(i$.is2byte() ? 88 : 87, pos++);
                        i$.next();
                    }
                }
                methodInfo.rebuildStackMapIf6(newClass.getClassPool(), newClass.getClassFile2());
            }
        }
        newClass.setName(oldName);
        newClass.setModifiers(newClass.getModifiers() & 0xFFFFFBFF);
        this.transformClassStaticMethods(newClass, newClass.getName());
        return newClass;
    }

    @Patch(requiredAttributes="field")
    public void replaceFieldAccess(final CtBehavior ctBehavior, Map<String, String> attributes) throws CannotCompileException {
        final String field = attributes.get("field");
        final String readCode = attributes.get("readCode");
        final String writeCode = attributes.get("writeCode");
        final String clazz = attributes.get("fieldClass");
        final boolean removeAfter = attributes.containsKey("removeAfter");
        if (readCode == null && writeCode == null) {
            throw new IllegalArgumentException("readCode or writeCode must be set");
        }
        final IntHolder replaced = new IntHolder();
        try {
            ctBehavior.instrument(new ExprEditor(){

                public void edit(FieldAccess fieldAccess) throws CannotCompileException {
                    String fieldName;
                    try {
                        fieldName = fieldAccess.getFieldName();
                    }
                    catch (ClassCastException e) {
                        PatcherLog.warn("Can't examine field access at " + fieldAccess.getLineNumber() + " which is a r: " + fieldAccess.isReader() + " w: " + fieldAccess.isWriter());
                        return;
                    }
                    if ((clazz == null || fieldAccess.getClassName().equals(clazz)) && fieldName.equals(field)) {
                        ++replaced.value;
                        if (removeAfter) {
                            try {
                                Patches.this.removeAfterIndex(ctBehavior, fieldAccess.indexOfBytecode());
                            }
                            catch (BadBytecode badBytecode) {
                                throw Throw.sneaky(badBytecode);
                            }
                            throw new ExceptionsArentForControlFlow();
                        }
                        if (fieldAccess.isWriter() && writeCode != null) {
                            fieldAccess.replace(writeCode);
                        } else if (fieldAccess.isReader() && readCode != null) {
                            fieldAccess.replace(readCode);
                            PatcherLog.trace("Replaced in " + ctBehavior + ' ' + fieldName + " read with " + readCode);
                        }
                    }
                }
            });
        }
        catch (ExceptionsArentForControlFlow exceptionsArentForControlFlow) {
            // empty catch block
        }
        if (replaced.value == 0 && !attributes.containsKey("silent")) {
            PatcherLog.error("Didn't replace any field accesses.");
        }
    }

    @Patch
    public void replaceMethodCall(final CtBehavior ctBehavior, Map<String, String> attributes) throws CannotCompileException {
        String index_;
        String method_ = attributes.get("method");
        final String methodPrefix = attributes.get("methodPrefix");
        if (method_ == null) {
            method_ = methodPrefix == null ? "" : methodPrefix;
        }
        String className_ = null;
        int dotIndex = method_.lastIndexOf(46);
        if (dotIndex != -1) {
            className_ = method_.substring(0, dotIndex);
            method_ = method_.substring(dotIndex + 1);
        }
        if ("self".equals(className_)) {
            className_ = ctBehavior.getDeclaringClass().getName();
        }
        if ((index_ = attributes.get("index")) == null) {
            index_ = "-1";
        }
        final String method = method_;
        final String className = className_;
        final String newMethod = attributes.get("newMethod");
        String code_ = attributes.get("code");
        if (code_ == null) {
            code_ = "$_ = $0." + newMethod + "($$);";
        }
        final String code = code_;
        final IntHolder replaced = new IntHolder();
        final int index = Integer.valueOf(index_);
        final boolean removeAfter = attributes.containsKey("removeAfter");
        try {
            ctBehavior.instrument(new ExprEditor(){
                private int currentIndex = 0;

                public void edit(MethodCall methodCall) throws CannotCompileException {
                    if ((className == null || methodCall.getClassName().equals(className)) && (method.isEmpty() || methodCall.getMethodName().equals(method) || methodPrefix != null && methodCall.getMethodName().startsWith(methodPrefix)) && (index == -1 || this.currentIndex++ == index)) {
                        if (newMethod != null) {
                            try {
                                CtMethod oldMethod = methodCall.getMethod();
                                oldMethod.getDeclaringClass().getDeclaredMethod(newMethod, oldMethod.getParameterTypes());
                            }
                            catch (NotFoundException e) {
                                return;
                            }
                        }
                        ++replaced.value;
                        PatcherLog.trace("Replaced call to " + methodCall.getClassName() + '/' + methodCall.getMethodName() + " in " + ctBehavior.getLongName());
                        if (removeAfter) {
                            try {
                                Patches.this.removeAfterIndex(ctBehavior, methodCall.indexOfBytecode());
                            }
                            catch (BadBytecode badBytecode) {
                                throw Throw.sneaky(badBytecode);
                            }
                            throw new ExceptionsArentForControlFlow();
                        }
                        methodCall.replace(code);
                    }
                }
            });
        }
        catch (ExceptionsArentForControlFlow exceptionsArentForControlFlow) {
            // empty catch block
        }
        if (replaced.value == 0 && !attributes.containsKey("silent")) {
            PatcherLog.warn("Didn't find any method calls to replace in " + ctBehavior.getLongName() + ". Class: " + className + ", method: " + method + ", index: " + index);
        }
    }

    @Patch(requiredAttributes="opcode")
    public void removeCodeUntilOpcode(CtBehavior ctBehavior, Map<String, String> attributes) throws BadBytecode {
        int opcode = Arrays.asList(Mnemonic.OPCODE).indexOf(attributes.get("opcode").toLowerCase());
        String removeIndexString = attributes.get("index");
        int removeIndex = removeIndexString == null ? -1 : Integer.parseInt(removeIndexString);
        int currentIndex = 0;
        PatcherLog.trace("Removing until " + attributes.get("opcode") + ':' + opcode + " at " + removeIndex);
        int removed = 0;
        CtClass ctClass = ctBehavior.getDeclaringClass();
        MethodInfo methodInfo = ctBehavior.getMethodInfo();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute != null) {
            CodeIterator iterator = codeAttribute.iterator();
            while (iterator.hasNext()) {
                int index = iterator.next();
                int op = iterator.byteAt(index);
                if (op != opcode || removeIndex >= 0 && removeIndex != currentIndex++) continue;
                for (int i = 0; i <= index; ++i) {
                    iterator.writeByte(0, i);
                }
                ++removed;
                PatcherLog.trace("Removed until " + index);
                if (removeIndex != -2) continue;
                break;
            }
            methodInfo.rebuildStackMapIf6(ctClass.getClassPool(), ctClass.getClassFile());
        }
        if (removed == 0) {
            PatcherLog.warn("Didn't remove until " + attributes.get("opcode") + ':' + opcode + " at " + removeIndex + " in " + ctBehavior.getName() + ", no matches.");
        }
    }

    private void removeAfterIndex(CtBehavior ctBehavior, int index) throws BadBytecode {
        PatcherLog.trace("Removed after opcode index " + index + " in " + ctBehavior.getLongName());
        CtClass ctClass = ctBehavior.getDeclaringClass();
        MethodInfo methodInfo = ctBehavior.getMethodInfo2();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute != null) {
            int i;
            CodeIterator iterator = codeAttribute.iterator();
            int length = iterator.getCodeLength() - 1;
            for (i = index; i < length; ++i) {
                iterator.writeByte(0, i);
            }
            iterator.writeByte(177, i);
            methodInfo.rebuildStackMapIf6(ctClass.getClassPool(), ctClass.getClassFile2());
        }
    }

    @Patch(requiredAttributes="field", emptyConstructor=false)
    public void removeInitializers(Object o, Map<String, String> attributes) throws NotFoundException, CannotCompileException {
        if (o instanceof CtClass) {
            CtField ctField = ((CtClass)o).getDeclaredField(attributes.get("field"));
            for (CtBehavior ctBehavior : ((CtClass)o).getDeclaredBehaviors()) {
                this.removeInitializers(ctBehavior, ctField);
            }
        } else {
            this.removeInitializers((CtBehavior)o, ((CtBehavior)o).getDeclaringClass().getDeclaredField(attributes.get("field")));
        }
    }

    private void removeInitializers(CtBehavior ctBehavior, CtField ctField) throws CannotCompileException, NotFoundException {
        this.replaceFieldInitializer(ctBehavior, CollectionsUtil.listToMap("field", ctField.getName(), "code", "{ $_ = null; }", "silent", "true"));
        this.replaceFieldAccess(ctBehavior, CollectionsUtil.listToMap("field", ctField.getName(), "writeCode", "{ }", "readCode", "{ $_ = null; }", "silent", "true"));
    }

    @Patch(requiredAttributes="field,threadLocalField,type")
    public void replaceFieldWithThreadLocal(CtClass ctClass, Map<String, String> attributes) throws CannotCompileException {
        final String field = attributes.get("field");
        final String threadLocalField = attributes.get("threadLocalField");
        final String type = attributes.get("type");
        String setExpression_ = attributes.get("setExpression");
        final String setExpression = setExpression_ == null ? '(' + type + ") $1" : setExpression_;
        ctClass.instrument(new ExprEditor(){

            public void edit(FieldAccess e) throws CannotCompileException {
                if (e.getFieldName().equals(field)) {
                    if (e.isReader()) {
                        e.replace("{ $_ = (" + type + ") " + threadLocalField + ".get(); }");
                    } else if (e.isWriter()) {
                        e.replace("{ " + threadLocalField + ".set(" + setExpression + "); }");
                    }
                }
            }
        });
    }

    @Patch(emptyConstructor=false)
    public void setPublic(Object o, Map<String, String> attributes) throws NotFoundException {
        String field = attributes.get("field");
        if (field != null) {
            CtClass ctClass = (CtClass)o;
            CtField ctField = ctClass.getDeclaredField(field);
            ctField.setModifiers(Modifier.setPublic((int)ctField.getModifiers()));
        } else if (o instanceof CtClass) {
            CtClass ctClass = (CtClass)o;
            ctClass.setModifiers(Modifier.setPublic((int)ctClass.getModifiers()));
            ArrayList toPublic = new ArrayList();
            if (attributes.containsKey("all")) {
                Collections.addAll(toPublic, ctClass.getDeclaredFields());
                Collections.addAll(toPublic, ctClass.getDeclaredBehaviors());
            } else {
                Collections.addAll(toPublic, ctClass.getDeclaredConstructors());
            }
            for (Object o_ : toPublic) {
                this.setPublic(o_, Collections.emptyMap());
            }
        } else if (o instanceof CtField) {
            CtField ctField = (CtField)o;
            ctField.setModifiers(Modifier.setPublic((int)ctField.getModifiers()));
        } else {
            CtBehavior ctBehavior = (CtBehavior)o;
            ctBehavior.setModifiers(Modifier.setPublic((int)ctBehavior.getModifiers()));
        }
    }

    @Patch(requiredAttributes="code")
    public void addStaticInitializer(CtClass ctClass, Map<String, String> attributes) throws CannotCompileException {
        ctClass.makeClassInitializer().insertAfter(attributes.get("code"));
    }

    @Patch(requiredAttributes="field")
    public void addInitializer(CtClass ctClass, Map<String, String> attributes) throws NotFoundException, CannotCompileException, IOException {
        String field = attributes.get("field");
        String clazz = attributes.get("fieldClass");
        String initialise = attributes.get("code");
        String arraySize = attributes.get("arraySize");
        initialise = "{ " + field + " = " + (initialise == null ? "new " + clazz + (arraySize == null ? "()" : '[' + arraySize + ']') : initialise) + "; }";
        if ((ctClass.getDeclaredField(field).getModifiers() & 8) == 8) {
            ctClass.makeClassInitializer().insertAfter(initialise);
        } else {
            CtMethod runConstructors;
            try {
                runConstructors = ctClass.getDeclaredMethod("runConstructors");
            }
            catch (NotFoundException e) {
                runConstructors = CtNewMethod.make((String)"public void runConstructors() { }", (CtClass)ctClass);
                ctClass.addMethod(runConstructors);
                ctClass.addField(new CtField(this.classPool.get("boolean"), "isConstructed", ctClass), CtField.Initializer.constant((boolean)false));
                for (CtConstructor ctBehavior : ctClass.getDeclaredConstructors()) {
                    ctBehavior.insertAfter("{ if(!this.isConstructed) { this.isConstructed = true; this.runConstructors(); } }");
                }
            }
            runConstructors.insertAfter(initialise);
        }
    }

    @Patch(requiredAttributes="field,fieldClass")
    public void addField(CtClass ctClass, Map<String, String> attributes) throws NotFoundException, CannotCompileException, IOException {
        String field = attributes.get("field");
        String clazz = attributes.get("fieldClass");
        String initialise = attributes.get("code");
        if (initialise == null) {
            initialise = "new " + clazz + "();";
        }
        try {
            CtField ctField = ctClass.getDeclaredField(field);
            PatcherLog.warn(field + " already exists as " + ctField);
            return;
        }
        catch (NotFoundException ctField) {
            CtClass newType = this.classPool.get(clazz);
            CtField ctField2 = new CtField(newType, field, ctClass);
            if (attributes.get("static") != null) {
                ctField2.setModifiers(ctField2.getModifiers() | 8);
            }
            ctField2.setModifiers(Modifier.setPublic((int)ctField2.getModifiers()));
            if ("none".equalsIgnoreCase(initialise)) {
                ctClass.addField(ctField2);
            } else {
                CtField.Initializer initializer = CtField.Initializer.byExpr((String)initialise);
                ctClass.addField(ctField2, initializer);
            }
            return;
        }
    }

    @Patch(requiredAttributes="code")
    public void insertCodeBefore(CtBehavior ctBehavior, Map<String, String> attributes) throws NotFoundException, CannotCompileException, IOException {
        String field = attributes.get("field");
        String code = attributes.get("code");
        if (field != null) {
            code = code.replace("$field", field);
        }
        ctBehavior.insertBefore(code);
    }

    @Patch(requiredAttributes="code")
    public void insertCodeAfter(CtBehavior ctBehavior, Map<String, String> attributes) throws NotFoundException, CannotCompileException, IOException {
        String field = attributes.get("field");
        String code = attributes.get("code");
        if (field != null) {
            code = code.replace("$field", field);
        }
        ctBehavior.insertAfter(code, attributes.containsKey("finally"));
    }

    @Patch(requiredAttributes="field")
    public void lock(CtMethod ctMethod, Map<String, String> attributes) throws NotFoundException, CannotCompileException, IOException {
        String field = attributes.get("field");
        ctMethod.insertBefore("this." + field + ".lock();");
        ctMethod.insertAfter("this." + field + ".unlock();", true);
    }

    @Patch(requiredAttributes="field")
    public void lockMethodCall(final CtBehavior ctBehavior, Map<String, String> attributes) throws CannotCompileException {
        String index_;
        String method_ = attributes.get("method");
        if (method_ == null) {
            method_ = "";
        }
        String className_ = null;
        int dotIndex = method_.indexOf(46);
        if (dotIndex != -1) {
            className_ = method_.substring(0, dotIndex);
            method_ = method_.substring(dotIndex + 1);
        }
        if ((index_ = attributes.get("index")) == null) {
            index_ = "-1";
        }
        final String method = method_;
        final String className = className_;
        final String field = attributes.get("field");
        final int index = Integer.valueOf(index_);
        final IntHolder replaced = new IntHolder();
        ctBehavior.instrument(new ExprEditor(){
            private int currentIndex = 0;

            public void edit(MethodCall methodCall) throws CannotCompileException {
                if (!(className != null && !methodCall.getClassName().equals(className) || !method.isEmpty() && !methodCall.getMethodName().equals(method) || index != -1 && this.currentIndex++ != index)) {
                    PatcherLog.trace("Replaced " + methodCall.getMethodName() + " from " + ctBehavior);
                    methodCall.replace("{ " + field + ".lock(); try { $_ =  $proceed($$); } finally { " + field + ".unlock(); } }");
                    ++replaced.value;
                }
            }
        });
        if (replaced.value == 0) {
            PatcherLog.warn("0 replacements made locking method call " + attributes.get("method") + " in " + ctBehavior.getLongName());
        }
    }

    @Patch(requiredAttributes="field")
    public void synchronizeMethodCall(final CtBehavior ctBehavior, Map<String, String> attributes) throws CannotCompileException {
        String index_;
        String method_ = attributes.get("method");
        if (method_ == null) {
            method_ = "";
        }
        String className_ = null;
        int dotIndex = method_.indexOf(46);
        if (dotIndex != -1) {
            className_ = method_.substring(0, dotIndex);
            method_ = method_.substring(dotIndex + 1);
        }
        if ((index_ = attributes.get("index")) == null) {
            index_ = "-1";
        }
        final String method = method_;
        final String className = className_;
        final String field = attributes.get("field");
        final int index = Integer.valueOf(index_);
        final IntHolder replaced = new IntHolder();
        ctBehavior.instrument(new ExprEditor(){
            private int currentIndex = 0;

            public void edit(MethodCall methodCall) throws CannotCompileException {
                if (!(className != null && !methodCall.getClassName().equals(className) || !method.isEmpty() && !methodCall.getMethodName().equals(method) || index != -1 && this.currentIndex++ != index)) {
                    PatcherLog.trace("Replaced " + methodCall.getMethodName() + " from " + ctBehavior);
                    methodCall.replace("synchronized(" + field + ") { $_ =  $0.$proceed($$); }");
                    ++replaced.value;
                }
            }
        });
        if (replaced.value == 0) {
            PatcherLog.warn("0 replacements made synchronizing method call " + attributes.get("method") + " in " + ctBehavior.getLongName());
        }
    }

    @Patch(emptyConstructor=false)
    public void setSynchronized(Object o, Map<String, String> attributes) throws CannotCompileException {
        if (!(o instanceof CtConstructor)) {
            if (o instanceof CtMethod) {
                this.synchronize((CtMethod)o, attributes.get("field"));
            } else {
                int synchronized_ = 0;
                boolean static_ = attributes.containsKey("static");
                for (CtMethod ctMethod : ((CtClass)o).getDeclaredMethods()) {
                    boolean isStatic;
                    boolean bl = isStatic = (ctMethod.getModifiers() & 8) == 8;
                    if (isStatic != static_) continue;
                    this.synchronize(ctMethod, attributes.get("field"));
                    ++synchronized_;
                }
                if (synchronized_ == 0) {
                    PatcherLog.error("Nothing synchronized - did you forget the 'static' attribute?");
                } else {
                    PatcherLog.trace("Synchronized " + synchronized_ + " methods in " + ((CtClass)o).getName());
                }
            }
        }
    }

    @Patch
    public void unsetSynchronized(CtBehavior ctBehavior) {
        ctBehavior.setModifiers(ctBehavior.getModifiers() & 0xFFFFFFDF);
    }

    @Patch(requiredAttributes="to")
    public void clone(CtMethod method, Map<String, String> attributes) throws CannotCompileException {
        String to = attributes.get("to");
        CtMethod copy = CtNewMethod.copy((CtMethod)method, (CtClass)method.getDeclaringClass(), null);
        copy.setName(to);
        method.getDeclaringClass().addMethod(copy);
    }

    private void synchronize(CtMethod ctMethod, String field) throws CannotCompileException {
        if (field == null) {
            int currentModifiers = ctMethod.getModifiers();
            if (Modifier.isSynchronized((int)currentModifiers)) {
                PatcherLog.warn("Method: " + ctMethod.getLongName() + " is already synchronized");
            } else {
                ctMethod.setModifiers(currentModifiers | 0x20);
            }
        } else {
            CtClass ctClass = ctMethod.getDeclaringClass();
            CtMethod replacement = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctClass, null);
            int i = 0;
            try {
                while (true) {
                    ctClass.getDeclaredMethod(ctMethod.getName() + "_sync" + i);
                    ++i;
                }
            }
            catch (NotFoundException notFoundException) {
                ctMethod.setName(ctMethod.getName() + "_sync" + i);
                List attributes = ctMethod.getMethodInfo().getAttributes();
                Iterator attributeInfoIterator = attributes.iterator();
                while (attributeInfoIterator.hasNext()) {
                    AttributeInfo attributeInfo = (AttributeInfo)attributeInfoIterator.next();
                    if (!(attributeInfo instanceof AnnotationsAttribute)) continue;
                    attributeInfoIterator.remove();
                    replacement.getMethodInfo().addAttribute(attributeInfo);
                }
                replacement.setBody("synchronized(" + field + ") { return " + ctMethod.getName() + "($$); }");
                replacement.setModifiers(replacement.getModifiers() & 0xFFFFFFDF);
                ctClass.addMethod(replacement);
            }
        }
    }

    @Patch
    public void catchAndIgnoreExceptions(CtMethod ctMethod, Map<String, String> attributes) throws CannotCompileException, NotFoundException {
        String exceptionType;
        String returnCode = attributes.get("code");
        if (returnCode == null) {
            returnCode = "return;";
        }
        if ((exceptionType = attributes.get("exceptionClass")) == null) {
            exceptionType = "java.lang.Throwable";
        }
        PatcherLog.trace("Ignoring " + exceptionType + " in " + ctMethod + ", returning with " + returnCode);
        ctMethod.addCatch("{ " + returnCode + '}', this.classPool.get(exceptionType));
    }

    @Patch
    public void lockToSynchronized(CtBehavior ctBehavior) throws BadBytecode {
        CtClass ctClass = ctBehavior.getDeclaringClass();
        MethodInfo methodInfo = ctBehavior.getMethodInfo();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        CodeIterator iterator = codeAttribute.iterator();
        ConstPool constPool = codeAttribute.getConstPool();
        int done = 0;
        while (iterator.hasNext()) {
            boolean remove;
            String name;
            int mref;
            int pos = iterator.next();
            int op = iterator.byteAt(pos);
            if (op == 185) {
                mref = iterator.u16bitAt(pos + 1);
                if (!constPool.getInterfaceMethodrefClassName(mref).endsWith("Lock")) continue;
                name = constPool.getInterfaceMethodrefName(mref);
                remove = false;
                if ("lock".equals(name)) {
                    remove = true;
                    iterator.writeByte(194, pos);
                } else if ("unlock".equals(name)) {
                    remove = true;
                    iterator.writeByte(195, pos);
                }
                if (!remove) continue;
                ++done;
                iterator.writeByte(0, pos + 1);
                iterator.writeByte(0, pos + 2);
                iterator.writeByte(0, pos + 3);
                iterator.writeByte(0, pos + 4);
                continue;
            }
            if (op != 182 || !constPool.getMethodrefClassName(mref = iterator.u16bitAt(pos + 1)).endsWith("NativeMutex")) continue;
            name = constPool.getMethodrefName(mref);
            remove = false;
            if ("lock".equals(name)) {
                remove = true;
                iterator.writeByte(194, pos);
            } else if ("unlock".equals(name)) {
                remove = true;
                iterator.writeByte(195, pos);
            }
            if (!remove) continue;
            ++done;
            iterator.writeByte(0, pos + 1);
            iterator.writeByte(0, pos + 2);
        }
        methodInfo.rebuildStackMapIf6(ctClass.getClassPool(), ctClass.getClassFile2());
        PatcherLog.trace("Replaced " + done + " lock/unlock calls.");
    }

    private static class ExceptionsArentForControlFlow
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private ExceptionsArentForControlFlow() {
        }
    }
}

