/*
 * Decompiled with CFR 0.152.
 */
package com.foom.oneclickcrafting;

import com.foom.oneclickcrafting.GuiCommonMethods;
import com.foom.oneclickcrafting.MyShapedRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class Recipes {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final ArrayList<MyShapedRecipe> recipesList = new ArrayList();

    private static void loadRecipes() {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (int i = 0; i < recipes.size(); ++i) {
            int order;
            Object recipeI = recipes.get(i);
            if (recipeI instanceof ShapedRecipes) {
                ShapedRecipes sRecipe = (ShapedRecipes)recipeI;
                recipesList.add(new MyShapedRecipe(sRecipe.field_77576_b, sRecipe.field_77577_c, sRecipe.field_77574_d, sRecipe.func_77571_b()));
                continue;
            }
            if (recipeI instanceof ShapelessRecipes) {
                ShapelessRecipes slRecipe = (ShapelessRecipes)recipeI;
                ItemStack[] temp = new ItemStack[slRecipe.func_77570_a()];
                int order2 = 0;
                for (Object o : slRecipe.field_77579_b) {
                    temp[order2++] = (ItemStack)o;
                }
                int wh = 2;
                if (slRecipe.func_77570_a() > 4) {
                    wh = 3;
                }
                recipesList.add(new MyShapedRecipe(wh, wh, temp, slRecipe.func_77571_b()));
                continue;
            }
            if (recipeI instanceof ShapedOreRecipe) {
                ShapedOreRecipe sORecipe = (ShapedOreRecipe)recipeI;
                boolean ok = true;
                ItemStack[] temp = new ItemStack[sORecipe.func_77570_a()];
                order = 0;
                for (Object o : sORecipe.getInput()) {
                    if (o == null) {
                        ++order;
                        continue;
                    }
                    if (o instanceof ItemStack) {
                        temp[order++] = (ItemStack)o;
                        continue;
                    }
                    if (!(o instanceof List)) continue;
                    List lo = (List)o;
                    int loSize = lo.size();
                    if (loSize == 0) {
                        temp[order++] = null;
                        continue;
                    }
                    if (loSize == 1) {
                        temp[order++] = (ItemStack)((List)o).get(0);
                        continue;
                    }
                    ok = false;
                }
                int width = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)sORecipe, (String[])new String[]{"width"});
                int height = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)sORecipe, (String[])new String[]{"height"});
                if (!ok) continue;
                recipesList.add(new MyShapedRecipe(width, height, temp, sORecipe.func_77571_b()));
                continue;
            }
            if (!(recipeI instanceof ShapelessOreRecipe)) continue;
            ShapelessOreRecipe slORecipe = (ShapelessOreRecipe)recipeI;
            boolean ok = true;
            ItemStack[] temp = new ItemStack[slORecipe.func_77570_a()];
            order = 0;
            for (Object o : slORecipe.getInput()) {
                if (o instanceof ItemStack) {
                    temp[order++] = (ItemStack)o;
                    continue;
                }
                if (!(o instanceof List)) continue;
                List lo = (List)o;
                int loSize = lo.size();
                if (loSize == 0) {
                    ok = false;
                    continue;
                }
                if (loSize == 1) {
                    temp[order++] = (ItemStack)((List)o).get(0);
                    continue;
                }
                ok = false;
            }
            int wh = 2;
            if (slORecipe.func_77570_a() > 4) {
                wh = 3;
            }
            if (!ok) continue;
            recipesList.add(new MyShapedRecipe(wh, wh, temp, slORecipe.func_77571_b()));
        }
    }

    private static int inventorySearch(ItemStack itemStackToFind) {
        ItemStack[] inventorySlots = Recipes.mc.field_71439_g.field_71071_by.field_70462_a;
        int end = inventorySlots.length;
        int start = 0;
        int result = 0;
        for (int i = start; i < end; ++i) {
            ItemStack itemStackInInventory = inventorySlots[i];
            if (itemStackInInventory == null || itemStackToFind.func_77973_b() != itemStackInInventory.func_77973_b() || itemStackInInventory.func_77952_i() != itemStackToFind.func_77952_i() && itemStackToFind.func_77952_i() != Short.MAX_VALUE) continue;
            result += itemStackInInventory.field_77994_a;
        }
        return result;
    }

    private static int recipeSearch(MyShapedRecipe recipe) {
        int max = 2304;
        for (ItemStack itemStack : recipe.itemAmounts.keySet()) {
            int temp = Recipes.inventorySearch(itemStack) / recipe.itemAmounts.get(itemStack);
            if (temp >= max) continue;
            max = temp;
        }
        return max;
    }

    public static void search(boolean isCraftingTalbe) {
        for (int i = 0; i < recipesList.size(); ++i) {
            int maxCycles;
            MyShapedRecipe recipeI = recipesList.get(i);
            if (!isCraftingTalbe && (recipeI.recipeWidth >= 3 || recipeI.recipeHeight >= 3) || (maxCycles = Recipes.recipeSearch(recipeI)) <= 0) continue;
            GuiCommonMethods.recipeList.add(recipeI);
            GuiCommonMethods.maxCyclesList.add(maxCycles);
        }
    }

    static {
        Recipes.loadRecipes();
    }
}

