/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.minimallycorrect.javatransformer.api.Type;
import org.minimallycorrect.javatransformer.internal.util.JVMUtil;

public class Annotation {
    @NonNull
    public final Type type;
    @NonNull
    public final Map<String, Object> values;

    public static Annotation of(Type t, Map<String, Object> value) {
        return new Annotation(t, new HashMap<String, Object>(value));
    }

    public static Annotation of(Type t, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("value", value);
        return Annotation.of(t, map);
    }

    public static Annotation of(Type t) {
        return Annotation.of(t, Collections.emptyMap());
    }

    @Nullable
    public <T> T get(String key, Class<T> clazz) {
        Object value = this.values.get(key);
        if (value == null) {
            return null;
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        if (clazz.isEnum()) {
            if (!(value instanceof String[])) {
                throw new IllegalArgumentException("value for " + key + " is not a String[] so can't be mapped to enum. Actual type " + value.getClass().getName() + " value " + value);
            }
            Object[] array = (String[])value;
            Type type = new Type(array[0]);
            if (!type.getClassName().endsWith(clazz.getName())) {
                throw new IllegalArgumentException("value for " + key + " is of enum type " + type + " which does not match expected type " + clazz.getName() + " actual value " + Arrays.toString(array));
            }
            return JVMUtil.searchEnum(clazz, array[1]);
        }
        throw new UnsupportedOperationException("Can't convert enum value of type " + value.getClass().getName() + " value " + value + " to " + clazz.getName());
    }

    public void set(String key, Object value) {
        Class<?> clazz;
        if (value != null && (clazz = value.getClass()).isEnum()) {
            value = new String[]{Type.of((String)clazz.getName()).descriptor, ((Enum)value).name()};
        }
        this.values.put(key, value);
    }

    public <T extends java.lang.annotation.Annotation> T toInstance(Class<T> clazz) {
        if (!clazz.isAnnotation()) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not an annotation");
        }
        if (!clazz.getName().equals(this.type.getClassName())) {
            throw new IllegalArgumentException("Type " + this.type + " can't be mapped to annotation class " + clazz);
        }
        return (T)((java.lang.annotation.Annotation)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new AnnotationProxy(clazz)));
    }

    @NonNull
    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Annotation)) {
            return false;
        }
        Annotation other = (Annotation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Map<String, Object> this$values = this.values;
        Map<String, Object> other$values = other.values;
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Annotation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Map<String, Object> $values = this.values;
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public String toString() {
        return "Annotation(type=" + this.getType() + ", values=" + this.values + ")";
    }

    protected Annotation(@NonNull Type type, @NonNull Map<String, Object> values) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (values == null) {
            throw new NullPointerException("values");
        }
        this.type = type;
        this.values = values;
    }

    private final class AnnotationProxy
    implements InvocationHandler,
    java.lang.annotation.Annotation {
        final Class<? extends java.lang.annotation.Annotation> annotationType;

        @Override
        public Class<? extends java.lang.annotation.Annotation> annotationType() {
            return this.annotationType;
        }

        @Override
        public String toString() {
            return '@' + this.annotationType.toString() + '(' + Annotation.this.values.toString() + ')';
        }

        @Override
        public int hashCode() {
            return this.toString().hashCode();
        }

        @Override
        public boolean equals(Object other) {
            return other != null && other.getClass() == AnnotationProxy.class && this.toString().equals(other);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object value;
            if (!Modifier.isPublic(method.getModifiers())) {
                return method.invoke((Object)this, args);
            }
            String key = method.getName();
            Class<?> returnType = method.getReturnType();
            Object object = value = returnType.isPrimitive() ? Annotation.this.values.get(key) : Annotation.this.get(key, returnType);
            if (value == null) {
                value = method.getDefaultValue();
            }
            if (value == null) {
                return method.invoke((Object)this, args);
            }
            return value;
        }

        public AnnotationProxy(Class<? extends java.lang.annotation.Annotation> annotationType) {
            this.annotationType = annotationType;
        }
    }
}

