/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.api;

import java.util.Arrays;
import java.util.List;
import org.minimallycorrect.javatransformer.api.AccessFlags;
import org.minimallycorrect.javatransformer.api.ClassMember;
import org.minimallycorrect.javatransformer.api.HasTypeVariable;
import org.minimallycorrect.javatransformer.api.Parameter;
import org.minimallycorrect.javatransformer.api.Type;
import org.minimallycorrect.javatransformer.api.TypeVariable;
import org.minimallycorrect.javatransformer.internal.SimpleMethodInfo;

public interface MethodInfo
extends ClassMember,
HasTypeVariable,
Cloneable {
    public static MethodInfo of(AccessFlags accessFlags, List<TypeVariable> typeVariables, Type returnType, String name, Parameter ... parameters) {
        return MethodInfo.of(accessFlags, typeVariables, returnType, name, Arrays.asList(parameters));
    }

    public static MethodInfo of(AccessFlags accessFlags, List<TypeVariable> typeVariables, Type returnType, String name, List<Parameter> parameters) {
        return SimpleMethodInfo.of(accessFlags, typeVariables, returnType, name, parameters);
    }

    public Type getReturnType();

    public void setReturnType(Type var1);

    public List<Parameter> getParameters();

    public void setParameters(List<Parameter> var1);

    default public void setAll(MethodInfo info) {
        this.setName(info.getName());
        this.setAccessFlags(info.getAccessFlags());
        this.setReturnType(info.getReturnType());
        this.setParameters(info.getParameters());
        this.setTypeVariables(info.getTypeVariables());
    }

    default public boolean similar(MethodInfo other) {
        return other.getName().equals(this.getName()) && other.getReturnType().similar(this.getReturnType()) && (other.getParameters() == null || this.getParameters() == null || other.getParameters().equals(this.getParameters()));
    }

    default public MethodInfo clone() {
        throw new UnsupportedOperationException();
    }

    default public boolean isConstructor() {
        return this.getName().equals("<init>");
    }
}

