/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.internal;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.ast.type.VoidType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.minimallycorrect.javatransformer.api.ClassPath;
import org.minimallycorrect.javatransformer.api.TransformationException;
import org.minimallycorrect.javatransformer.api.Type;
import org.minimallycorrect.javatransformer.api.TypeVariable;
import org.minimallycorrect.javatransformer.internal.util.JVMUtil;
import org.minimallycorrect.javatransformer.internal.util.Joiner;
import org.minimallycorrect.javatransformer.internal.util.NodeUtil;
import org.minimallycorrect.javatransformer.internal.util.Splitter;

public class ResolutionContext {
    @NonNull
    private final String packageName;
    @NonNull
    private final List<ImportDeclaration> imports;
    @NonNull
    private final Iterable<TypeParameter> typeParameters;
    @NonNull
    private final ClassPath classPath;

    private ResolutionContext(String packageName, List<ImportDeclaration> imports, Iterable<TypeParameter> typeParameters, ClassPath classPath) {
        this.packageName = packageName;
        this.imports = imports;
        this.typeParameters = typeParameters;
        this.classPath = classPath;
    }

    public static ResolutionContext of(String packageName, List<ImportDeclaration> imports, Iterable<TypeParameter> typeParameters, ClassPath classPath) {
        return new ResolutionContext(packageName, imports, typeParameters, classPath);
    }

    public static ResolutionContext of(Node targetNode, Node outerClassNode, ClassPath classPath) {
        CompilationUnit cu = NodeUtil.getParentNode(outerClassNode, CompilationUnit.class);
        String packageName = NodeUtil.qualifiedName(((PackageDeclaration)cu.getPackageDeclaration().get()).getName());
        List<TypeParameter> typeParameters = NodeUtil.getTypeParameters(targetNode);
        return new ResolutionContext(packageName, (List<ImportDeclaration>)cu.getImports(), typeParameters, classPath);
    }

    public static ResolutionContext of(Node node, ClassPath classPath) {
        return ResolutionContext.of(node, node, classPath);
    }

    private static boolean hasPackages(String name) {
        return !Character.isUpperCase(name.charAt(0)) && name.indexOf(46) != -1;
    }

    @Nullable
    public static String extractGeneric(@Nullable String name) {
        if (name == null) {
            return null;
        }
        int leftBracket = name.indexOf(60);
        int rightBracket = name.lastIndexOf(62);
        if (leftBracket == -1 && rightBracket == -1) {
            return null;
        }
        if (leftBracket != -1 && leftBracket < rightBracket) {
            return name.substring(leftBracket + 1, rightBracket);
        }
        throw new TransformationException("Mismatched angled brackets in: " + name);
    }

    public static String extractReal(String name) {
        int bracket = name.indexOf(60);
        return bracket == -1 ? name : name.substring(0, bracket);
    }

    static Type sanityCheck(Type type) {
        if (type.isClassType() && (type.getClassName().endsWith(".") || !type.getClassName().contains("."))) {
            throw new TransformationException("Unexpected class name (incorrect dots) in type: " + type);
        }
        return type;
    }

    private static String toString(ImportDeclaration importDeclaration) {
        return (importDeclaration.isStatic() ? "static " : "") + ResolutionContext.classOf(importDeclaration) + (importDeclaration.isAsterisk() ? ".*" : "");
    }

    private static String classOf(ImportDeclaration importDeclaration) {
        return NodeUtil.qualifiedName(importDeclaration.getName());
    }

    public static com.github.javaparser.ast.type.Type typeToJavaParserType(Type t) {
        if (t.isPrimitiveType()) {
            String primitiveName = t.getPrimitiveTypeName();
            if (primitiveName.equals(Type.DescriptorType.VOID.getPrimitiveName())) {
                return new VoidType();
            }
            return new PrimitiveType(JVMUtil.searchEnum(PrimitiveType.Primitive.class, t.getPrimitiveTypeName()));
        }
        if (t.isArrayType()) {
            return new ArrayType(ResolutionContext.typeToJavaParserType(t.getArrayContainedType()), new AnnotationExpr[0]);
        }
        if (t.isPrimitiveType()) {
            return new PrimitiveType();
        }
        if (!t.isClassType()) {
            throw new UnsupportedOperationException(t + " is not a class type");
        }
        if (t.isTypeParameter()) {
            return ResolutionContext.nonGenericClassOrInterfaceType(t.getTypeParameterName());
        }
        ClassOrInterfaceType type = ResolutionContext.nonGenericClassOrInterfaceType(t.getClassName());
        if (t.hasTypeArguments()) {
            type.setTypeArguments(NodeList.nodeList((Collection)t.getTypeArguments().stream().map(ResolutionContext::typeToJavaParserType).collect(Collectors.toList())));
        }
        return type;
    }

    public static ClassOrInterfaceType nonGenericClassOrInterfaceType(String name) {
        return new ClassOrInterfaceType(name);
    }

    public Type resolve(com.github.javaparser.ast.type.Type type) {
        if (type instanceof PrimitiveType) {
            return new Type(JVMUtil.primitiveTypeToDescriptor(((PrimitiveType)type).getType().name().toLowerCase()));
        }
        if (type instanceof VoidType) {
            return new Type("V");
        }
        return this.resolve(type.asString());
    }

    @Nullable
    public Type resolve(String name) {
        if (name == null) {
            return null;
        }
        int arrayCount = 0;
        while (name.length() > 1 && name.lastIndexOf("[]") == name.length() - 2) {
            ++arrayCount;
            name = name.substring(0, name.length() - 2);
        }
        String real = ResolutionContext.extractReal(name);
        Type type = this.resolveReal(real);
        String generic = ResolutionContext.extractGeneric(name);
        List genericTypes = null;
        if ("".equals(generic)) {
            generic = null;
        }
        if (generic != null) {
            genericTypes = Splitter.commaSplitter.split(generic).map(this::resolve).collect(Collectors.toList());
        }
        if (type == null || generic != null && (genericTypes.isEmpty() || genericTypes.stream().anyMatch(Objects::isNull))) {
            throw new TransformationException("Couldn't resolve name: " + name + "\nFound real type: " + type + "\nGeneric types: " + genericTypes + "\nImports:" + this.imports.stream().map(ResolutionContext::toString).collect(Collectors.toList()) + "\nClassPath: " + this.classPath);
        }
        if (generic != null) {
            type = type.withTypeArguments(genericTypes);
        }
        if (arrayCount != 0) {
            type = type.withArrayCount(arrayCount);
        }
        return ResolutionContext.sanityCheck(type);
    }

    @Nullable
    private Type resolveReal(String name) {
        String primitive = JVMUtil.primitiveTypeToDescriptor(name, true);
        if (primitive != null) {
            return new Type(primitive, null);
        }
        Type result = this.resolveTypeParameterType(name);
        if (result != null) {
            return result;
        }
        result = this.resolveClassType(name);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Nullable
    private Type resolveClassType(String name) {
        String dotName = name;
        String preDotName = null;
        String postDotName = null;
        if (name.indexOf(46) != -1) {
            int index = name.indexOf(46);
            preDotName = name.substring(0, index);
            postDotName = name.substring(index);
        } else {
            dotName = '.' + name;
        }
        for (ImportDeclaration anImport : this.imports) {
            String fullName;
            Type type;
            if (anImport.isAsterisk() || anImport.isStatic()) continue;
            String importName = ResolutionContext.classOf(anImport);
            if (importName.endsWith(dotName)) {
                return Type.of(importName);
            }
            if (preDotName == null || !importName.endsWith(preDotName) || (type = this.resolveIfExists(fullName = importName + postDotName)) == null) continue;
            return type;
        }
        Type type = this.resolveIfExists(this.packageName + '.' + name);
        if (type != null) {
            return type;
        }
        for (ImportDeclaration anImport : this.imports) {
            if (!anImport.isAsterisk() || anImport.isStatic() || (type = this.resolveIfExists(ResolutionContext.classOf(anImport) + '.' + name)) == null) continue;
            return type;
        }
        type = this.resolveIfExists("java.lang." + name);
        if (type != null) {
            return type;
        }
        if (!ResolutionContext.hasPackages(name) && !Objects.equals(System.getProperty("JarTransformer.allowDefaultPackage"), "true")) {
            return null;
        }
        return Type.of(name);
    }

    @Nullable
    private Type resolveIfExists(String s) {
        if (s.startsWith("java.") || s.startsWith("javax.")) {
            try {
                return Type.of(Class.forName(s).getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.classPath.classExists(s)) {
            return Type.of(s);
        }
        return null;
    }

    @Nullable
    private Type resolveTypeParameterType(String name) {
        for (TypeParameter typeParameter : this.typeParameters) {
            String typeName = typeParameter.getName().asString();
            if (!typeName.equals(name)) continue;
            NodeList bounds = typeParameter.getTypeBound();
            String extends_ = "Ljava/lang/Object;";
            if (bounds != null && !bounds.isEmpty()) {
                if (bounds.size() == 1) {
                    ClassOrInterfaceType scope = ((ClassOrInterfaceType)bounds.get(0)).getScope().orElse(null);
                    if (scope != null) {
                        extends_ = this.resolve((String)scope.getName().asString()).descriptor;
                    }
                } else {
                    throw new TransformationException("Bounds must have one object, found: " + bounds);
                }
            }
            return new Type(extends_, "T" + typeName + ";");
        }
        return null;
    }

    public String typeToString(Type t) {
        return this.typeToString(t, true);
    }

    public String typeToString(Type t, boolean unresolve) {
        if (t.isPrimitiveType()) {
            return t.getPrimitiveTypeName();
        }
        if (t.isTypeParameter()) {
            return t.getTypeParameterName();
        }
        String className = t.getClassName();
        if (unresolve) {
            className = this.typeToJavaParserType(className);
        }
        if (t.hasTypeArguments()) {
            className = className + '<' + Joiner.on(", ").join(t.getTypeArguments().stream().map(this::typeToString)) + '>';
        }
        return className;
    }

    public String typeToJavaParserType(String className) {
        for (ImportDeclaration anImport : this.imports) {
            String importName;
            if (anImport.isAsterisk() || anImport.isStatic() || !className.startsWith(importName = NodeUtil.qualifiedName(anImport.getName()))) continue;
            return className.replace(importName + ".", "");
        }
        return className;
    }

    public TypeVariable resolveTypeVariable(TypeParameter typeParameter) {
        Type bound;
        NodeList typeBound = typeParameter.getTypeBound();
        if (typeBound.size() == 1) {
            bound = this.resolve((com.github.javaparser.ast.type.Type)typeBound.get(0));
        } else if (typeParameter.getTypeBound().isEmpty()) {
            bound = Type.OBJECT;
        } else {
            throw new IllegalArgumentException("Can't resolve type variable from " + typeParameter + " with multiple bounds");
        }
        return new TypeVariable(typeParameter.getName().asString(), bound);
    }

    public TypeParameter unresolveTypeVariable(TypeVariable typeVariable) {
        if (typeVariable.getBounds().equals(Type.OBJECT)) {
            return new TypeParameter(typeVariable.getName(), NodeList.nodeList((Node[])new ClassOrInterfaceType[0]));
        }
        return new TypeParameter(typeVariable.getName(), NodeList.nodeList((Node[])new ClassOrInterfaceType[]{(ClassOrInterfaceType)ResolutionContext.typeToJavaParserType(typeVariable.getBounds())}));
    }

    @NonNull
    public String getPackageName() {
        return this.packageName;
    }

    @NonNull
    public List<ImportDeclaration> getImports() {
        return this.imports;
    }

    @NonNull
    public Iterable<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    @NonNull
    public ClassPath getClassPath() {
        return this.classPath;
    }
}

