/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.internal;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithParameters;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.ThrowStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.minimallycorrect.javatransformer.api.AccessFlags;
import org.minimallycorrect.javatransformer.api.Annotation;
import org.minimallycorrect.javatransformer.api.ClassInfo;
import org.minimallycorrect.javatransformer.api.ClassPath;
import org.minimallycorrect.javatransformer.api.FieldInfo;
import org.minimallycorrect.javatransformer.api.MethodInfo;
import org.minimallycorrect.javatransformer.api.TransformationException;
import org.minimallycorrect.javatransformer.api.Type;
import org.minimallycorrect.javatransformer.api.TypeVariable;
import org.minimallycorrect.javatransformer.internal.ResolutionContext;
import org.minimallycorrect.javatransformer.internal.SimpleFieldInfo;
import org.minimallycorrect.javatransformer.internal.SimpleMethodInfo;
import org.minimallycorrect.javatransformer.internal.util.AnnotationParser;
import org.minimallycorrect.javatransformer.internal.util.CachingSupplier;
import org.minimallycorrect.javatransformer.internal.util.NodeUtil;

public class SourceInfo
implements ClassInfo {
    private final Supplier<TypeDeclaration<?>> type;
    private final AtomicReference<Object> packageName = new AtomicReference();
    private String className;
    private ClassPath classPath;
    private final AtomicReference<Object> annotations = new AtomicReference();
    private final AtomicReference<Object> context = new AtomicReference();

    static void changeTypeContext(ResolutionContext old, ResolutionContext new_, FieldDeclaration f) {
        VariableDeclarator v = f.getVariable(0);
        v.setType(SourceInfo.changeTypeContext(old, new_, f.getCommonType()));
        Expression e = v.getInitializer().orElse(null);
        if (e != null) {
            NodeUtil.forChildren((Node)e, it -> {
                ClassOrInterfaceType t = (ClassOrInterfaceType)ResolutionContext.typeToJavaParserType(old.resolve((com.github.javaparser.ast.type.Type)it));
                it.setName(t.getName());
                it.setTypeArguments((NodeList)t.getTypeArguments().orElse(null));
            }, ClassOrInterfaceType.class);
        }
    }

    static com.github.javaparser.ast.type.Type changeTypeContext(ResolutionContext old, ResolutionContext new_, com.github.javaparser.ast.type.Type t) {
        Type current = old.resolve(t);
        if (current.isClassType()) {
            return ResolutionContext.typeToJavaParserType(current.remapClassNames(new_::typeToJavaParserType));
        }
        return t;
    }

    static void changeTypeContext(ResolutionContext old, ResolutionContext new_, MethodDeclaration m) {
        m.setType(SourceInfo.changeTypeContext(old, new_, m.getType()));
        m.setBody(new BlockStmt(NodeList.nodeList((Node[])new Statement[]{new ThrowStmt((Expression)new ObjectCreationExpr(null, ResolutionContext.nonGenericClassOrInterfaceType("UnsupportedOperationException"), NodeList.nodeList((Node[])new Expression[0])))})));
        NodeUtil.forChildren((Node)m, node -> {
            String name;
            Expression scope = node.getScope().orElse(null);
            if (scope instanceof NameExpr && Character.isUpperCase((name = ((NameExpr)scope).getName().asString()).charAt(0))) {
                node.setScope((Expression)new NameExpr(new_.typeToString(old.resolve(name))));
            }
        }, MethodCallExpr.class);
        NodeUtil.forChildren((Node)m, node -> node.getVariable(0).setType(SourceInfo.changeTypeContext(old, new_, node.getCommonType())), VariableDeclarationExpr.class);
        NodeUtil.forChildren((Node)m, node -> node.setType(SourceInfo.changeTypeContext(old, new_, node.getType())), TypeExpr.class);
        NodeUtil.forChildren((Node)m, node -> node.setType(SourceInfo.changeTypeContext(old, new_, node.getType())), Parameter.class);
    }

    private static List<org.minimallycorrect.javatransformer.api.Parameter> getParameters(NodeWithParameters<?> nodeWithParameters, Supplier<ResolutionContext> context) {
        return nodeWithParameters.getParameters().stream().map(parameter -> org.minimallycorrect.javatransformer.api.Parameter.of(((ResolutionContext)context.get()).resolve(parameter.getType()), parameter.getName().asString(), CachingSupplier.of(() -> SourceInfo.lambda$null$6(parameter, (Supplier)context)))).collect(Collectors.toList());
    }

    @Nullable
    private ClassOrInterfaceDeclaration getClassOrInterfaceDeclaration() {
        TypeDeclaration<?> declaration = this.type.get();
        return declaration instanceof ClassOrInterfaceDeclaration ? (ClassOrInterfaceDeclaration)declaration : null;
    }

    private String getPackageNameInternal() {
        return NodeUtil.qualifiedName(((PackageDeclaration)NodeUtil.getParentNode((Node)this.type.get(), CompilationUnit.class).getPackageDeclaration().get()).getName());
    }

    private ResolutionContext getContextInternal() {
        return ResolutionContext.of((Node)this.type.get(), this.classPath);
    }

    @Override
    public String getName() {
        return this.className;
    }

    @Override
    public void setName(String name) {
        String packageName = this.getPackageName();
        if (!name.startsWith(packageName)) {
            throw new TransformationException("Name '" + name + "' must be in package: " + packageName);
        }
        this.type.get().setName(name.replace(packageName, ""));
    }

    @Override
    public AccessFlags getAccessFlags() {
        return new AccessFlags(this.type.get().getModifiers());
    }

    @Override
    public void setAccessFlags(AccessFlags accessFlags) {
        this.type.get().setModifiers(accessFlags.toJavaParserModifierSet());
    }

    public String toString() {
        return "SourceInfo: " + this.getAccessFlags() + " " + this.getClassName();
    }

    @Override
    public void add(MethodInfo method) {
        MethodDeclaration declaration;
        if (method instanceof MethodDeclarationWrapper) {
            MethodDeclaration methodDeclaration;
            MethodDeclarationWrapper wrapper = (MethodDeclarationWrapper)method;
            declaration = methodDeclaration = wrapper.declaration.clone();
            methodDeclaration.setAnnotations(NodeList.nodeList((Node[])new AnnotationExpr[0]));
            SourceInfo.changeTypeContext(wrapper.getContext(), this.getContext(), methodDeclaration);
        } else if (method.isConstructor()) {
            ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration();
            String name = this.getName();
            constructorDeclaration.setName(new SimpleName(name.substring(name.lastIndexOf(46) + 1)));
            declaration = constructorDeclaration;
            new ConstructorDeclarationWrapper(constructorDeclaration).setAll(method);
        } else {
            MethodDeclaration methodDeclaration;
            declaration = methodDeclaration = new MethodDeclaration();
            new MethodDeclarationWrapper(methodDeclaration).setAll(method);
        }
        this.addMember((BodyDeclaration<?>)declaration);
    }

    @Override
    public void add(FieldInfo field) {
        FieldDeclaration fieldDeclaration;
        if (field instanceof FieldDeclarationWrapper) {
            FieldDeclarationWrapper wrapper = (FieldDeclarationWrapper)field;
            fieldDeclaration = wrapper.declaration.clone();
            fieldDeclaration.setAnnotations(NodeList.nodeList((Node[])new AnnotationExpr[0]));
            SourceInfo.changeTypeContext(wrapper.getContext(), this.getContext(), fieldDeclaration);
        } else {
            fieldDeclaration = new FieldDeclaration();
            fieldDeclaration.setVariables(NodeList.nodeList((Node[])new VariableDeclarator[]{new VariableDeclarator()}));
            new FieldDeclarationWrapper(fieldDeclaration).setAll(field);
        }
        this.addMember((BodyDeclaration<?>)fieldDeclaration);
        FieldDeclarationWrapper result = new FieldDeclarationWrapper(fieldDeclaration);
        if (!field.similar(result)) {
            throw new TransformationException("After adding to class, didn't match. added: " + field + " result: " + result);
        }
    }

    private void addMember(BodyDeclaration<?> bodyDeclaration) {
        bodyDeclaration.setParentNode((Node)this.type.get());
        this.type.get().getMembers().add(bodyDeclaration);
    }

    @Override
    public void remove(MethodInfo method) {
        MethodDeclarationWrapper methodDeclarationWrapper;
        MethodDeclarationWrapper methodDeclarationWrapper2 = methodDeclarationWrapper = !(method instanceof MethodDeclarationWrapper) ? (MethodDeclarationWrapper)this.get(method) : (MethodDeclarationWrapper)method;
        if (methodDeclarationWrapper == null) {
            throw new TransformationException("Method " + method + " can not be removed as it is not present");
        }
        this.type.get().getMembers().remove((Node)methodDeclarationWrapper.declaration);
    }

    @Override
    public void remove(FieldInfo field) {
        FieldDeclarationWrapper fieldDeclarationWrapper;
        FieldDeclarationWrapper fieldDeclarationWrapper2 = fieldDeclarationWrapper = !(field instanceof FieldDeclarationWrapper) ? (FieldDeclarationWrapper)this.get(field) : (FieldDeclarationWrapper)field;
        if (fieldDeclarationWrapper == null) {
            throw new TransformationException("Field " + field + " can not be removed as it is not present");
        }
        this.type.get().getMembers().remove((Node)fieldDeclarationWrapper.declaration);
    }

    @Override
    @Nullable
    public Type getSuperType() {
        ClassOrInterfaceDeclaration declaration = this.getClassOrInterfaceDeclaration();
        if (declaration == null) {
            return null;
        }
        NodeList extends_ = declaration.getExtendedTypes();
        if (extends_ == null || extends_.isEmpty()) {
            return null;
        }
        return this.getContext().resolve((com.github.javaparser.ast.type.Type)extends_.get(0));
    }

    @Override
    public List<Type> getInterfaceTypes() {
        ClassOrInterfaceDeclaration declaration = this.getClassOrInterfaceDeclaration();
        return declaration == null ? Collections.emptyList() : declaration.getImplementedTypes().stream().map(this.getContext()::resolve).collect(Collectors.toList());
    }

    @Override
    public Stream<MethodInfo> getMethods() {
        return this.type.get().getMembers().stream().map(this::getMethodInfoWrapper).filter(Objects::nonNull);
    }

    private MethodInfo getMethodInfoWrapper(BodyDeclaration<?> x) {
        if (x instanceof MethodDeclaration) {
            return new MethodDeclarationWrapper((MethodDeclaration)x);
        }
        if (x instanceof ConstructorDeclaration) {
            return new ConstructorDeclarationWrapper((ConstructorDeclaration)x);
        }
        return null;
    }

    @Override
    public Stream<FieldInfo> getFields() {
        return this.type.get().getMembers().stream().filter(x -> x instanceof FieldDeclaration).map(x -> new FieldDeclarationWrapper((FieldDeclaration)x));
    }

    private com.github.javaparser.ast.type.Type setType(Type newType, com.github.javaparser.ast.type.Type currentType) {
        NodeList annotations;
        com.github.javaparser.ast.type.Type newType_ = ResolutionContext.typeToJavaParserType(newType);
        if (currentType instanceof ClassOrInterfaceType && newType_ instanceof ClassOrInterfaceType && (annotations = currentType.getAnnotations()) != null && !annotations.isEmpty()) {
            newType_.setAnnotations(annotations);
        }
        return newType_;
    }

    private List<Annotation> getAnnotationsInternal() {
        return this.getAnnotationsInternal((List<AnnotationExpr>)this.type.get().getAnnotations());
    }

    private List<Annotation> getAnnotationsInternal(List<AnnotationExpr> l) {
        return l.stream().map(it -> AnnotationParser.annotationFromAnnotationExpr(it, this.getContext())).collect(Collectors.toList());
    }

    @Override
    public ClassInfo getClassInfo() {
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public ClassPath getClassPath() {
        return this.classPath;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setClassPath(ClassPath classPath) {
        this.classPath = classPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceInfo)) {
            return false;
        }
        SourceInfo other = (SourceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Supplier<TypeDeclaration<?>> this$type = this.type;
        Supplier<TypeDeclaration<?>> other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        ClassPath this$classPath = this.getClassPath();
        ClassPath other$classPath = other.getClassPath();
        if (this$classPath == null ? other$classPath != null : !this$classPath.equals(other$classPath)) {
            return false;
        }
        List<Annotation> this$annotations = this.getAnnotations();
        List<Annotation> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        ResolutionContext this$context = this.getContext();
        ResolutionContext other$context = other.getContext();
        return !(this$context == null ? other$context != null : !this$context.equals(other$context));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SourceInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Supplier<TypeDeclaration<?>> $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        ClassPath $classPath = this.getClassPath();
        result = result * 59 + ($classPath == null ? 43 : $classPath.hashCode());
        List<Annotation> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        ResolutionContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        return result;
    }

    public SourceInfo(Supplier<TypeDeclaration<?>> type, String className, ClassPath classPath) {
        this.type = type;
        this.className = className;
        this.classPath = classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPackageName() {
        Object value = this.packageName.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.packageName;
            synchronized (atomicReference) {
                value = this.packageName.get();
                if (value == null) {
                    String actualValue = this.getPackageNameInternal();
                    value = actualValue == null ? this.packageName : actualValue;
                    this.packageName.set(value);
                }
            }
        }
        return (String)(value == this.packageName ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Annotation> getAnnotations() {
        Object value = this.annotations.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.annotations;
            synchronized (atomicReference) {
                value = this.annotations.get();
                if (value == null) {
                    List<Annotation> actualValue = this.getAnnotationsInternal();
                    value = actualValue == null ? this.annotations : actualValue;
                    this.annotations.set(value);
                }
            }
        }
        return (List)(value == this.annotations ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolutionContext getContext() {
        Object value = this.context.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.context;
            synchronized (atomicReference) {
                value = this.context.get();
                if (value == null) {
                    ResolutionContext actualValue = this.getContextInternal();
                    value = actualValue == null ? this.context : actualValue;
                    this.context.set(value);
                }
            }
        }
        return (ResolutionContext)(value == this.context ? null : value);
    }

    private static /* synthetic */ List lambda$null$6(Parameter parameter, Supplier context) {
        return parameter.getAnnotations().stream().map(arg_0 -> SourceInfo.lambda$null$5((Supplier)context, arg_0)).collect(Collectors.toList());
    }

    private static /* synthetic */ Annotation lambda$null$5(Supplier context, AnnotationExpr it) {
        return AnnotationParser.annotationFromAnnotationExpr(it, (ResolutionContext)context.get());
    }

    public class ConstructorDeclarationWrapper
    implements MethodInfo {
        private final ConstructorDeclaration declaration;
        private ResolutionContext context;

        public ConstructorDeclarationWrapper(ConstructorDeclaration declaration) {
            this.declaration = declaration;
        }

        private ResolutionContext getContext() {
            if (this.context != null) {
                return this.context;
            }
            this.context = ResolutionContext.of((Node)this.declaration, (Node)SourceInfo.this.type.get(), SourceInfo.this.classPath);
            return this.context;
        }

        @Override
        public Type getReturnType() {
            return SourceInfo.this.getType();
        }

        @Override
        public void setReturnType(Type type) {
            if (!type.equals(this.getReturnType())) {
                throw new UnsupportedOperationException("Can't setReturnType of constructor");
            }
        }

        @Override
        public List<org.minimallycorrect.javatransformer.api.Parameter> getParameters() {
            return SourceInfo.getParameters((NodeWithParameters)this.declaration, this::getContext);
        }

        @Override
        public void setParameters(List<org.minimallycorrect.javatransformer.api.Parameter> parameters) {
            List javaParserParameters = parameters.stream().map(p -> new Parameter(ResolutionContext.typeToJavaParserType(p.type), p.name)).collect(Collectors.toList());
            this.declaration.setParameters(NodeList.nodeList(javaParserParameters));
        }

        @Override
        public String getName() {
            return "<init>";
        }

        @Override
        public void setName(String name) {
            if (!name.equals("<init>")) {
                throw new UnsupportedOperationException("Can't setName of constructor");
            }
        }

        @Override
        public AccessFlags getAccessFlags() {
            return new AccessFlags(this.declaration.getModifiers());
        }

        @Override
        public void setAccessFlags(AccessFlags accessFlags) {
            this.declaration.setModifiers(accessFlags.toJavaParserModifierSet());
        }

        @Override
        public List<Annotation> getAnnotations() {
            return SourceInfo.this.getAnnotationsInternal((List)this.declaration.getAnnotations());
        }

        @Override
        public SourceInfo getClassInfo() {
            return SourceInfo.this;
        }

        public String toString() {
            return SimpleMethodInfo.toString(this);
        }

        @Override
        public List<TypeVariable> getTypeVariables() {
            return Collections.emptyList();
        }

        @Override
        public void setTypeVariables(List<TypeVariable> typeVariables) {
            if (!typeVariables.isEmpty()) {
                throw new UnsupportedOperationException("Can't set type variables on a constructor");
            }
        }

        @Override
        public ConstructorDeclarationWrapper clone() {
            return new ConstructorDeclarationWrapper(this.declaration.clone());
        }
    }

    public class MethodDeclarationWrapper
    implements MethodInfo {
        private final MethodDeclaration declaration;
        private ResolutionContext context;

        public MethodDeclarationWrapper(MethodDeclaration declaration) {
            this.declaration = declaration;
        }

        private ResolutionContext getContext() {
            if (this.context != null) {
                return this.context;
            }
            this.context = ResolutionContext.of((Node)this.declaration, (Node)SourceInfo.this.type.get(), SourceInfo.this.classPath);
            return this.context;
        }

        @Override
        public Type getReturnType() {
            return this.getContext().resolve(this.declaration.getType());
        }

        @Override
        public void setReturnType(Type type) {
            this.declaration.setType(SourceInfo.this.setType(type, this.declaration.getType()));
        }

        @Override
        public List<org.minimallycorrect.javatransformer.api.Parameter> getParameters() {
            return SourceInfo.getParameters((NodeWithParameters)this.declaration, this::getContext);
        }

        @Override
        public void setParameters(List<org.minimallycorrect.javatransformer.api.Parameter> parameters) {
            List javaParserParameters = parameters.stream().map(p -> new Parameter(ResolutionContext.typeToJavaParserType(p.type), p.name)).collect(Collectors.toList());
            this.declaration.setParameters(NodeList.nodeList(javaParserParameters));
        }

        @Override
        public String getName() {
            return this.declaration.getName().asString();
        }

        @Override
        public void setName(String name) {
            this.declaration.setName(name);
        }

        @Override
        public AccessFlags getAccessFlags() {
            return new AccessFlags(this.declaration.getModifiers());
        }

        @Override
        public void setAccessFlags(AccessFlags accessFlags) {
            this.declaration.setModifiers(accessFlags.toJavaParserModifierSet());
        }

        @Override
        public List<Annotation> getAnnotations() {
            return SourceInfo.this.getAnnotationsInternal((List)this.declaration.getAnnotations());
        }

        @Override
        public SourceInfo getClassInfo() {
            return SourceInfo.this;
        }

        public String toString() {
            return SimpleMethodInfo.toString(this);
        }

        @Override
        public List<TypeVariable> getTypeVariables() {
            return this.declaration.getTypeParameters().stream().map(this.getContext()::resolveTypeVariable).collect(Collectors.toList());
        }

        @Override
        public void setTypeVariables(List<TypeVariable> typeVariables) {
            this.declaration.setTypeParameters(NodeList.nodeList((Collection)typeVariables.stream().map(this.getContext()::unresolveTypeVariable).collect(Collectors.toList())));
            this.context = null;
        }

        @Override
        public MethodDeclarationWrapper clone() {
            return new MethodDeclarationWrapper(this.declaration.clone());
        }
    }

    public class FieldDeclarationWrapper
    implements FieldInfo {
        private final FieldDeclaration declaration;
        private ResolutionContext context;

        FieldDeclarationWrapper(FieldDeclaration declaration) {
            this.declaration = declaration;
            if (declaration.getVariables().size() != 1) {
                throw new UnsupportedOperationException("Not yet implemented: multiple variables in one field decl.");
            }
        }

        private ResolutionContext getContext() {
            if (this.context != null) {
                return this.context;
            }
            this.context = ResolutionContext.of((Node)this.declaration, (Node)SourceInfo.this.type.get(), SourceInfo.this.classPath);
            return this.context;
        }

        @Override
        public String getName() {
            return ((VariableDeclarator)this.declaration.getVariables().get(0)).getName().asString();
        }

        @Override
        public void setName(String name) {
            ((VariableDeclarator)this.declaration.getVariables().get(0)).setName(name);
        }

        @Override
        public AccessFlags getAccessFlags() {
            return new AccessFlags(this.declaration.getModifiers());
        }

        @Override
        public void setAccessFlags(AccessFlags accessFlags) {
            this.declaration.setModifiers(accessFlags.toJavaParserModifierSet());
        }

        @Override
        public Type getType() {
            return this.getContext().resolve(this.declaration.getCommonType());
        }

        @Override
        public void setType(Type type) {
            this.declaration.getVariable(0).setType(SourceInfo.this.setType(type, this.declaration.getCommonType()));
        }

        @Override
        public List<Annotation> getAnnotations() {
            return SourceInfo.this.getAnnotationsInternal((List)this.declaration.getAnnotations());
        }

        @Override
        public SourceInfo getClassInfo() {
            return SourceInfo.this;
        }

        public String toString() {
            return SimpleFieldInfo.toString(this);
        }

        @Override
        public FieldDeclarationWrapper clone() {
            return new FieldDeclarationWrapper(this.declaration.clone());
        }
    }
}

