/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.internal.asm;

import org.jetbrains.annotations.Nullable;
import org.minimallycorrect.javatransformer.api.Type;
import org.minimallycorrect.javatransformer.api.code.IntermediateValue;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;

public final class AsmInstructions
implements Opcodes {
    @Nullable
    public static Object getConstant(AbstractInsnNode insn) {
        switch (insn.getOpcode()) {
            case 1: {
                return null;
            }
            case 14: {
                return 0.0;
            }
            case 15: {
                return 1.0;
            }
            case 11: {
                return Float.valueOf(0.0f);
            }
            case 12: {
                return Float.valueOf(1.0f);
            }
            case 13: {
                return Float.valueOf(2.0f);
            }
            case 9: {
                return 0L;
            }
            case 10: {
                return 1L;
            }
            case 2: {
                return -1;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 16: 
            case 17: 
            case 188: {
                return ((IntInsnNode)insn).operand;
            }
            case 18: {
                return ((LdcInsnNode)insn).cst;
            }
        }
        return IntermediateValue.UNKNOWN;
    }

    public static int getStoreInstructionForType(IntermediateValue iv) {
        Type type = iv.type;
        if (type == null) {
            throw new NullPointerException();
        }
        switch (type.getDescriptorType()) {
            case BYTE: 
            case CHAR: 
            case INT: 
            case SHORT: 
            case BOOLEAN: {
                return 54;
            }
            case DOUBLE: {
                return 57;
            }
            case FLOAT: {
                return 56;
            }
            case LONG: {
                return 55;
            }
            case VOID: {
                throw new IllegalArgumentException(iv.toString());
            }
            case ARRAY: 
            case CLASS: {
                return 58;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static int getLoadInstructionForType(IntermediateValue iv) {
        Type type = iv.type;
        if (type == null) {
            throw new NullPointerException();
        }
        switch (type.getDescriptorType()) {
            case BYTE: 
            case CHAR: 
            case INT: 
            case SHORT: 
            case BOOLEAN: {
                return 21;
            }
            case DOUBLE: {
                return 24;
            }
            case FLOAT: {
                return 23;
            }
            case LONG: {
                return 22;
            }
            case VOID: {
                throw new IllegalArgumentException(iv.toString());
            }
            case ARRAY: 
            case CLASS: {
                return 25;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static int getReturnInstructionForType(@Nullable Type type) {
        if (type == null) {
            return 177;
        }
        switch (type.getDescriptorType()) {
            case BYTE: 
            case CHAR: 
            case INT: 
            case SHORT: 
            case BOOLEAN: {
                return 172;
            }
            case DOUBLE: {
                return 175;
            }
            case FLOAT: {
                return 174;
            }
            case LONG: {
                return 173;
            }
            case VOID: {
                return 177;
            }
            case ARRAY: 
            case CLASS: {
                return 176;
            }
        }
        throw new UnsupportedOperationException();
    }

    private AsmInstructions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

