/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.internal.util;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.minimallycorrect.javatransformer.api.Annotation;
import org.minimallycorrect.javatransformer.api.TransformationException;
import org.minimallycorrect.javatransformer.api.Type;
import org.minimallycorrect.javatransformer.internal.ResolutionContext;
import org.minimallycorrect.javatransformer.internal.util.NodeUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;

public final class AnnotationParser {
    public static List<Annotation> parseAnnotations(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        AnnotationVisitor cv = new AnnotationVisitor();
        cr.accept((ClassVisitor)cv, 7);
        return cv.annotations.stream().map(AnnotationParser::annotationFromAnnotationNode).collect(Collectors.toList());
    }

    public static Annotation annotationFromAnnotationNode(AnnotationNode annotationNode) {
        return Annotation.of(new Type(annotationNode.desc), AnnotationParser.getAnnotationNodeValues(annotationNode));
    }

    private static Map<String, Object> getAnnotationNodeValues(AnnotationNode annotationNode) {
        if (annotationNode.values == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (int i = 0; i < annotationNode.values.size(); i += 2) {
            values.put((String)annotationNode.values.get(i), annotationNode.values.get(i + 1));
        }
        return values;
    }

    public static Annotation annotationFromAnnotationExpr(AnnotationExpr annotationExpr, ResolutionContext context) {
        Type t = ResolutionContext.of((Node)annotationExpr, context.getClassPath()).resolve(NodeUtil.qualifiedName(annotationExpr.getName()));
        if (annotationExpr instanceof SingleMemberAnnotationExpr) {
            return Annotation.of(t, AnnotationParser.expressionToValue(((SingleMemberAnnotationExpr)annotationExpr).getMemberValue(), context));
        }
        if (annotationExpr instanceof NormalAnnotationExpr) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (MemberValuePair memberValuePair : ((NormalAnnotationExpr)annotationExpr).getPairs()) {
                map.put(memberValuePair.getName().asString(), AnnotationParser.expressionToValue(memberValuePair.getValue(), context));
            }
            return Annotation.of(t, map);
        }
        if (annotationExpr instanceof MarkerAnnotationExpr) {
            return Annotation.of(t);
        }
        throw new TransformationException("Unknown annotation type: " + annotationExpr.getClass().getCanonicalName());
    }

    private static Object expressionToValue(Expression e, ResolutionContext context) {
        FieldAccessExpr fieldAccessExpre;
        Type t;
        if (e instanceof StringLiteralExpr) {
            return ((StringLiteralExpr)e).getValue();
        }
        if (e instanceof BooleanLiteralExpr) {
            return ((BooleanLiteralExpr)e).getValue();
        }
        if (e instanceof ClassExpr) {
            return ((ClassExpr)e).getType().asString();
        }
        if (e instanceof ArrayInitializerExpr) {
            return AnnotationParser.arrayExpressionToArray((ArrayInitializerExpr)e, context);
        }
        if (e instanceof FieldAccessExpr && (t = context.resolve((fieldAccessExpre = (FieldAccessExpr)e).getScope().toString())) != null) {
            return new String[]{t.getDescriptor(), ((FieldAccessExpr)e).getNameAsString()};
        }
        throw new TransformationException("Unknown value: " + e + "\nClass: " + e.getClass());
    }

    private static Object[] arrayExpressionToArray(ArrayInitializerExpr expr, ResolutionContext context) {
        NodeList values = expr.getValues();
        if (values.isEmpty()) {
            return new Object[0];
        }
        List<Object> results = values.stream().map(it -> AnnotationParser.expressionToValue(it, context)).collect(Collectors.toList());
        return results.toArray((Object[])Array.newInstance(results.get(0).getClass(), 0));
    }

    private AnnotationParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class AnnotationVisitor
    extends ClassVisitor {
        public final List<AnnotationNode> annotations = new ArrayList<AnnotationNode>();

        public AnnotationVisitor() {
            super(327680);
        }

        public org.objectweb.asm.AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationNode an = new AnnotationNode(desc);
            this.annotations.add(an);
            return an;
        }
    }
}

