/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.api.CoreProvider;
import com.mumfrey.liteloader.api.CustomisationProvider;
import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.api.LiteAPI;
import com.mumfrey.liteloader.api.ModLoadObserver;
import com.mumfrey.liteloader.api.PostRenderObserver;
import com.mumfrey.liteloader.api.ShutdownObserver;
import com.mumfrey.liteloader.api.TickObserver;
import com.mumfrey.liteloader.api.TranslationProvider;
import com.mumfrey.liteloader.api.WorldObserver;
import com.mumfrey.liteloader.api.manager.APIAdapter;
import com.mumfrey.liteloader.api.manager.APIProvider;
import com.mumfrey.liteloader.common.GameEngine;
import com.mumfrey.liteloader.common.LoadingProgress;
import com.mumfrey.liteloader.core.ClientPluginChannels;
import com.mumfrey.liteloader.core.LiteLoaderBootstrap;
import com.mumfrey.liteloader.core.LiteLoaderEventBroker;
import com.mumfrey.liteloader.core.LiteLoaderInterfaceManager;
import com.mumfrey.liteloader.core.LiteLoaderMods;
import com.mumfrey.liteloader.core.LiteLoaderVersion;
import com.mumfrey.liteloader.core.ModInfo;
import com.mumfrey.liteloader.core.ServerPluginChannels;
import com.mumfrey.liteloader.core.api.LiteLoaderCoreAPI;
import com.mumfrey.liteloader.core.event.EventProxy;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.crashreport.CallableLaunchWrapper;
import com.mumfrey.liteloader.crashreport.CallableLiteLoaderBrand;
import com.mumfrey.liteloader.crashreport.CallableLiteLoaderMods;
import com.mumfrey.liteloader.interfaces.FastIterableDeque;
import com.mumfrey.liteloader.interfaces.Loadable;
import com.mumfrey.liteloader.interfaces.LoadableMod;
import com.mumfrey.liteloader.interfaces.LoaderEnumerator;
import com.mumfrey.liteloader.interfaces.ObjectFactory;
import com.mumfrey.liteloader.interfaces.PanelManager;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.messaging.MessageBus;
import com.mumfrey.liteloader.modconfig.ConfigManager;
import com.mumfrey.liteloader.modconfig.Exposable;
import com.mumfrey.liteloader.permissions.PermissionsManagerClient;
import com.mumfrey.liteloader.permissions.PermissionsManagerServer;
import com.mumfrey.liteloader.transformers.event.EventTransformer;
import com.mumfrey.liteloader.util.Input;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.activity.InvalidActivityException;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.spongepowered.asm.mixin.MixinEnvironment;

public final class LiteLoader {
    private static LiteLoader instance;
    private static LaunchClassLoader classLoader;
    private GameEngine<?, ?> engine;
    private nt profiler;
    private final LoaderEnvironment environment;
    private final LoaderProperties properties;
    private final LoaderEnumerator enumerator;
    protected final LiteLoaderMods mods;
    private final APIProvider apiProvider;
    private final APIAdapter apiAdapter;
    private final LiteLoaderCoreAPI api;
    private final ObjectFactory<?, ?> objectFactory;
    private final FastIterableDeque<CoreProvider> coreProviders = new HandlerList<CoreProvider>(CoreProvider.class);
    private final FastIterableDeque<TickObserver> tickObservers = new HandlerList<TickObserver>(TickObserver.class);
    private final FastIterableDeque<WorldObserver> worldObservers = new HandlerList<WorldObserver>(WorldObserver.class);
    private final FastIterableDeque<ShutdownObserver> shutdownObservers = new HandlerList<ShutdownObserver>(ShutdownObserver.class);
    private final FastIterableDeque<PostRenderObserver> postRenderObservers = new HandlerList<PostRenderObserver>(PostRenderObserver.class);
    private PanelManager panelManager;
    private LiteLoaderInterfaceManager interfaceManager;
    private LiteLoaderEventBroker<?, ?> events;
    private final ClientPluginChannels clientPluginChannels;
    private final ServerPluginChannels serverPluginChannels;
    private final PermissionsManagerClient permissionsManagerClient;
    private final PermissionsManagerServer permissionsManagerServer;
    private final ConfigManager configManager;
    private boolean modInitComplete;
    private Input input;
    private final List<TranslationProvider> translators = new ArrayList<TranslationProvider>();

    private LiteLoader(LoaderEnvironment environment, LoaderProperties properties) {
        this.environment = environment;
        this.properties = properties;
        this.enumerator = environment.getEnumerator();
        this.configManager = new ConfigManager();
        this.mods = new LiteLoaderMods(this, environment, properties, this.configManager);
        this.apiProvider = environment.getAPIProvider();
        this.apiAdapter = environment.getAPIAdapter();
        this.api = this.apiProvider.getAPI(LiteLoaderCoreAPI.class);
        if (this.api == null) {
            throw new IllegalStateException("The core API was not registered. Startup halted");
        }
        this.objectFactory = this.api.getObjectFactory();
        this.input = this.objectFactory.getInput();
        this.clientPluginChannels = this.objectFactory.getClientPluginChannels();
        this.serverPluginChannels = this.objectFactory.getServerPluginChannels();
        this.permissionsManagerClient = this.objectFactory.getClientPermissionManager();
        this.permissionsManagerServer = this.objectFactory.getServerPermissionManager();
        this.initTranslators();
    }

    protected void initTranslators() {
        for (LiteAPI api : this.apiProvider.getAPIs()) {
            List<CustomisationProvider> customisationProviders = api.getCustomisationProviders();
            if (customisationProviders == null) continue;
            for (CustomisationProvider provider : customisationProviders) {
                if (!(provider instanceof TranslationProvider)) continue;
                this.translators.add((TranslationProvider)provider);
            }
        }
    }

    private void onInit() {
        try {
            this.coreProviders.addAll(this.apiAdapter.getCoreProviders());
            this.tickObservers.addAll(this.apiAdapter.getAllObservers(TickObserver.class));
            this.worldObservers.addAll(this.apiAdapter.getAllObservers(WorldObserver.class));
            this.shutdownObservers.addAll(this.apiAdapter.getAllObservers(ShutdownObserver.class));
            this.postRenderObservers.addAll(this.apiAdapter.getAllObservers(PostRenderObserver.class));
            ((CoreProvider)this.coreProviders.all()).onInit();
            this.enumerator.onInit();
            this.mods.init(this.apiAdapter.getAllObservers(ModLoadObserver.class));
        }
        catch (Throwable th) {
            LiteLoaderLogger.severe(th, "Error initialising LiteLoader", th);
        }
    }

    private void onPostInit() {
        LoadingProgress.setMessage("LiteLoader POSTINIT...");
        this.initLifetimeObjects();
        this.postInitCoreProviders();
        this.loadAndInitMods();
        ((CoreProvider)this.coreProviders.all()).onPostInitComplete(this.mods);
        this.properties.writeProperties();
    }

    public static final LiteLoader getInstance() {
        return instance;
    }

    public static LaunchClassLoader getClassLoader() {
        return classLoader;
    }

    public static final String getVersion() {
        return LiteLoaderVersion.CURRENT.getLoaderVersion();
    }

    public static final String getVersionDisplayString() {
        return String.format("LiteLoader %s", LiteLoaderVersion.CURRENT.getLoaderVersion());
    }

    public static final int getRevision() {
        return LiteLoaderVersion.CURRENT.getLoaderRevision();
    }

    public static final LiteAPI[] getAPIs() {
        LiteAPI[] apis = LiteLoader.instance.apiProvider.getAPIs();
        LiteAPI[] apisCopy = new LiteAPI[apis.length];
        System.arraycopy(apis, 0, apisCopy, 0, apis.length);
        return apisCopy;
    }

    public static final LiteAPI getAPI(String identifier) {
        return LiteLoader.instance.apiProvider.getAPI(identifier);
    }

    public static boolean isAPIAvailable(String identifier) {
        return LiteLoader.getAPI(identifier) != null;
    }

    public static final <C extends CustomisationProvider> C getCustomisationProvider(LiteAPI api, Class<C> providerType) {
        List<CustomisationProvider> customisationProviders = api.getCustomisationProviders();
        if (customisationProviders != null) {
            for (CustomisationProvider provider : customisationProviders) {
                if (!providerType.isAssignableFrom(provider.getClass())) continue;
                return (C)provider;
            }
        }
        return null;
    }

    public static PermissionsManagerClient getClientPermissionsManager() {
        return LiteLoader.instance.permissionsManagerClient;
    }

    public static PermissionsManagerServer getServerPermissionsManager() {
        return LiteLoader.instance.permissionsManagerServer;
    }

    public static GameEngine<?, ?> getGameEngine() {
        return LiteLoader.instance.engine;
    }

    public static LiteLoaderInterfaceManager getInterfaceManager() {
        return LiteLoader.instance.interfaceManager;
    }

    public static ClientPluginChannels getClientPluginChannels() {
        return LiteLoader.instance.clientPluginChannels;
    }

    public static ServerPluginChannels getServerPluginChannels() {
        return LiteLoader.instance.serverPluginChannels;
    }

    public static Input getInput() {
        return LiteLoader.instance.input;
    }

    public static <T> PanelManager<T> getModPanelManager() {
        return LiteLoader.instance.panelManager;
    }

    public static File getModsFolder() {
        return LiteLoader.instance.environment.getModsFolder();
    }

    public static File getCommonConfigFolder() {
        return LiteLoader.instance.environment.getCommonConfigFolder();
    }

    public static File getConfigFolder() {
        return LiteLoader.instance.environment.getVersionedConfigFolder();
    }

    public static File getGameDirectory() {
        return LiteLoader.instance.environment.getGameDirectory();
    }

    public static File getAssetsDirectory() {
        return LiteLoader.instance.environment.getAssetsDirectory();
    }

    public static String getProfile() {
        return LiteLoader.instance.environment.getProfile();
    }

    public static LoaderEnvironment.EnvironmentType getEnvironmentType() {
        return LiteLoader.instance.environment.getType();
    }

    public static String getBranding() {
        return LiteLoader.instance.properties.getBranding();
    }

    public static boolean isDevelopmentEnvironment() {
        return "true".equals(System.getProperty("mcpenv"));
    }

    public static void dumpDebugInfo() {
        if (LiteLoaderLogger.DEBUG) {
            EventTransformer.dumpInjectionState();
            MixinEnvironment.getCurrentEnvironment().audit();
            LiteLoaderLogger.info("Debug info dumped to console", new Object[0]);
        } else {
            LiteLoaderLogger.info("Debug dump not available, developer flag not enabled", new Object[0]);
        }
    }

    public String getLoadedModsList() {
        return this.mods.getLoadedModsList();
    }

    public List<LiteMod> getLoadedMods() {
        ArrayList<LiteMod> loadedMods = new ArrayList<LiteMod>();
        for (ModInfo<LoadableMod<?>> loadedMod : this.mods.getLoadedMods()) {
            loadedMods.add(loadedMod.getMod());
        }
        return loadedMods;
    }

    public List<Loadable<?>> getDisabledMods() {
        ArrayList disabledMods = new ArrayList();
        for (ModInfo<?> disabledMod : this.mods.getDisabledMods()) {
            disabledMods.add((Loadable<?>)disabledMod.getContainer());
        }
        return disabledMods;
    }

    public Collection<Loadable<File>> getInjectedTweaks() {
        ArrayList<Loadable<File>> tweaks = new ArrayList<Loadable<File>>();
        for (ModInfo<Loadable<?>> tweak : this.mods.getInjectedTweaks()) {
            tweaks.add(tweak.getContainer());
        }
        return tweaks;
    }

    public <T extends LiteMod> T getMod(String modName) throws InvalidActivityException, IllegalArgumentException {
        if (!this.modInitComplete) {
            throw new InvalidActivityException("Attempted to get a reference to a mod before loader startup is complete");
        }
        return this.mods.getMod(modName);
    }

    public <T extends LiteMod> T getMod(Class<T> modClass) {
        if (!this.modInitComplete) {
            throw new RuntimeException("Attempted to get a reference to a mod before loader startup is complete");
        }
        return this.mods.getMod(modClass);
    }

    public boolean isModInstalled(String modName) {
        if (!this.modInitComplete || modName == null) {
            return false;
        }
        return this.mods.isModInstalled(modName);
    }

    public String getModMetaData(String modNameOrId, String metaDataKey, String defaultValue) throws IllegalArgumentException {
        return this.mods.getModMetaData(modNameOrId, metaDataKey, defaultValue);
    }

    public String getModMetaData(LiteMod mod, String metaDataKey, String defaultValue) {
        return this.mods.getModMetaData(mod, metaDataKey, defaultValue);
    }

    public String getModMetaData(Class<? extends LiteMod> modClass, String metaDataKey, String defaultValue) {
        return this.mods.getModMetaData(modClass, metaDataKey, defaultValue);
    }

    public String getModIdentifier(Class<? extends LiteMod> modClass) {
        return this.mods.getModIdentifier(modClass);
    }

    public String getModIdentifier(LiteMod mod) {
        return this.mods.getModIdentifier(mod);
    }

    public LoadableMod<?> getModContainer(Class<? extends LiteMod> modClass) {
        return this.mods.getModContainer(modClass);
    }

    public LoadableMod<?> getModContainer(LiteMod mod) {
        return this.mods.getModContainer(mod);
    }

    public Class<? extends LiteMod> getModFromIdentifier(String identifier) {
        return this.mods.getModFromIdentifier(identifier);
    }

    public void enableMod(String identifier) {
        this.mods.setModEnabled(identifier, true);
    }

    public void disableMod(String identifier) {
        this.mods.setModEnabled(identifier, false);
    }

    public void setModEnabled(String identifier, boolean enabled) {
        this.mods.setModEnabled(identifier, enabled);
    }

    public boolean isModEnabled(String modName) {
        return this.mods.isModEnabled(modName);
    }

    public boolean isModActive(String modName) {
        return this.mods.isModActive(modName);
    }

    public void writeConfig(Exposable exposable) {
        this.configManager.invalidateConfig(exposable);
    }

    public void registerExposable(Exposable exposable, String fileName) {
        this.configManager.registerExposable(exposable, fileName, true);
        this.configManager.initConfig(exposable);
    }

    private void initLifetimeObjects() {
        this.engine = this.objectFactory.getGameEngine();
        this.profiler = this.objectFactory.getGameEngine().getProfiler();
        this.events = this.objectFactory.getEventBroker();
        if (this.events != null) {
            this.events.setMods(this.mods);
        }
        this.panelManager = this.objectFactory.getPanelManager();
        if (this.panelManager != null) {
            this.panelManager.init(this.mods, this.configManager);
        }
        this.interfaceManager = new LiteLoaderInterfaceManager(this.apiAdapter);
    }

    private void postInitCoreProviders() {
        ((CoreProvider)this.coreProviders.all()).onPostInit(this.engine);
        this.interfaceManager.registerInterfaces();
        for (CoreProvider provider : this.coreProviders) {
            if (!(provider instanceof Listener)) continue;
            this.interfaceManager.registerListener((Listener)((Object)provider));
        }
    }

    private void loadAndInitMods() {
        int totalMods = this.enumerator.modsToLoadCount();
        int totalTweaks = this.enumerator.getInjectedTweaks().size();
        LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Discovered %d total mod(s), injected %d tweak(s)", totalMods, totalTweaks);
        if (totalMods > 0) {
            this.mods.loadMods();
            this.mods.initMods();
        } else {
            LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "No mod classes were found. Not loading any mods.", new Object[0]);
        }
        this.interfaceManager.onPostInit();
        this.modInitComplete = true;
        this.mods.onPostInit();
    }

    void onPostInitMod(LiteMod mod) {
        if (this.permissionsManagerClient != null) {
            this.permissionsManagerClient.registerMod(mod);
        }
    }

    void onStartupComplete() {
        LiteLoaderBootstrap.setBranding("LiteLoader");
        ((CoreProvider)this.coreProviders.all()).onStartupComplete();
        if (this.panelManager != null) {
            this.panelManager.onStartupComplete();
        }
        MessageBus.getInstance().onStartupComplete();
        el.values();
    }

    void onJoinGame(ep netHandler, gt loginPacket) {
        if (this.permissionsManagerClient != null) {
            this.permissionsManagerClient.onJoinGame(netHandler, loginPacket);
        }
        ((CoreProvider)this.coreProviders.all()).onJoinGame(netHandler, loginPacket);
    }

    void onWorldChanged(adm world) {
        if (world != null && this.permissionsManagerClient != null) {
            this.permissionsManagerClient.scheduleRefresh();
        }
        ((WorldObserver)this.worldObservers.all()).onWorldChanged(world);
    }

    void onPostRender(int mouseX, int mouseY, float partialTicks) {
        this.profiler.a("core");
        ((PostRenderObserver)this.postRenderObservers.all()).onPostRender(mouseX, mouseY, partialTicks);
        this.profiler.b();
    }

    void onTick(boolean clock, float partialTicks, boolean inGame) {
        if (clock) {
            if (this.permissionsManagerClient != null) {
                this.profiler.a("permissionsmanager");
                this.permissionsManagerClient.onTick(this.engine, partialTicks, inGame);
                this.profiler.b();
            }
            this.profiler.a("configmanager");
            this.configManager.onTick();
            this.profiler.b();
            if (!this.engine.isRunning()) {
                this.onShutDown();
                return;
            }
        }
        this.profiler.a("observers");
        ((TickObserver)this.tickObservers.all()).onTick(clock, partialTicks, inGame);
        this.profiler.b();
    }

    private void onShutDown() {
        LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "LiteLoader is shutting down, shutting down core providers and syncing configuration", new Object[0]);
        ((ShutdownObserver)this.shutdownObservers.all()).onShutDown();
        this.configManager.syncConfig();
    }

    public static String translate(String key, Object ... args) {
        for (TranslationProvider translator : LiteLoader.instance.translators) {
            String translated = translator.translate(key, args);
            if (translated == null) continue;
            return translated;
        }
        return key;
    }

    public static void populateCrashReport(Object objCrashReport) {
        if (objCrashReport instanceof b) {
            EventProxy.populateCrashReport((b)objCrashReport);
            LiteLoader.populateCrashReport((b)objCrashReport);
        }
    }

    private static void populateCrashReport(b crashReport) {
        c category = crashReport.g();
        category.a("Mod Pack", (Callable)new CallableLiteLoaderBrand(crashReport));
        category.a("LiteLoader Mods", (Callable)new CallableLiteLoaderMods(crashReport));
        category.a("LaunchWrapper", (Callable)new CallableLaunchWrapper(crashReport));
    }

    static final void createInstance(LoaderEnvironment environment, LoaderProperties properties, LaunchClassLoader classLoader) {
        if (instance == null) {
            LiteLoader.classLoader = classLoader;
            instance = new LiteLoader(environment, properties);
        }
    }

    static final void invokeInit() {
        LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "LiteLoader begin INIT...", new Object[0]);
        instance.onInit();
    }

    static final void invokePostInit() {
        LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "LiteLoader begin POSTINIT...", new Object[0]);
        instance.onPostInit();
    }
}

