/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.google.common.base.Throwables;
import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.api.ContainerRegistry;
import com.mumfrey.liteloader.api.EnumerationObserver;
import com.mumfrey.liteloader.api.EnumeratorModule;
import com.mumfrey.liteloader.api.EnumeratorPlugin;
import com.mumfrey.liteloader.api.LiteAPI;
import com.mumfrey.liteloader.api.ModClassValidator;
import com.mumfrey.liteloader.core.Containers;
import com.mumfrey.liteloader.core.Mod;
import com.mumfrey.liteloader.core.ModInfo;
import com.mumfrey.liteloader.core.api.DefaultClassValidator;
import com.mumfrey.liteloader.core.api.DefaultEnumeratorPlugin;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.interfaces.FastIterableDeque;
import com.mumfrey.liteloader.interfaces.Injectable;
import com.mumfrey.liteloader.interfaces.Loadable;
import com.mumfrey.liteloader.interfaces.LoadableMod;
import com.mumfrey.liteloader.interfaces.LoaderEnumerator;
import com.mumfrey.liteloader.interfaces.MixinContainer;
import com.mumfrey.liteloader.interfaces.TweakContainer;
import com.mumfrey.liteloader.launch.ClassTransformerManager;
import com.mumfrey.liteloader.launch.LiteLoaderTweaker;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class LiteLoaderEnumerator
implements LoaderEnumerator {
    private final LoaderEnvironment environment;
    private final LoaderProperties properties;
    private final LaunchClassLoader classLoader;
    private final List<EnumeratorModule> modules = new ArrayList<EnumeratorModule>();
    private final List<EnumeratorPlugin> plugins = new ArrayList<EnumeratorPlugin>();
    private final ContainerRegistry containers = new Containers();
    private final Set<LoadableMod<?>> enumeratedContainers = new HashSet();
    private final Set<ModInfo<LoadableMod<?>>> modsToLoad = new LinkedHashSet();
    private final ModClassValidator validator;
    private final FastIterableDeque<EnumerationObserver> observers = new HandlerList<EnumerationObserver>(EnumerationObserver.class);
    protected EnumeratorState state = EnumeratorState.INIT;

    public LiteLoaderEnumerator(LoaderEnvironment environment, LoaderProperties properties, LaunchClassLoader classLoader) {
        this.environment = environment;
        this.properties = properties;
        this.classLoader = classLoader;
        this.validator = this.getValidator(environment);
        this.initModules(environment);
        this.registerPlugin(new DefaultEnumeratorPlugin());
        this.observers.addAll(environment.getAPIAdapter().getPreInitObservers(EnumerationObserver.class));
        this.getSharedModList();
    }

    private ModClassValidator getValidator(LoaderEnvironment environment) {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (LiteAPI api : environment.getAPIProvider().getAPIs()) {
            String prefix = api.getModClassPrefix();
            if (prefix == null) continue;
            LiteLoaderLogger.info("Adding supported mod class prefix '%s'", prefix);
            prefixes.add(prefix);
        }
        return new DefaultClassValidator<LiteMod>(LiteMod.class, prefixes);
    }

    private void initModules(LoaderEnvironment environment) {
        for (LiteAPI api : environment.getAPIProvider().getAPIs()) {
            List<EnumeratorModule> apiModules = api.getEnumeratorModules();
            if (apiModules == null) continue;
            for (EnumeratorModule module : apiModules) {
                this.registerModule(module);
            }
        }
    }

    private void checkState(EnumeratorState state, String action) {
        if (this.state != state) {
            throw new IllegalStateException("Illegal enumerator state whilst performing " + action + ", expecting " + (Object)((Object)state) + " but current state is " + (Object)((Object)this.state));
        }
    }

    private void gotoState(EnumeratorState state) {
        if (state.checkGotoState(this.state)) {
            this.state = state;
        }
    }

    public LoaderEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public Map<String, Map<String, String>> getSharedModList() {
        try {
            HashMap sharedModList = (HashMap)Launch.blackboard.get("modList");
            if (sharedModList == null) {
                sharedModList = new HashMap();
                Launch.blackboard.put("modList", sharedModList);
            }
            return sharedModList;
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning("Shared mod list was invalid or not accessible, this isn't especially bad but something isn't quite right", new Object[0]);
            return null;
        }
    }

    @Override
    public void registerModule(EnumeratorModule module) {
        this.checkState(EnumeratorState.INIT, "registerModule");
        if (module != null && !this.modules.contains(module)) {
            LiteLoaderLogger.info("Registering discovery module %s: [%s]", module.getClass().getSimpleName(), module);
            this.modules.add(module);
            module.init(this.environment, this.properties);
        }
    }

    @Override
    public void registerPlugin(EnumeratorPlugin plugin) {
        this.checkState(EnumeratorState.INIT, "registerPlugin");
        if (plugin != null && !this.plugins.contains(plugin)) {
            LiteLoaderLogger.info("Registering enumerator plugin %s: [%s]", plugin.getClass().getSimpleName(), plugin);
            this.plugins.add(plugin);
            plugin.init(this.environment, this.properties);
        }
    }

    @Override
    public Collection<? extends ModInfo<LoadableMod<?>>> getModsToLoad() {
        this.checkState(EnumeratorState.FINALISED, "getModsToLoad");
        return Collections.unmodifiableSet(this.modsToLoad);
    }

    @Override
    public Collection<? extends ModInfo<Loadable<?>>> getDisabledContainers() {
        this.checkState(EnumeratorState.FINALISED, "getDisabledContainers");
        return this.containers.getDisabledContainers();
    }

    @Override
    public Collection<? extends ModInfo<Loadable<?>>> getBadContainers() {
        this.checkState(EnumeratorState.FINALISED, "getBadContainers");
        return this.containers.getBadContainers();
    }

    @Override
    public Collection<? extends ModInfo<Loadable<?>>> getInjectedTweaks() {
        this.checkState(EnumeratorState.FINALISED, "getInjectedTweaks");
        return this.containers.getInjectedTweaks();
    }

    @Override
    public int modsToLoadCount() {
        return this.modsToLoad.size();
    }

    @Override
    public String getModMetaData(Class<? extends LiteMod> modClass, String metaDataKey, String defaultValue) {
        this.checkState(EnumeratorState.FINALISED, "getModMetaData");
        return this.getContainerForMod(modClass).getMetaValue(metaDataKey, defaultValue);
    }

    @Override
    public LoadableMod<?> getContainer(String identifier) {
        this.checkState(EnumeratorState.FINALISED, "getContainer");
        return this.containers.getEnabledContainer(identifier);
    }

    @Override
    public LoadableMod<?> getContainer(Class<? extends LiteMod> modClass) {
        this.checkState(EnumeratorState.FINALISED, "getContainer");
        return this.getContainerForMod(modClass);
    }

    private LoadableMod<?> getContainerForMod(Class<? extends LiteMod> modClass) {
        for (ModInfo<LoadableMod<?>> mod : this.modsToLoad) {
            if (!modClass.equals(mod.getModClass())) continue;
            return mod.getContainer();
        }
        return LoadableMod.NONE;
    }

    @Override
    public String getIdentifier(Class<? extends LiteMod> modClass) {
        String modClassName = modClass.getSimpleName();
        for (ModInfo<LoadableMod<?>> mod : this.modsToLoad) {
            if (!modClassName.equals(mod.getModClassSimpleName())) continue;
            return mod.getIdentifier();
        }
        return LiteLoaderEnumerator.getModClassName(modClass);
    }

    @Override
    public void onPreInit() {
        this.discoverContainers();
        this.injectDiscoveredTweaks();
    }

    private void discoverContainers() {
        this.gotoState(EnumeratorState.DISCOVER);
        for (EnumeratorModule module : this.modules) {
            try {
                module.enumerate(this, this.environment.getProfile());
            }
            catch (Throwable th) {
                LiteLoaderLogger.warning(th, "Enumerator Module %s encountered an error whilst enumerating", module.getClass().getName());
            }
        }
        this.checkDependencies();
    }

    private void injectDiscoveredTweaks() {
        this.gotoState(EnumeratorState.INJECT);
        for (TweakContainer<File> tweakContainer : this.containers.getTweakContainers()) {
            this.addTweaksFrom(tweakContainer);
        }
    }

    @Override
    public void onInit() {
        try {
            this.gotoState(EnumeratorState.INJECT);
            this.injectIntoClassLoader();
            this.gotoState(EnumeratorState.REGISTER);
            this.registerMods();
            this.gotoState(EnumeratorState.FINALISED);
            LiteLoaderLogger.info("Mod class discovery completed", new Object[0]);
        }
        catch (IllegalStateException ex) {
            Throwables.propagate((Throwable)ex);
        }
        catch (Throwable th) {
            LiteLoaderLogger.warning(th, "Mod class discovery failed", new Object[0]);
        }
    }

    private void injectIntoClassLoader() {
        for (EnumeratorModule module : this.modules) {
            try {
                module.injectIntoClassLoader(this, this.classLoader);
            }
            catch (Throwable th) {
                LiteLoaderLogger.warning(th, "Enumerator Module %s encountered an error whilst injecting", module.getClass().getName());
            }
        }
    }

    private void registerMods() {
        for (EnumeratorModule module : this.modules) {
            try {
                module.registerMods(this, this.classLoader);
            }
            catch (Throwable th) {
                LiteLoaderLogger.warning(th, "Enumerator Module %s encountered an error whilst registering mods", module.getClass().getName());
            }
        }
    }

    @Override
    public final boolean registerModContainer(LoadableMod<?> container) {
        this.checkState(EnumeratorState.DISCOVER, "registerModContainer");
        if (container == null) {
            return true;
        }
        if (!this.checkEnabled(container)) {
            this.registerDisabledContainer(container, ContainerRegistry.DisabledReason.USER_DISABLED);
            return false;
        }
        if (!this.checkAPIRequirements(container)) {
            this.registerDisabledContainer(container, ContainerRegistry.DisabledReason.MISSING_API);
            return false;
        }
        this.registerEnabledContainer(container);
        return true;
    }

    @Override
    public void registerBadContainer(Loadable<?> container, String reason) {
        this.checkState(EnumeratorState.DISCOVER, "registerBadContainer");
        this.containers.registerBadContainer(container, reason);
    }

    protected void registerEnabledContainer(LoadableMod<?> container) {
        this.checkState(EnumeratorState.DISCOVER, "registerEnabledContainer");
        this.containers.registerEnabledContainer(container);
        ((EnumerationObserver)this.observers.all()).onRegisterEnabledContainer(this, container);
    }

    protected void registerDisabledContainer(LoadableMod<?> container, ContainerRegistry.DisabledReason reason) {
        this.checkState(EnumeratorState.DISCOVER, "registerDisabledContainer");
        LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, reason.getMessage(container), new Object[0]);
        this.containers.registerDisabledContainer(container, reason);
        ((EnumerationObserver)this.observers.all()).onRegisterDisabledContainer(this, container, reason);
    }

    @Override
    public boolean registerTweakContainer(TweakContainer<File> container) {
        this.checkState(EnumeratorState.DISCOVER, "registerTweakContainer");
        if (!container.isEnabled(this.environment)) {
            LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Mod %s is disabled for profile %s, not injecting tranformers", container.getIdentifier(), this.environment.getProfile());
            return false;
        }
        this.containers.registerTweakContainer(container);
        ((EnumerationObserver)this.observers.all()).onRegisterTweakContainer(this, container);
        return true;
    }

    private void addTweaksFrom(TweakContainer<File> tweakContainer) {
        this.checkState(EnumeratorState.INJECT, "addTweaksFrom");
        if (this.checkDependencies(tweakContainer)) {
            if (tweakContainer.hasTweakClass()) {
                this.addTweakFrom(tweakContainer);
            }
            if (tweakContainer.hasClassTransformers()) {
                this.addClassTransformersFrom(tweakContainer);
            }
            if (tweakContainer.hasMixins()) {
                this.addMixinsFrom(tweakContainer);
            }
        }
    }

    private void addTweakFrom(TweakContainer<File> container) {
        try {
            String tweakClass = container.getTweakClassName();
            int tweakPriority = container.getTweakPriority();
            LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Mod file '%s' provides tweakClass '%s', adding to Launch queue with priority %d", container.getName(), tweakClass, tweakPriority);
            if (this.environment.addCascadedTweaker(tweakClass, tweakPriority)) {
                LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "tweakClass '%s' was successfully added", tweakClass);
                if (container.isExternalJar()) {
                    this.containers.registerInjectedTweak(container);
                }
                this.injectTweakContainer(container);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void addClassTransformersFrom(TweakContainer<File> container) {
        try {
            for (String classTransformerClass : container.getClassTransformerClassNames()) {
                LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Mod file '%s' provides classTransformer '%s', adding to class loader", container.getName(), classTransformerClass);
                ClassTransformerManager transformerManager = this.environment.getTransformerManager();
                if (transformerManager == null || !transformerManager.injectTransformer(classTransformerClass)) continue;
                LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "classTransformer '%s' was successfully added", classTransformerClass);
                this.injectContainerRecursive(container);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void addMixinsFrom(MixinContainer<File> container) {
        try {
            for (String config : container.getMixinConfigs()) {
                if (config.endsWith(".json")) {
                    LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Registering mixin config %s for %s", config, container.getName());
                    MixinEnvironment.getDefaultEnvironment().addConfiguration(config);
                    this.injectContainerRecursive(container);
                    continue;
                }
                if (!config.contains(".json@")) continue;
                int pos = config.indexOf(".json@");
                String phaseName = config.substring(pos + 6);
                config = config.substring(0, pos + 5);
                MixinEnvironment.Phase phase = MixinEnvironment.Phase.forName(phaseName);
                if (phase == null) continue;
                LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Registering mixin config %s for %s", config, container.getName());
                MixinEnvironment.getEnvironment(phase).addConfiguration(config);
                this.injectContainerRecursive(container);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    protected void injectTweakContainer(TweakContainer<File> container) throws MalformedURLException {
        if (!container.injectIntoClassPath(this.classLoader, true)) {
            return;
        }
        String[] classPathEntries = container.getClassPathEntries();
        if (classPathEntries != null) {
            for (String classPathEntry : classPathEntries) {
                try {
                    File classPathJar = new File(this.environment.getGameDirectory(), classPathEntry);
                    URL classPathJarUrl = classPathJar.toURI().toURL();
                    LiteLoaderLogger.info("Adding Class-Path entry: %s", classPathEntry);
                    LiteLoaderTweaker.addURLToParentClassLoader(classPathJarUrl);
                    this.classLoader.addURL(classPathJarUrl);
                }
                catch (MalformedURLException ex) {
                    // empty catch block
                }
            }
        }
    }

    private void injectContainerRecursive(Injectable container) throws MalformedURLException {
        if (container.injectIntoClassPath(this.classLoader, true) && container instanceof LoadableMod) {
            LoadableMod file = (LoadableMod)container;
            for (String dependency : file.getDependencies()) {
                LoadableMod<?> dependencyContainer = this.containers.getEnabledContainer(dependency);
                if (dependencyContainer == null) continue;
                this.injectContainerRecursive(dependencyContainer);
            }
        }
    }

    @Override
    public void registerModsFrom(LoadableMod<?> container, boolean registerContainer) {
        this.checkState(EnumeratorState.REGISTER, "registerModsFrom");
        if (this.containers.isDisabledContainer(container)) {
            throw new IllegalArgumentException("Attempted to register mods from a disabled container '" + container.getName() + "'");
        }
        if (this.enumeratedContainers.contains(container)) {
            return;
        }
        this.enumeratedContainers.add(container);
        ArrayList modClasses = new ArrayList();
        for (EnumeratorPlugin enumeratorPlugin : this.plugins) {
            List classes = enumeratorPlugin.getClasses(container, (ClassLoader)this.classLoader, this.validator);
            LiteLoaderLogger.debug("Plugin %s returned %d classes for %s", enumeratorPlugin.getClass(), classes.size(), container.getDisplayName());
            modClasses.addAll(classes);
        }
        for (Class clazz : modClasses) {
            Mod mod = new Mod(container, clazz);
            this.registerMod(mod);
        }
        if (modClasses.size() > 0) {
            LiteLoaderLogger.info("Found %d potential matches", modClasses.size());
            this.containers.registerEnabledContainer(container);
        }
    }

    @Override
    public void registerMod(ModInfo<LoadableMod<?>> mod) {
        this.checkState(EnumeratorState.REGISTER, "registerMod");
        if (this.modsToLoad.contains(mod)) {
            LiteLoaderLogger.warning("Mod name collision for mod with class '%s', maybe you have more than one copy?", mod.getModClassSimpleName());
        }
        this.modsToLoad.add(mod);
        ((EnumerationObserver)this.observers.all()).onModAdded(this, mod);
    }

    private boolean checkEnabled(LoadableMod<?> container) {
        for (EnumeratorPlugin plugin : this.plugins) {
            if (plugin.checkEnabled(this.containers, container)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkAPIRequirements(LoadableMod<?> container) {
        for (EnumeratorPlugin plugin : this.plugins) {
            if (plugin.checkAPIRequirements(this.containers, container)) continue;
            return false;
        }
        return true;
    }

    private void checkDependencies() {
        Collection<? extends LoadableMod<?>> enabledContainers = this.containers.getEnabledContainers();
        LinkedList containers = new LinkedList(enabledContainers);
        while (containers.size() > 0) {
            LoadableMod container = (LoadableMod)containers.pop();
            if (this.checkDependencies(container)) continue;
            this.registerDisabledContainer(container, ContainerRegistry.DisabledReason.MISSING_DEPENDENCY);
            containers.clear();
            containers.addAll(enabledContainers);
        }
    }

    @Override
    public boolean checkDependencies(LoadableMod<?> container) {
        for (EnumeratorPlugin plugin : this.plugins) {
            if (plugin.checkDependencies(this.containers, container)) continue;
            return false;
        }
        return true;
    }

    public boolean checkDependencies(TweakContainer<File> tweakContainer) {
        if (tweakContainer instanceof LoadableMod) {
            return this.checkDependencies((LoadableMod)((Object)tweakContainer));
        }
        return true;
    }

    public static String getModClassName(LiteMod mod) {
        return LiteLoaderEnumerator.getModClassName(mod.getClass());
    }

    public static String getModClassName(Class<? extends LiteMod> mod) {
        return mod.getSimpleName().substring(7);
    }

    public static enum EnumeratorState {
        INIT(null),
        DISCOVER(INIT),
        INJECT(DISCOVER),
        REGISTER(INJECT),
        FINALISED(REGISTER);

        private final EnumeratorState previousState;

        private EnumeratorState(EnumeratorState previousState) {
            this.previousState = previousState;
        }

        public boolean checkGotoState(EnumeratorState fromState) {
            if (fromState != this && fromState != this.previousState) {
                throw new IllegalStateException("Attempted to move to an invalid enumerator state " + (Object)((Object)this) + ", expected to be in state " + (Object)((Object)this.previousState) + " but current state is " + (Object)((Object)fromState));
            }
            return true;
        }
    }
}

