/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.launch;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.Blackboard;
import org.spongepowered.asm.launch.IMixinLaunchAgent;

public class MixinTweakContainer {
    public static final List<String> agentClasses = new ArrayList<String>();
    private final Logger logger = LogManager.getLogger((String)"mixin");
    private final URI uri;
    private final List<IMixinLaunchAgent> agents = new ArrayList<IMixinLaunchAgent>();

    public MixinTweakContainer(URI uri) {
        this.uri = uri;
        for (String agentClass : agentClasses) {
            try {
                Class<?> clazz = Class.forName(agentClass);
                Constructor<?> ctor = clazz.getDeclaredConstructor(URI.class);
                IMixinLaunchAgent agent = (IMixinLaunchAgent)ctor.newInstance(uri);
                this.agents.add(agent);
            }
            catch (Exception ex) {
                this.logger.catching((Throwable)ex);
            }
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public void prepare() {
        for (IMixinLaunchAgent agent : this.agents) {
            agent.prepare();
        }
    }

    public void initPrimaryContainer() {
        for (IMixinLaunchAgent agent : this.agents) {
            this.logger.debug("Processing launch tasks for {}", new Object[]{agent});
            agent.initPrimaryContainer();
        }
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        for (IMixinLaunchAgent agent : this.agents) {
            agent.injectIntoClassLoader(classLoader);
        }
    }

    public String getLaunchTarget() {
        for (IMixinLaunchAgent agent : this.agents) {
            String launchTarget = agent.getLaunchTarget();
            if (launchTarget == null) continue;
            return launchTarget;
        }
        return null;
    }

    static {
        Blackboard.put("mixin.agents", agentClasses);
        agentClasses.add("org.spongepowered.asm.launch.MixinLaunchAgentFML");
        agentClasses.add("org.spongepowered.asm.launch.MixinLaunchAgentDefault");
    }
}

