/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.transformer.InvalidMixinException;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;
import org.spongepowered.asm.mixin.transformer.meta.MixinRenamed;
import org.spongepowered.asm.util.ASMHelper;
import org.spongepowered.asm.util.Constants;
import org.spongepowered.asm.util.ConstraintParser;
import org.spongepowered.asm.util.ConstraintViolationException;
import org.spongepowered.asm.util.InvalidConstraintException;

public class MixinApplicator {
    protected static final int[] INITIALISER_OPCODE_BLACKLIST = new int[]{177, 21, 22, 23, 24, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 79, 80, 81, 82, 83, 84, 85, 86};
    protected final Logger logger = LogManager.getLogger((String)"mixin");
    protected final TargetClassContext context;
    protected final String targetName;
    protected final ClassNode targetClass;

    MixinApplicator(TargetClassContext context) {
        this.context = context;
        this.targetName = context.getClassName();
        this.targetClass = context.getClassNode();
    }

    void apply(SortedSet<MixinInfo> mixins) {
        ArrayList<MixinTargetContext> mixinContexts = new ArrayList<MixinTargetContext>();
        for (MixinInfo mixin : mixins) {
            this.logger.log(mixin.getLoggingLevel(), "Mixing {} from {} into {}", new Object[]{mixin.getName(), mixin.getParent(), this.targetName});
            mixinContexts.add(mixin.createContextFor(this.context));
        }
        MixinTargetContext current = null;
        try {
            Iterator i$ = mixinContexts.iterator();
            while (i$.hasNext()) {
                MixinTargetContext context;
                current = context = (MixinTargetContext)i$.next();
                current.preApply(this.targetName, this.targetClass);
            }
            for (ApplicatorPass pass : ApplicatorPass.values()) {
                Iterator i$2 = mixinContexts.iterator();
                while (i$2.hasNext()) {
                    MixinTargetContext context;
                    current = context = (MixinTargetContext)i$2.next();
                    this.applyMixin(current, pass);
                }
            }
            i$ = mixinContexts.iterator();
            while (i$.hasNext()) {
                MixinTargetContext context;
                current = context = (MixinTargetContext)i$.next();
                current.postApply(this.targetName, this.targetClass);
            }
        }
        catch (InvalidMixinException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidMixinException(current, "Unexpecteded error whilst applying the mixin class", (Throwable)ex);
        }
    }

    protected final void applyMixin(MixinTargetContext mixin, ApplicatorPass pass) {
        switch (pass) {
            case MAIN: {
                this.applyInterfaces(mixin);
                this.applyAttributes(mixin);
                this.applyAnnotations(mixin);
                this.applyFields(mixin);
                this.applyMethods(mixin);
                this.applyInitialisers(mixin);
                break;
            }
            case PREINJECT: {
                this.prepareInjections(mixin);
                break;
            }
            case INJECT: {
                this.applyInjections(mixin);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid pass specified " + (Object)((Object)pass));
            }
        }
    }

    protected void applyInterfaces(MixinTargetContext mixin) {
        for (String interfaceName : mixin.getInterfaces()) {
            if (this.targetClass.interfaces.contains(interfaceName)) continue;
            this.targetClass.interfaces.add(interfaceName);
            mixin.getTargetClassInfo().addInterface(interfaceName);
        }
    }

    protected void applyAttributes(MixinTargetContext mixin) {
        if (mixin.shouldSetSourceFile()) {
            this.targetClass.sourceFile = mixin.getSourceFile();
        }
        this.targetClass.version = Math.max(this.targetClass.version, mixin.getMinRequiredClassVersion());
    }

    protected void applyAnnotations(MixinTargetContext mixin) {
        ClassNode sourceClass = mixin.getClassNode();
        this.mergeAnnotations(sourceClass, this.targetClass);
    }

    protected void applyFields(MixinTargetContext mixin) {
        this.mergeShadowFieldAnnotations(mixin);
        this.mergeNewFields(mixin);
    }

    protected void mergeShadowFieldAnnotations(MixinTargetContext mixin) {
        for (FieldNode shadow : mixin.getShadowFields()) {
            FieldNode target = this.findTargetField(shadow);
            if (target == null) continue;
            this.mergeAnnotations(shadow, target);
        }
    }

    protected void mergeNewFields(MixinTargetContext mixin) {
        for (FieldNode field : mixin.getFields()) {
            FieldNode target = this.findTargetField(field);
            if (target != null) continue;
            this.targetClass.fields.add(field);
        }
    }

    protected void applyMethods(MixinTargetContext mixin) {
        for (MethodNode shadow : mixin.getShadowMethods()) {
            MethodNode target = this.findTargetMethod(shadow);
            if (target == null) continue;
            this.mergeAnnotations(shadow, target);
        }
        for (MethodNode mixinMethod : mixin.getMethods()) {
            mixin.transformMethod(mixinMethod);
            if (!mixinMethod.name.startsWith("<")) {
                boolean isOverwrite;
                AnnotationNode overwrite = ASMHelper.getVisibleAnnotation(mixinMethod, Overwrite.class);
                boolean bl = isOverwrite = overwrite != null;
                if (isOverwrite) {
                    this.checkConstraints(mixin, overwrite);
                }
                if (MixinApplicator.hasFlag(mixinMethod, 8) && !MixinApplicator.hasFlag(mixinMethod, 2) && !MixinApplicator.hasFlag(mixinMethod, 4096) && !isOverwrite) {
                    throw new InvalidMixinException(mixin, String.format("Mixin classes cannot contain visible static methods or fields, found %s", mixinMethod.name));
                }
                this.mergeMethod(mixin, mixinMethod, isOverwrite);
                continue;
            }
            if (!"<clinit>".equals(mixinMethod.name)) continue;
            this.appendInsns(mixinMethod);
        }
    }

    protected void mergeMethod(MixinTargetContext mixin, MethodNode method, boolean isOverwrite) {
        MethodNode target = this.findTargetMethod(method);
        if (target != null) {
            if (this.isAlreadyMerged(mixin, method, isOverwrite, target)) {
                return;
            }
            AnnotationNode intrinsic = ASMHelper.getInvisibleAnnotation(method, Intrinsic.class);
            if (intrinsic != null) {
                if (this.mergeIntrinsic(mixin, method, isOverwrite, target, intrinsic)) {
                    return;
                }
            } else {
                this.targetClass.methods.remove(target);
            }
        } else if (isOverwrite) {
            throw new InvalidMixinException(mixin, String.format("Overwrite target %s was not located in the target class", method.name));
        }
        this.targetClass.methods.add(method);
        mixin.addMergedMethod(method);
    }

    protected boolean isAlreadyMerged(MixinTargetContext mixin, MethodNode method, boolean isOverwrite, MethodNode target) {
        AnnotationNode merged = ASMHelper.getVisibleAnnotation(target, MixinMerged.class);
        if (merged == null) {
            if (ASMHelper.getVisibleAnnotation(target, Final.class) != null) {
                this.logger.warn("Overwrite prohibited for @Final method {} in {}. Skipping method.", new Object[]{method.name, mixin});
                return true;
            }
            return false;
        }
        String sessionId = (String)ASMHelper.getAnnotationValue(merged, "sessionId");
        if (!this.context.getSessionId().equals(sessionId)) {
            throw new ClassFormatError("Invalid @MixinMerged annotation found in" + mixin + " at " + method.name + " in " + this.targetClass.name);
        }
        if (MixinApplicator.hasFlag(target, 4160) && MixinApplicator.hasFlag(method, 4160)) {
            if (mixin.getEnvironment().getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) {
                this.logger.warn("Synthetic bridge method clash for {} in {}", new Object[]{method.name, mixin});
            }
            return true;
        }
        String owner = (String)ASMHelper.getAnnotationValue(merged, "mixin");
        int priority = (Integer)ASMHelper.getAnnotationValue(merged, "priority");
        if (priority >= mixin.getPriority() && !owner.equals(mixin.getClassName())) {
            this.logger.warn("Method overwrite conflict for {} in {}, previously written by {}. Skipping method.", new Object[]{method.name, mixin, owner});
            return true;
        }
        if (ASMHelper.getVisibleAnnotation(target, Final.class) != null) {
            this.logger.warn("Method overwrite conflict for @Final method {} in {} declared by {}. Skipping method.", new Object[]{method.name, mixin, owner});
            return true;
        }
        return false;
    }

    protected boolean mergeIntrinsic(MixinTargetContext mixin, MethodNode method, boolean isOverwrite, MethodNode target, AnnotationNode intrinsic) {
        if (isOverwrite) {
            throw new InvalidMixinException(mixin, "@Intrinsic is not compatible with @Overwrite, remove one of these annotations on " + method.name);
        }
        if (MixinApplicator.hasFlag(method, 8)) {
            throw new InvalidMixinException(mixin, "@Intrinsic method cannot be static, found " + method.name);
        }
        AnnotationNode renamed = ASMHelper.getVisibleAnnotation(method, MixinRenamed.class);
        if (renamed == null || !ASMHelper.getAnnotationValue(renamed, "isInterfaceMember", false).booleanValue()) {
            throw new InvalidMixinException(mixin, "@Intrinsic method must be prefixed interface method, no rename encountered on " + method.name);
        }
        if (!ASMHelper.getAnnotationValue(intrinsic, "displace", false).booleanValue()) {
            this.logger.log(mixin.getLoggingLevel(), "Skipping Intrinsic mixin method {}", new Object[]{method.name});
            return true;
        }
        this.displaceIntrinsic(mixin, method, target);
        return false;
    }

    protected void displaceIntrinsic(MixinTargetContext mixin, MethodNode method, MethodNode target) {
        String proxyName = "proxy+" + target.name;
        ListIterator<AbstractInsnNode> iter = method.instructions.iterator();
        while (iter.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iter.next();
            if (!(insn instanceof MethodInsnNode) || insn.getOpcode() == 184) continue;
            MethodInsnNode methodNode = (MethodInsnNode)insn;
            if (!methodNode.owner.equals(this.targetClass.name) || !methodNode.name.equals(target.name) || !methodNode.desc.equals(target.desc)) continue;
            methodNode.name = proxyName;
        }
        target.name = proxyName;
    }

    protected final void appendInsns(MethodNode method) {
        if (Type.getReturnType(method.desc) != Type.VOID_TYPE) {
            throw new IllegalArgumentException("Attempted to merge insns from a method which does not return void");
        }
        MethodNode target = this.findTargetMethod(method);
        if (target != null) {
            AbstractInsnNode returnNode = MixinApplicator.findInsn(target, 177);
            if (returnNode != null) {
                ListIterator<AbstractInsnNode> injectIter = method.instructions.iterator();
                while (injectIter.hasNext()) {
                    AbstractInsnNode insn = (AbstractInsnNode)injectIter.next();
                    if (insn instanceof LineNumberNode || insn.getOpcode() == 177) continue;
                    target.instructions.insertBefore(returnNode, insn);
                }
                target.maxLocals = Math.max(target.maxLocals, method.maxLocals);
                target.maxStack = Math.max(target.maxStack, method.maxStack);
            }
            return;
        }
        this.targetClass.methods.add(method);
    }

    protected void applyInitialisers(MixinTargetContext mixin) {
        MethodNode ctor = this.getConstructor(mixin);
        if (ctor == null) {
            return;
        }
        Deque<AbstractInsnNode> initialiser = this.getInitialiser(mixin, ctor);
        if (initialiser == null || initialiser.size() == 0) {
            return;
        }
        for (MethodNode method : this.targetClass.methods) {
            if (!"<init>".equals(method.name)) continue;
            method.maxStack = Math.max(method.maxStack, ctor.maxStack);
            this.injectInitialiser(mixin, method, initialiser);
        }
    }

    protected MethodNode getConstructor(MixinTargetContext mixin) {
        MethodNode ctor = null;
        for (MethodNode mixinMethod : mixin.getMethods()) {
            if (!"<init>".equals(mixinMethod.name) || !MixinApplicator.hasLineNumbers(mixinMethod)) continue;
            if (ctor == null) {
                ctor = mixinMethod;
                continue;
            }
            this.logger.warn(String.format("Mixin %s has multiple constructors, %s was selected\n", mixin, ctor.desc));
        }
        return ctor;
    }

    private Range getConstructorRange(MethodNode ctor) {
        boolean lineNumberIsValid = false;
        AbstractInsnNode endReturn = null;
        int line = 0;
        int start = 0;
        int end = 0;
        int superIndex = -1;
        ListIterator<AbstractInsnNode> iter = ctor.instructions.iterator();
        while (iter.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iter.next();
            if (insn instanceof LineNumberNode) {
                line = ((LineNumberNode)insn).line;
                lineNumberIsValid = true;
                continue;
            }
            if (insn instanceof MethodInsnNode) {
                if (insn.getOpcode() != 183 || !"<init>".equals(((MethodInsnNode)insn).name) || superIndex != -1) continue;
                superIndex = ctor.instructions.indexOf(insn);
                start = line;
                continue;
            }
            if (insn.getOpcode() == 181) {
                lineNumberIsValid = false;
                continue;
            }
            if (insn.getOpcode() != 177) continue;
            if (lineNumberIsValid) {
                end = line;
                continue;
            }
            end = start;
            endReturn = insn;
        }
        if (endReturn != null) {
            LabelNode label = new LabelNode(new Label());
            ctor.instructions.insertBefore(endReturn, label);
            ctor.instructions.insertBefore(endReturn, new LineNumberNode(start, label));
        }
        return new Range(start, end, superIndex);
    }

    protected final Deque<AbstractInsnNode> getInitialiser(MixinTargetContext mixin, MethodNode ctor) {
        Range init = this.getConstructorRange(ctor);
        if (!init.isValid()) {
            return null;
        }
        int line = 0;
        ArrayDeque<AbstractInsnNode> initialiser = new ArrayDeque<AbstractInsnNode>();
        boolean gatherNodes = false;
        int trimAtOpcode = -1;
        LabelNode optionalInsn = null;
        ListIterator<AbstractInsnNode> iter = ctor.instructions.iterator(init.marker);
        while (iter.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iter.next();
            if (insn instanceof LineNumberNode) {
                line = ((LineNumberNode)insn).line;
                AbstractInsnNode next = ctor.instructions.get(ctor.instructions.indexOf(insn) + 1);
                if (line == init.end && next.getOpcode() != 177) {
                    gatherNodes = true;
                    trimAtOpcode = 177;
                    continue;
                }
                gatherNodes = init.excludes(line);
                trimAtOpcode = -1;
                continue;
            }
            if (!gatherNodes) continue;
            if (optionalInsn != null) {
                initialiser.add(optionalInsn);
                optionalInsn = null;
            }
            if (insn instanceof LabelNode) {
                optionalInsn = (LabelNode)insn;
                continue;
            }
            int opcode = insn.getOpcode();
            if (opcode == trimAtOpcode) {
                trimAtOpcode = -1;
                continue;
            }
            for (int ivalidOp : INITIALISER_OPCODE_BLACKLIST) {
                if (opcode != ivalidOp) continue;
                throw new InvalidMixinException(mixin, "Cannot handle " + ASMHelper.getOpcodeName(opcode) + " opcode (0x" + Integer.toHexString(opcode).toUpperCase() + ") in class initialiser");
            }
            initialiser.add(insn);
        }
        AbstractInsnNode last = (AbstractInsnNode)initialiser.peekLast();
        if (last != null && last.getOpcode() != 181) {
            throw new InvalidMixinException(mixin, "Could not parse initialiser, expected 0xB5, found 0x" + Integer.toHexString(last.getOpcode()));
        }
        return initialiser;
    }

    protected final void injectInitialiser(MixinTargetContext mixin, MethodNode ctor, Deque<AbstractInsnNode> initialiser) {
        Map<LabelNode, LabelNode> labels = ASMHelper.cloneLabels(ctor.instructions);
        ListIterator<AbstractInsnNode> iter = ctor.instructions.iterator(0);
        while (iter.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iter.next();
            if (insn.getOpcode() != 183 || !"<init>".equals(((MethodInsnNode)insn).name)) continue;
            for (AbstractInsnNode node : initialiser) {
                if (node instanceof LabelNode) continue;
                if (node instanceof JumpInsnNode) {
                    throw new InvalidMixinException(mixin, "Unsupported opcode in initialiser");
                }
                AbstractInsnNode imACloneNow = node.clone(labels);
                ctor.instructions.insert(insn, imACloneNow);
                insn = imACloneNow;
            }
            return;
        }
        this.logger.warn("Failed to locate super-invoke whilst injecting initialiser, initialiser was not mixed in!");
    }

    protected void prepareInjections(MixinTargetContext mixin) {
        mixin.prepareInjections();
    }

    protected void applyInjections(MixinTargetContext mixin) {
        mixin.applyInjections();
    }

    protected final void checkConstraints(MixinTargetContext mixin, AnnotationNode annotation) {
        block5: {
            try {
                ConstraintParser.Constraint constraint = ConstraintParser.parse(annotation);
                MixinEnvironment environment = MixinEnvironment.getCurrentEnvironment();
                try {
                    constraint.check(environment);
                }
                catch (ConstraintViolationException ex) {
                    if (environment.getOption(MixinEnvironment.Option.IGNORE_CONSTRAINTS)) {
                        this.logger.warn("Constraint violation: {}", new Object[]{ex.getMessage()});
                        break block5;
                    }
                    throw new InvalidMixinException(mixin, ex.getMessage(), (Throwable)ex);
                }
            }
            catch (InvalidConstraintException ex) {
                throw new InvalidMixinException(mixin, ex.getMessage());
            }
        }
    }

    protected final void mergeAnnotations(ClassNode from, ClassNode to) {
        to.visibleAnnotations = this.mergeAnnotations(from.visibleAnnotations, to.visibleAnnotations, from.name);
        to.invisibleAnnotations = this.mergeAnnotations(from.invisibleAnnotations, to.invisibleAnnotations, from.name);
    }

    protected final void mergeAnnotations(MethodNode from, MethodNode to) {
        to.visibleAnnotations = this.mergeAnnotations(from.visibleAnnotations, to.visibleAnnotations, from.name);
        to.invisibleAnnotations = this.mergeAnnotations(from.invisibleAnnotations, to.invisibleAnnotations, from.name);
    }

    protected final void mergeAnnotations(FieldNode from, FieldNode to) {
        to.visibleAnnotations = this.mergeAnnotations(from.visibleAnnotations, to.visibleAnnotations, from.name);
        to.invisibleAnnotations = this.mergeAnnotations(from.invisibleAnnotations, to.invisibleAnnotations, from.name);
    }

    private List<AnnotationNode> mergeAnnotations(List<AnnotationNode> from, List<AnnotationNode> to, String name) {
        try {
            if (from == null) {
                return to;
            }
            if (to == null) {
                to = new ArrayList<AnnotationNode>();
            }
            for (AnnotationNode annotation : from) {
                if (annotation.desc.startsWith("L" + Constants.MIXIN_PACKAGE_REF)) continue;
                Iterator<AnnotationNode> iter = to.iterator();
                while (iter.hasNext()) {
                    if (!iter.next().desc.equals(annotation.desc)) continue;
                    iter.remove();
                    break;
                }
                to.add(annotation);
            }
        }
        catch (Exception ex) {
            this.logger.warn("Exception encountered whilst merging annotations for {}", new Object[]{name});
        }
        return to;
    }

    protected static AbstractInsnNode findInsn(MethodNode method, int opcode) {
        ListIterator<AbstractInsnNode> findReturnIter = method.instructions.iterator();
        while (findReturnIter.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)findReturnIter.next();
            if (insn.getOpcode() != opcode) continue;
            return insn;
        }
        return null;
    }

    private static boolean hasLineNumbers(MethodNode method) {
        ListIterator<AbstractInsnNode> iter = method.instructions.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof LineNumberNode)) continue;
            return true;
        }
        return false;
    }

    protected final MethodNode findTargetMethod(MethodNode searchFor) {
        for (MethodNode target : this.targetClass.methods) {
            if (!target.name.equals(searchFor.name) || !target.desc.equals(searchFor.desc)) continue;
            return target;
        }
        return null;
    }

    protected final FieldNode findTargetField(FieldNode searchFor) {
        for (FieldNode target : this.targetClass.fields) {
            if (!target.name.equals(searchFor.name)) continue;
            return target;
        }
        return null;
    }

    protected static boolean hasFlag(MethodNode method, int flag) {
        return (method.access & flag) == flag;
    }

    protected static boolean hasFlag(FieldNode field, int flag) {
        return (field.access & flag) == flag;
    }

    class Range {
        final int start;
        final int end;
        final int marker;

        Range(int start, int end, int marker) {
            this.start = start;
            this.end = end;
            this.marker = marker;
        }

        boolean isValid() {
            return this.start != 0 && this.end != 0 && this.end >= this.start;
        }

        boolean contains(int value) {
            return value >= this.start && value <= this.end;
        }

        boolean excludes(int value) {
            return value < this.start || value > this.end;
        }

        public String toString() {
            return String.format("Range[%d-%d,%d,valid=%s)", this.start, this.end, this.marker, this.isValid());
        }
    }

    static enum ApplicatorPass {
        MAIN,
        PREINJECT,
        INJECT;

    }
}

