/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import org.spongepowered.asm.obfuscation.SrgMethod;
import org.spongepowered.tools.MirrorUtils;
import org.spongepowered.tools.obfuscation.AnnotatedMixin;
import org.spongepowered.tools.obfuscation.AnnotatedMixinElementHandler;
import org.spongepowered.tools.obfuscation.ObfuscationData;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;

class AnnotatedMixinShadowHandler
extends AnnotatedMixinElementHandler {
    AnnotatedMixinShadowHandler(IMixinAnnotationProcessor ap, AnnotatedMixin mixin) {
        super(ap, mixin);
    }

    public void registerShadow(VariableElement field, AnnotationMirror shadow, boolean remap) {
        AnnotatedMixinElementHandler.ShadowElementName name = new AnnotatedMixinElementHandler.ShadowElementName(field, shadow);
        this.validateTargetField(field, shadow, name, "@Shadow");
        if (!remap || !this.validateSingleTarget("@Shadow", field)) {
            return;
        }
        ObfuscationData<String> obfFieldData = this.obf.getObfField(this.mixin.getPrimaryTargetRef() + "/" + name);
        if (obfFieldData.isEmpty()) {
            this.ap.printMessage(Diagnostic.Kind.WARNING, "Unable to locate obfuscation mapping for @Shadow field", field, shadow);
            return;
        }
        for (ObfuscationType type : obfFieldData) {
            String fieldName = obfFieldData.get(type);
            this.addFieldMapping(type, name.setObfuscatedName(fieldName));
        }
    }

    public void registerShadow(ExecutableElement method, AnnotationMirror shadow, boolean remap) {
        AnnotatedMixinElementHandler.ShadowElementName name = new AnnotatedMixinElementHandler.ShadowElementName(method, shadow);
        this.validateTargetMethod(method, shadow, name, "@Shadow");
        if (!remap || !this.validateSingleTarget("@Shadow", method)) {
            return;
        }
        String mcpSignature = MirrorUtils.generateSignature(method);
        ObfuscationData<SrgMethod> obfData = this.obf.getObfMethod(new SrgMethod(this.mixin.getPrimaryTargetRef() + "/" + name, mcpSignature));
        if (obfData.isEmpty()) {
            this.ap.printMessage(Diagnostic.Kind.WARNING, "Unable to locate obfuscation mapping for @Shadow method", method, shadow);
            return;
        }
        for (ObfuscationType type : obfData) {
            SrgMethod obfMethod = obfData.get(type);
            this.addMethodMapping(type, name.setObfuscatedName(obfMethod.getName()), mcpSignature, obfMethod.getDesc());
        }
    }
}

