/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.mixin.injection.struct.ReferenceMapper;
import org.spongepowered.asm.obfuscation.SrgField;
import org.spongepowered.asm.obfuscation.SrgMethod;
import org.spongepowered.tools.obfuscation.AnnotatedMixin;
import org.spongepowered.tools.obfuscation.ObfuscationData;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.TargetObfuscationEnvironment;
import org.spongepowered.tools.obfuscation.TypeHandle;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IObfuscationManager;

public class ObfuscationManager
implements IObfuscationManager {
    private final IMixinAnnotationProcessor ap;
    private final String outRefMapFileName;
    private final List<TargetObfuscationEnvironment> targetEnvironments = new ArrayList<TargetObfuscationEnvironment>();
    private final ReferenceMapper refMapper = new ReferenceMapper();

    public ObfuscationManager(IMixinAnnotationProcessor ap) {
        this.ap = ap;
        this.outRefMapFileName = this.ap.getOption("outRefMapFile");
        for (ObfuscationType obfType : ObfuscationType.values()) {
            if (!obfType.isSupported(this.ap)) continue;
            this.targetEnvironments.add(new TargetObfuscationEnvironment(ap, obfType, this.refMapper));
        }
    }

    @Override
    public ReferenceMapper getReferenceMapper() {
        return this.refMapper;
    }

    public void writeSrgs(Map<String, AnnotatedMixin> mixins) {
        for (TargetObfuscationEnvironment targetEnv : this.targetEnvironments) {
            targetEnv.writeSrgs(this.ap.getProcessingEnvironment().getFiler(), mixins);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRefs() {
        if (this.outRefMapFileName == null) {
            return;
        }
        PrintWriter writer = null;
        try {
            writer = this.newWriter(this.outRefMapFileName, "refmap");
            this.refMapper.write(writer);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private PrintWriter newWriter(String fileName, String description) throws IOException {
        if (fileName.matches("^.*[\\\\/:].*$")) {
            File outSrgFile = new File(fileName);
            outSrgFile.getParentFile().mkdirs();
            this.ap.printMessage(Diagnostic.Kind.NOTE, "Writing " + description + " to " + outSrgFile.getAbsolutePath());
            return new PrintWriter(outSrgFile);
        }
        FileObject outSrg = this.ap.getProcessingEnvironment().getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", fileName, new Element[0]);
        this.ap.printMessage(Diagnostic.Kind.NOTE, "Writing " + description + " to " + new File(outSrg.toUri()).getAbsolutePath());
        return new PrintWriter(outSrg.openWriter());
    }

    @Override
    public <T> ObfuscationData<T> getObfEntryRecursive(MemberInfo targetMember) {
        MemberInfo currentTarget = targetMember;
        ObfuscationData<String> obfTargetNames = this.getObfClass(currentTarget.owner);
        ObfuscationData<Object> obfData = this.getObfEntry(currentTarget);
        try {
            while (obfData.isEmpty()) {
                TypeHandle targetType = this.ap.getTypeProvider().getTypeHandle(currentTarget.owner);
                if (targetType == null) {
                    return obfData;
                }
                TypeHandle superClass = targetType.getSuperclass();
                if (superClass == null) {
                    return obfData;
                }
                obfData = this.getObfEntry(currentTarget = currentTarget.move(superClass.getName()));
                if (obfData.isEmpty()) continue;
                for (ObfuscationType type : obfData) {
                    String obfClass = obfTargetNames.get(type);
                    T obfMember = obfData.get(type);
                    if (currentTarget.isField()) {
                        obfData.add(type, MemberInfo.fromSrgField(obfMember.toString(), "").move(obfClass).toSrg());
                        continue;
                    }
                    obfData.add(type, MemberInfo.fromSrgMethod((SrgMethod)obfMember).move(obfClass).asSrgMethod());
                }
            }
        }
        catch (Exception ex) {
            return this.getObfEntry(targetMember);
        }
        return obfData;
    }

    @Override
    public <T> ObfuscationData<T> getObfEntry(MemberInfo targetMember) {
        if (targetMember.isField()) {
            return this.getObfField(targetMember.toSrg());
        }
        return this.getObfMethod(targetMember.asSrgMethod());
    }

    @Override
    public ObfuscationData<SrgMethod> getObfMethodRecursive(MemberInfo targetMember) {
        return this.getObfEntryRecursive(targetMember);
    }

    @Override
    public ObfuscationData<SrgMethod> getObfMethod(MemberInfo method) {
        ObfuscationData<SrgMethod> data = new ObfuscationData<SrgMethod>();
        for (TargetObfuscationEnvironment targetEnv : this.targetEnvironments) {
            SrgMethod obfMethod = targetEnv.getObfMethod(method);
            if (obfMethod == null) continue;
            data.add(targetEnv.getType(), obfMethod);
        }
        if (!data.isEmpty() || !"<init>".equals(method.name)) {
            return data;
        }
        return this.remapDescriptor(data, method);
    }

    @Override
    public ObfuscationData<SrgMethod> getObfMethod(SrgMethod method) {
        ObfuscationData<SrgMethod> data = new ObfuscationData<SrgMethod>();
        for (TargetObfuscationEnvironment targetEnv : this.targetEnvironments) {
            SrgMethod obfMethod = targetEnv.getObfMethod(method);
            if (obfMethod == null) continue;
            data.add(targetEnv.getType(), obfMethod);
        }
        if (!data.isEmpty() || !"<init>".equals(method.getSimpleName())) {
            return data;
        }
        return this.remapDescriptor(data, new MemberInfo(method));
    }

    public ObfuscationData<SrgMethod> remapDescriptor(ObfuscationData<SrgMethod> data, MemberInfo method) {
        for (TargetObfuscationEnvironment targetEnv : this.targetEnvironments) {
            MemberInfo obfMethod = targetEnv.remapDescriptor(method);
            if (obfMethod == null) continue;
            data.add(targetEnv.getType(), obfMethod.asSrgMethod());
        }
        return data;
    }

    @Override
    public ObfuscationData<String> getObfFieldRecursive(MemberInfo targetMember) {
        return this.getObfEntryRecursive(targetMember);
    }

    @Override
    public ObfuscationData<String> getObfField(String field) {
        ObfuscationData<String> data = new ObfuscationData<String>();
        for (TargetObfuscationEnvironment targetEnv : this.targetEnvironments) {
            SrgField obfField = targetEnv.getObfField(field);
            if (obfField == null) continue;
            data.add(targetEnv.getType(), obfField.toString());
        }
        return data;
    }

    @Override
    public ObfuscationData<String> getObfClass(TypeHandle type) {
        return this.getObfClass(type.getName());
    }

    @Override
    public ObfuscationData<String> getObfClass(String className) {
        ObfuscationData<String> data = new ObfuscationData<String>(className);
        for (TargetObfuscationEnvironment targetEnv : this.targetEnvironments) {
            String obfClass = targetEnv.getObfClass(className);
            if (obfClass == null) continue;
            data.add(targetEnv.getType(), obfClass);
        }
        return data;
    }

    @Override
    public void addMethodMapping(String className, String reference, ObfuscationData<SrgMethod> obfMethodData) {
        for (TargetObfuscationEnvironment targetEnv : this.targetEnvironments) {
            SrgMethod obfMethod = obfMethodData.get(targetEnv.getType());
            if (obfMethod == null) continue;
            MemberInfo remappedReference = new MemberInfo(obfMethod);
            targetEnv.addMapping(className, reference, remappedReference.toString());
        }
    }

    @Override
    public void addMethodMapping(String className, String reference, MemberInfo context, ObfuscationData<SrgMethod> obfMethodData) {
        for (TargetObfuscationEnvironment targetEnv : this.targetEnvironments) {
            SrgMethod obfMethod = obfMethodData.get(targetEnv.getType());
            if (obfMethod == null) continue;
            MemberInfo remappedReference = context.remapUsing(obfMethod, true);
            targetEnv.addMapping(className, reference, remappedReference.toString());
        }
    }

    @Override
    public void addFieldMapping(String className, String reference, MemberInfo context, ObfuscationData<String> obfFieldData) {
        for (TargetObfuscationEnvironment targetEnv : this.targetEnvironments) {
            String obfField = obfFieldData.get(targetEnv.getType());
            if (obfField == null) continue;
            MemberInfo remappedReference = MemberInfo.fromSrgField(obfField, context.desc);
            String remapped = remappedReference.toString();
            targetEnv.addMapping(className, reference, remapped);
        }
    }

    @Override
    public void addClassMapping(String className, String reference, ObfuscationData<String> obfClassData) {
        for (TargetObfuscationEnvironment targetEnv : this.targetEnvironments) {
            String remapped = obfClassData.get(targetEnv.getType());
            if (remapped == null) continue;
            targetEnv.addMapping(className, reference, remapped);
        }
    }
}

