/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.floatingruins;

import bspkrs.floatingruins.FRLog;
import bspkrs.floatingruins.FloatingRuins;
import bspkrs.floatingruins.WorldGenFloatingIslandRuin;
import bspkrs.util.CommonUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.registry.GameData;

public class WorldGenFloatingIsland
extends WorldGenerator {
    private boolean isLavaNearby;
    public static final int SPHEROID = 0;
    public static final int CONE = 1;
    public static final int JETSONS = 2;
    public static final int STALACTITE = 3;
    private BlockPos srcOrigin;
    private BlockPos tgtOrigin;
    private final int depth;
    public final int radius;
    public final int yGround;
    private final int islandType;
    private Random random;
    private String failureReason = "";

    public WorldGenFloatingIsland(int radius, int depth, int yGround, int islandType) {
        this.radius = radius;
        this.depth = depth;
        this.yGround = yGround;
        this.islandType = islandType == 2 && depth < 30 ? 1 : islandType;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        boolean ran = false;
        this.random = FloatingRuins.getRandom(world, pos);
        if (this.yGround == 0) {
            return false;
        }
        this.srcOrigin = new BlockPos(pos.func_177958_n(), this.yGround, pos.func_177952_p());
        this.tgtOrigin = new BlockPos((Vec3i)pos);
        this.isLavaNearby = false;
        if (this.isTgtSuitableForGeneration(world, this.tgtOrigin) && (ran = this.genIsland(world, this.radius, pos)) && random.nextInt(FloatingRuins.rarityDungeon) == 0) {
            new WorldGenFloatingIslandRuin(this.isLavaNearby).func_180709_b(world, random, pos);
        }
        return ran;
    }

    public boolean isTgtSuitableForGeneration(World world, BlockPos tgtOrigin) {
        FRLog.debug("Checking target area for generation suitability...", new Object[0]);
        for (int y = 40; y >= -this.depth; --y) {
            for (int x = -this.radius - 4; x <= this.radius + 4; ++x) {
                for (int z = -this.radius - 4; z <= this.radius + 4; ++z) {
                    BlockPos delta;
                    BlockPos tgt;
                    if (y != 40 && y != -this.depth && Math.abs(x) != this.radius && Math.abs(z) != this.radius && Math.abs(x) != this.radius + 4 && Math.abs(z) != this.radius + 4 || this.isTgtBlockPosReplaceable(world, tgt = tgtOrigin.func_177971_a((Vec3i)(delta = new BlockPos(x, y, z))), y < tgtOrigin.func_177956_o())) continue;
                    FRLog.debug("Target BlockPos is not replaceable: %s", tgt.toString());
                    FRLog.debug(this.failureReason, new Object[0]);
                    return false;
                }
            }
        }
        FRLog.debug("Target area found to be suitable.", new Object[0]);
        return true;
    }

    public boolean isTgtBlockPosReplaceable(World world, BlockPos tgt, boolean allowNonAirSpecialBlocks) {
        IBlockState state = world.func_180495_p(tgt);
        Block block = state.func_177230_c();
        if (!world.func_175668_a(tgt, false)) {
            this.failureReason = "Chunk does not exist.";
        } else if (!(world.func_175623_d(tgt) || allowNonAirSpecialBlocks && block.equals(Blocks.field_150355_j) || allowNonAirSpecialBlocks && !world.func_175677_d(tgt, true) || allowNonAirSpecialBlocks && block.isWood((IBlockAccess)world, tgt) || allowNonAirSpecialBlocks && block.isLeaves((IBlockAccess)world, tgt))) {
            this.failureReason = "Block at target is not replaceable.";
        }
        return this.failureReason.isEmpty();
    }

    private boolean genIsland(World world, int radius, BlockPos posIn) {
        Block block;
        IBlockState state;
        BlockPos delta;
        int z;
        int blocksMoved = 0;
        int groundBlocksMoved = 0;
        int blockNotifications = 0;
        String debug = "Floating Island: ";
        debug = this.islandType == 1 ? debug + "Cone " : (this.islandType == 2 ? debug + "Jetsons " : debug + "Spheroid ");
        debug = debug + String.format("r(%d) d(%d) @%s ", radius, this.depth, posIn.toString());
        Block specialOre = this.getSpecialOre();
        for (int y = 40; y >= -this.depth; --y) {
            float range;
            if (y >= 0) {
                range = radius;
            } else {
                switch (this.islandType) {
                    case 1: {
                        if (y >= -1) {
                            range = (float)((double)radius + (y > 9 ? 3.5 : (y > 5 ? 2.5 : (y > 1 ? 1.5 : 0.0))));
                            break;
                        }
                        range = (1.0f - Math.abs(((float)y + 1.0f) / ((float)this.depth - 1.0f))) * (float)radius;
                        break;
                    }
                    case 2: {
                        float jetDist = (float)this.depth / (float)Math.abs(y) - 1.0f;
                        if (y >= -1) {
                            range = radius;
                            break;
                        }
                        if (y == -2) {
                            range = (int)Math.round(Math.min(Math.ceil((float)radius * 0.9f), (double)jetDist));
                            break;
                        }
                        if (y == -3) {
                            range = (int)Math.round(Math.min(Math.ceil((float)radius * 0.8f), (double)jetDist));
                            break;
                        }
                        range = Math.round(jetDist);
                        break;
                    }
                    default: {
                        range = Math.round(Math.sqrt((float)CommonUtils.sqr((int)radius) * (1.0f - (float)CommonUtils.sqr((int)y) / (float)CommonUtils.sqr((int)this.depth))));
                    }
                }
            }
            if (range <= 0.0f) {
                range = -4.0f;
            }
            int x = (int)(-range - 4.0f);
            while ((float)x <= range + 4.0f) {
                z = (int)(-range - 4.0f);
                while ((float)z <= range + 4.0f) {
                    delta = new BlockPos(x, y, z);
                    BlockPos src = this.srcOrigin.func_177971_a((Vec3i)delta);
                    if (!world.func_175623_d(src) && this.isBlockInRange(this.islandType, world, delta, this.depth, radius)) {
                        state = world.func_180495_p(src);
                        block = state.func_177230_c();
                        int metadata = block.func_176201_c(state);
                        BlockPos tgt = this.tgtOrigin.func_177971_a((Vec3i)delta);
                        if (!(y > 0 && (block.equals(Blocks.field_150355_j) || block.equals(Blocks.field_150358_i)) || CommonUtils.isIDInList((String)GameData.getBlockRegistry().func_177774_c((Object)block).toString(), (int)metadata, (String)FloatingRuins.blockIDBlacklist))) {
                            if (block.equals(Blocks.field_150474_ac)) {
                                debug = debug + "+S(" + tgt + ") ";
                            } else if (block.equals(Blocks.field_150486_ae)) {
                                debug = debug + "+C(" + tgt + ") ";
                            } else if (y >= -8 && !this.isLavaNearby && (block.equals(Blocks.field_150353_l) || block.equals(Blocks.field_150356_k))) {
                                this.isLavaNearby = true;
                                debug = debug + "+L ";
                            }
                            if (!(y < 0 && this.isBlockInRange(this.islandType, world, delta.func_177977_b(), this.depth, radius) && this.isBlockInRange(this.islandType, world, delta.func_177978_c(), this.depth, radius) && this.isBlockInRange(this.islandType, world, delta.func_177968_d(), this.depth, radius) && this.isBlockInRange(this.islandType, world, delta.func_177974_f(), this.depth, radius) && this.isBlockInRange(this.islandType, world, delta.func_177976_e(), this.depth, radius))) {
                                CommonUtils.moveBlock((World)world, (BlockPos)src, (BlockPos)tgt, (boolean)true);
                                ++blockNotifications;
                            } else {
                                CommonUtils.moveBlock((World)world, (BlockPos)src, (BlockPos)tgt, (boolean)true, (int)0);
                            }
                            if (y <= 0) {
                                ++groundBlocksMoved;
                            }
                            ++blocksMoved;
                        }
                        if (this.random.nextInt(3) == 0 && block.equals(Blocks.field_150348_b) && Math.abs(x) <= 1 && Math.abs(z) <= 1 && Math.abs(y + this.depth / 4) <= 2) {
                            world.func_180501_a(tgt, specialOre.func_176223_P(), 0);
                        }
                    }
                    ++z;
                }
                ++x;
            }
        }
        for (int x = -radius; x <= radius; ++x) {
            for (int y = 5; y >= -this.depth; --y) {
                for (z = -radius; z <= radius; ++z) {
                    delta = new BlockPos(x, y, z);
                    BlockPos tgt = this.tgtOrigin.func_177971_a((Vec3i)delta);
                    state = world.func_180495_p(tgt);
                    block = state.func_177230_c();
                    if (world.func_175623_d(tgt) || !world.func_175623_d(tgt.func_177977_b())) continue;
                    if (block.equals(Blocks.field_150351_n)) {
                        world.func_180501_a(tgt, Blocks.field_150348_b.func_176223_P(), 3);
                        continue;
                    }
                    if (!block.equals(Blocks.field_150354_m)) continue;
                    if (block.func_176201_c(state) == 1) {
                        world.func_180501_a(tgt, Blocks.field_150405_ch.func_176223_P(), 3);
                        continue;
                    }
                    world.func_180501_a(tgt, Blocks.field_150322_A.func_176223_P(), 3);
                }
            }
        }
        debug = debug + "Blocks Moved: " + blocksMoved + " (" + groundBlocksMoved + " at or below origin, " + blockNotifications + " block notifications)";
        FloatingRuins.debug(debug, new Object[0]);
        return true;
    }

    private boolean isBlockInRange(int islandType, World world, BlockPos delta, int depth, int radius) {
        float depthRatio = (float)depth / (float)radius;
        float distToCenterColumn = Math.round(Math.sqrt(CommonUtils.sqr((int)delta.func_177958_n()) + CommonUtils.sqr((int)delta.func_177952_p())));
        float distToOrigin = Math.round(Math.sqrt((double)(CommonUtils.sqr((int)delta.func_177958_n()) + CommonUtils.sqr((int)delta.func_177952_p())) + (delta.func_177956_o() > 10 ? -2.0 : (delta.func_177956_o() > 5 ? -1.0 : (delta.func_177956_o() > 0 ? 0.0 : (double)CommonUtils.sqr((float)((float)delta.func_177956_o() / depthRatio)))))));
        if (islandType == 1) {
            if (delta.func_177956_o() >= -1) {
                return (double)distToCenterColumn <= (double)radius + (delta.func_177956_o() > 9 ? 3.5 : (delta.func_177956_o() > 5 ? 2.5 : (delta.func_177956_o() > 1 ? 1.5 : 0.0)));
            }
            return distToCenterColumn <= (1.0f - Math.abs(((float)delta.func_177956_o() + 1.0f) / ((float)depth - 1.0f))) * (float)radius;
        }
        if (islandType == 2) {
            float jetDist = (float)depth / (float)Math.abs(delta.func_177956_o()) - 1.0f;
            return (double)distToCenterColumn <= (delta.func_177956_o() >= -1 ? (double)radius : (delta.func_177956_o() == -2 ? Math.min(Math.ceil((float)radius * 0.9f), (double)jetDist) : (delta.func_177956_o() == -3 ? Math.min(Math.ceil((float)radius * 0.8f), (double)jetDist) : (double)jetDist)));
        }
        if (islandType == 3) {
            if (delta.func_177956_o() >= -2) {
                return distToCenterColumn <= (float)radius;
            }
            if ((float)Math.abs(delta.func_177956_o()) <= (float)depth * 0.4f) {
                return distToOrigin <= (float)radius;
            }
            if (new Random((delta.func_177958_n() + delta.func_177952_p()) / (delta.func_177952_p() == 0 ? 1 : delta.func_177952_p())).nextInt(Math.abs(delta.func_177958_n() * delta.func_177952_p())) == 0) {
                return distToOrigin <= (float)radius;
            }
            return false;
        }
        return distToOrigin <= (float)radius;
    }

    private Block getSpecialOre() {
        switch (this.random.nextInt(8)) {
            case 0: {
                return Blocks.field_150482_ag;
            }
            case 1: {
                return Blocks.field_150352_o;
            }
            case 2: {
                return Blocks.field_150366_p;
            }
            case 3: {
                return Blocks.field_150369_x;
            }
            case 4: {
                return Blocks.field_150450_ax;
            }
            case 5: {
                return Blocks.field_150412_bA;
            }
            case 6: {
                return Blocks.field_150366_p;
            }
        }
        return Blocks.field_150365_q;
    }
}

