/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.floatingruins;

import bspkrs.floatingruins.FloatingRuins;
import bspkrs.util.CommonUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.fml.common.registry.GameData;

public class WorldGenFloatingIslandRuin
extends WorldGenerator {
    private final int numberOfItems = FloatingRuins.numberOfItems;
    private final String stringOfIds = FloatingRuins.stringOfIds;
    private final String spawnerDefault = FloatingRuins.spawnerDefault;
    private final String spawnerDesert = FloatingRuins.spawnerDesert;
    private final String spawnerForest = FloatingRuins.spawnerForest;
    private final String spawnerHills = FloatingRuins.spawnerHills;
    private final String spawnerPlains = FloatingRuins.spawnerPlains;
    private final String spawnerSwampland = FloatingRuins.spawnerSwampland;
    private final String spawnerTaiga = FloatingRuins.spawnerTaiga;
    private final String spawnerOcean = FloatingRuins.spawnerOcean;
    private final String spawnerRiver = FloatingRuins.spawnerOcean;
    private final String spawnerJungle = FloatingRuins.spawnerJungle;
    private final String spawnerIceBiomes = FloatingRuins.spawnerIceBiomes;
    private final String spawnerMushroom = FloatingRuins.spawnerMushroom;
    private final String spawnerNearLava = FloatingRuins.spawnerNearLava;
    private final boolean isLavaNearby;
    private static final String[] allowedCtgys;
    private static final ArrayList<AbstractMap.SimpleEntry<ItemStack, Integer>> helmWeights;
    private static final ArrayList<AbstractMap.SimpleEntry<ItemStack, Integer>> plateWeights;
    private static final ArrayList<AbstractMap.SimpleEntry<ItemStack, Integer>> leggingWeights;
    private static final ArrayList<AbstractMap.SimpleEntry<ItemStack, Integer>> bootWeights;
    private static final ArrayList<AbstractMap.SimpleEntry<ItemStack, Integer>> skelWeapWeights;
    private static final ArrayList<AbstractMap.SimpleEntry<ItemStack, Integer>> zombWeapWeights;

    public static ItemStack getWeightedItemStack(Random random, ArrayList<AbstractMap.SimpleEntry<ItemStack, Integer>> list) {
        int currentWeight = 0;
        for (AbstractMap.SimpleEntry<ItemStack, Integer> e : list) {
            currentWeight += e.getValue().intValue();
        }
        int selection = random.nextInt(currentWeight);
        for (AbstractMap.SimpleEntry<ItemStack, Integer> e : list) {
            if (selection < (currentWeight -= e.getValue().intValue())) continue;
            return e.getKey();
        }
        return list.get(0).getKey();
    }

    public WorldGenFloatingIslandRuin(boolean isLavaNearby) {
        this.isLavaNearby = isLavaNearby;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        this.setDungeon(world, random, pos);
        return true;
    }

    private void setDungeon(World world, Random random, BlockPos pos) {
        BiomeGenBase biomegenbase = world.func_72959_q().func_180631_a(pos);
        IBlockState dungeonBlock = this.getDungeonBlock(biomegenbase);
        if (dungeonBlock.equals(Blocks.field_150433_aE.func_176223_P())) {
            this.setIgloo(world, pos, 5, dungeonBlock);
        } else if (dungeonBlock.equals(Blocks.field_150322_A.func_176223_P())) {
            this.setPyramid(world, pos, 6, dungeonBlock);
        } else if (dungeonBlock.equals(Blocks.field_150419_aX.func_176223_P())) {
            CommonUtils.setHugeMushroom((World)world, (Random)random, (BlockPos)pos, (IBlockState)dungeonBlock);
        } else {
            this.setBox(world, random, pos, 4, 4, this.getDungeonBlock(biomegenbase));
        }
        this.setChest(world, random, pos);
        this.setSpawner(world, biomegenbase, pos.func_177981_b(2));
    }

    private void setChest(World world, Random random, BlockPos pos) {
        world.func_180501_a(pos, Blocks.field_150486_ae.func_176223_P(), 3);
        TileEntityChest tileentitychest = (TileEntityChest)world.func_175625_s(pos);
        this.addItems(tileentitychest, random);
        IBlockState blockingBlock = FloatingRuins.harderDungeons ? Blocks.field_150357_h.func_176223_P() : Blocks.field_150343_Z.func_176223_P();
        world.func_180501_a(pos.func_177978_c(), blockingBlock, 3);
        world.func_180501_a(pos.func_177968_d(), blockingBlock, 3);
        world.func_180501_a(pos.func_177974_f(), blockingBlock, 3);
        world.func_180501_a(pos.func_177976_e(), blockingBlock, 3);
        world.func_180501_a(pos.func_177977_b(), blockingBlock, 3);
        if (FloatingRuins.harderDungeons) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150343_Z.func_176223_P(), 3);
        } else {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150347_e.func_176223_P(), 3);
        }
    }

    private void setSpawner(World world, BiomeGenBase biomegenbase, BlockPos pos) {
        TileEntityMobSpawner tileEntityMobSpawner;
        world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 3);
        IBlockState block = Blocks.field_150343_Z.func_176223_P();
        world.func_180501_a(pos.func_177978_c(), block, 3);
        world.func_180501_a(pos.func_177968_d(), block, 3);
        world.func_180501_a(pos.func_177974_f(), block, 3);
        world.func_180501_a(pos.func_177976_e(), block, 3);
        world.func_180501_a(pos.func_177977_b(), block, 3);
        if (FloatingRuins.harderDungeons) {
            world.func_180501_a(pos.func_177977_b(), Blocks.field_150343_Z.func_176223_P(), 3);
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150343_Z.func_176223_P(), 3);
        }
        if ((tileEntityMobSpawner = (TileEntityMobSpawner)world.func_175625_s(pos)) != null) {
            String[] mobIDList = FloatingRuins.allowMultiMobSpawners ? this.getSpawnerMobList(world, biomegenbase) : new String[]{this.getSpawnerType(world, biomegenbase, pos)};
            if (mobIDList.length == 1 && mobIDList[0].trim().equalsIgnoreCase("Default")) {
                mobIDList = FloatingRuins.spawnerDefault.split(",");
            }
            for (int i = 0; i < mobIDList.length; ++i) {
                mobIDList[i] = mobIDList[i].trim();
            }
            NBTTagCompound spawnerNBT = new NBTTagCompound();
            tileEntityMobSpawner.func_145841_b(spawnerNBT);
            NBTTagList spawnPotentials = new NBTTagList();
            for (int i = 0; i < mobIDList.length; ++i) {
                NBTTagCompound properties = new NBTTagCompound();
                NBTTagCompound potentialSpawn = new NBTTagCompound();
                potentialSpawn.func_74768_a("Weight", world.field_73012_v.nextInt(4) + 1);
                String debug = "  +" + mobIDList[i] + " wt(" + potentialSpawn.func_74762_e("Weight") + ") ";
                if (mobIDList[i].equals("WitherSkeleton")) {
                    NBTTagList equipment = new NBTTagList();
                    debug = debug + "+E:" + this.applyEquipment(equipment, zombWeapWeights, world.field_73012_v, true, world.field_73012_v.nextBoolean());
                    properties.func_74782_a("Equipment", (NBTBase)equipment);
                    properties.func_74774_a("SkeletonType", (byte)1);
                    potentialSpawn.func_74782_a("Properties", (NBTBase)properties);
                    potentialSpawn.func_74778_a("Type", "Skeleton");
                    spawnerNBT.func_74778_a("EntityId", "Skeleton");
                    spawnerNBT.func_74782_a("SpawnData", (NBTBase)properties);
                } else if (mobIDList[i].equals("Wolf")) {
                    properties.func_74774_a("Angry", (byte)1);
                    potentialSpawn.func_74782_a("Properties", (NBTBase)properties);
                    potentialSpawn.func_74778_a("Type", mobIDList[i]);
                    spawnerNBT.func_74778_a("EntityId", mobIDList[i]);
                    spawnerNBT.func_74782_a("SpawnData", (NBTBase)properties);
                } else if (mobIDList[i].equals("ChargedCreeper")) {
                    properties.func_74774_a("powered", (byte)1);
                    potentialSpawn.func_74782_a("Properties", (NBTBase)properties);
                    potentialSpawn.func_74778_a("Type", "Creeper");
                    spawnerNBT.func_74778_a("EntityId", "Creeper");
                    spawnerNBT.func_74782_a("SpawnData", (NBTBase)properties);
                } else if (mobIDList[i].equals("PigZombie")) {
                    properties.func_74777_a("Anger", (short)(400 + world.field_73012_v.nextInt(400)));
                    NBTTagList equipment = new NBTTagList();
                    debug = debug + "+E:" + this.applyEquipment(equipment, zombWeapWeights, world.field_73012_v, true, false);
                    properties.func_74782_a("Equipment", (NBTBase)equipment);
                    potentialSpawn.func_74782_a("Properties", (NBTBase)properties);
                    potentialSpawn.func_74778_a("Type", mobIDList[i]);
                    spawnerNBT.func_74778_a("EntityId", mobIDList[i]);
                    spawnerNBT.func_74782_a("SpawnData", (NBTBase)properties);
                } else if (mobIDList[i].equals("Zombie")) {
                    boolean flag = world.field_73012_v.nextBoolean();
                    properties.func_74774_a("isVillager", (byte)(flag ? 1 : 0));
                    if (flag) {
                        properties.func_74768_a("ConversionTime", -1);
                        debug = debug + "+V ";
                    }
                    if (flag = world.field_73012_v.nextBoolean()) {
                        NBTTagList equipment = new NBTTagList();
                        debug = debug + "+E:" + this.applyEquipment(equipment, zombWeapWeights, world.field_73012_v, flag, world.field_73012_v.nextBoolean());
                        properties.func_74782_a("Equipment", (NBTBase)equipment);
                    }
                    potentialSpawn.func_74782_a("Properties", (NBTBase)properties);
                    potentialSpawn.func_74778_a("Type", mobIDList[i]);
                    spawnerNBT.func_74778_a("EntityId", mobIDList[i]);
                    spawnerNBT.func_74782_a("SpawnData", (NBTBase)properties);
                } else if (mobIDList[i].equals("Skeleton")) {
                    NBTTagList equipment = new NBTTagList();
                    debug = debug + "+E:" + this.applyEquipment(equipment, skelWeapWeights, world.field_73012_v, true, world.field_73012_v.nextBoolean());
                    properties.func_74782_a("Equipment", (NBTBase)equipment);
                    potentialSpawn.func_74782_a("Properties", (NBTBase)properties);
                    potentialSpawn.func_74778_a("Type", mobIDList[i]);
                    spawnerNBT.func_74778_a("EntityId", mobIDList[i]);
                    spawnerNBT.func_74782_a("SpawnData", (NBTBase)properties);
                } else {
                    potentialSpawn.func_74778_a("Type", mobIDList[i]);
                    spawnerNBT.func_74778_a("EntityId", mobIDList[i]);
                    spawnerNBT.func_74782_a("SpawnData", (NBTBase)properties);
                }
                spawnPotentials.func_74742_a((NBTBase)potentialSpawn);
                FloatingRuins.debug(debug, new Object[0]);
            }
            spawnerNBT.func_74782_a("SpawnPotentials", (NBTBase)spawnPotentials);
            if (FloatingRuins.harderDungeons) {
                spawnerNBT.func_74777_a("MinSpawnDelay", (short)80);
                spawnerNBT.func_74777_a("MaxSpawnDelay", (short)200);
                spawnerNBT.func_74777_a("SpawnCount", (short)6);
                spawnerNBT.func_74777_a("MaxNearbyEntities", (short)16);
                spawnerNBT.func_74777_a("SpawnRange", (short)7);
            }
            tileEntityMobSpawner.func_145839_a(spawnerNBT);
        }
    }

    private String applyEquipment(NBTTagList equipment, ArrayList<AbstractMap.SimpleEntry<ItemStack, Integer>> weaponList, Random random, boolean giveWeapon, boolean giveArmor) {
        String debug = "";
        NBTTagCompound Items = new NBTTagCompound();
        ItemStack equip = WorldGenFloatingIslandRuin.getWeightedItemStack(random, weaponList);
        if (giveWeapon && equip != null) {
            equip.func_77955_b(Items);
            debug = debug + equip.func_82833_r() + ";";
        }
        equipment.func_74742_a((NBTBase)Items);
        if (giveArmor) {
            Items = new NBTTagCompound();
            equip = WorldGenFloatingIslandRuin.getWeightedItemStack(random, bootWeights);
            if (equip != null) {
                equip.func_77955_b(Items);
                debug = debug + equip.func_82833_r() + ";";
            }
            equipment.func_74742_a((NBTBase)Items);
            Items = new NBTTagCompound();
            equip = WorldGenFloatingIslandRuin.getWeightedItemStack(random, leggingWeights);
            if (equip != null) {
                equip.func_77955_b(Items);
                debug = debug + equip.func_82833_r() + ";";
            }
            equipment.func_74742_a((NBTBase)Items);
            Items = new NBTTagCompound();
            equip = WorldGenFloatingIslandRuin.getWeightedItemStack(random, plateWeights);
            if (equip != null) {
                equip.func_77955_b(Items);
                debug = debug + equip.func_82833_r() + ";";
            }
            equipment.func_74742_a((NBTBase)Items);
            Items = new NBTTagCompound();
            equip = WorldGenFloatingIslandRuin.getWeightedItemStack(random, helmWeights);
            if (equip != null) {
                equip.func_77955_b(Items);
                debug = debug + equip.func_82833_r() + ";";
            }
            equipment.func_74742_a((NBTBase)Items);
        } else {
            for (int j = 0; j < 4; ++j) {
                Items = new NBTTagCompound();
                equipment.func_74742_a((NBTBase)Items);
            }
        }
        return debug;
    }

    private IBlockState getDungeonBlock(BiomeGenBase biomegenbase) {
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
            return Blocks.field_150344_f.func_176223_P();
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            return Blocks.field_150322_A.func_176223_P();
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            return Blocks.field_150433_aE.func_176223_P();
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            return Blocks.field_150347_e.func_176223_P();
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            return Blocks.field_150341_Y.func_176223_P();
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            return Blocks.field_150341_Y.func_176223_P();
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS)) {
            return Blocks.field_150348_b.func_176223_P();
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
            if (biomegenbase.getClass().getSimpleName().toLowerCase(Locale.US).contains("ocean")) {
                return Blocks.field_150417_aV.func_176223_P();
            }
            return Blocks.field_150344_f.func_176223_P();
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
            return Blocks.field_150419_aX.func_176223_P();
        }
        return Blocks.field_150336_V.func_176223_P();
    }

    private void addItems(TileEntityChest tileentitychest, Random random) {
        int limit = random.nextInt(4) + this.numberOfItems;
        int i = 0;
        do {
            if (FloatingRuins.useCustomItemList) {
                tileentitychest.func_70299_a(random.nextInt(tileentitychest.func_70302_i_()), this.getItems(random));
                continue;
            }
            tileentitychest.func_70299_a(random.nextInt(tileentitychest.func_70302_i_()), ChestGenHooks.getOneItem((String)allowedCtgys[random.nextInt(allowedCtgys.length)], (Random)random));
        } while (++i <= limit);
    }

    private ItemStack getItems(Random random) {
        Item item;
        String[] itemStack = this.stringOfIds.split(";")[random.nextInt(this.stringOfIds.split(";").length)].split(",");
        String id = GameData.getItemRegistry().func_177774_c((Object)Items.field_151110_aK).toString();
        int size = 1;
        int meta = 0;
        if (itemStack.length > 0) {
            id = itemStack[0].trim();
        }
        if (itemStack.length > 1) {
            size = CommonUtils.parseInt((String)itemStack[1].trim());
        }
        if (itemStack.length > 2) {
            meta = CommonUtils.parseInt((String)itemStack[2].trim());
        }
        if ((item = (Item)GameData.getItemRegistry().func_82594_a((Object)id)) == null) {
            item = Items.field_151110_aK;
        }
        if (!item.func_77614_k() && meta != 0) {
            meta = 0;
        }
        return new ItemStack(item, size, meta);
    }

    public String getSpawnerType(World world, BiomeGenBase biomegenbase, BlockPos pos) {
        if (this.isLavaNearby) {
            return this.getMobString(this.spawnerNearLava, world, pos);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
            return this.getMobString(this.spawnerPlains, world, pos);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            return this.getMobString(this.spawnerDesert, world, pos);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            return this.getMobString(this.spawnerTaiga, world, pos);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            return this.getMobString(this.spawnerIceBiomes, world, pos);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            return this.getMobString(this.spawnerForest, world, pos);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            return this.getMobString(this.spawnerJungle, world, pos);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            return this.getMobString(this.spawnerSwampland, world, pos);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS)) {
            return this.getMobString(this.spawnerHills, world, pos);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
            if (biomegenbase.getClass().getSimpleName().toLowerCase(Locale.US).contains("ocean")) {
                return this.getMobString(this.spawnerOcean, world, pos);
            }
            return this.getMobString(this.spawnerRiver, world, pos);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
            return this.getMobString(this.spawnerMushroom, world, pos);
        }
        return this.getMobString(this.spawnerDefault, world, pos);
    }

    public String[] getSpawnerMobList(World world, BiomeGenBase biomegenbase) {
        if (this.isLavaNearby) {
            return this.spawnerNearLava.split(",");
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
            return this.spawnerPlains.split(",");
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            return this.spawnerDesert.split(",");
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            return this.spawnerTaiga.split(",");
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            return this.spawnerIceBiomes.split(",");
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            return this.spawnerForest.split(",");
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            return this.spawnerJungle.split(",");
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            return this.spawnerSwampland.split(",");
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS)) {
            return this.spawnerHills.split(",");
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
            if (biomegenbase.getClass().getSimpleName().toLowerCase(Locale.US).contains("ocean")) {
                return this.spawnerOcean.split(",");
            }
            return this.spawnerRiver.split(",");
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
            return this.spawnerMushroom.split(",");
        }
        return this.spawnerDefault.split(",");
    }

    private String getMobString(String s, World world, BlockPos pos) {
        Random random = new Random();
        if (s.equalsIgnoreCase("default")) {
            return this.getMobString(this.spawnerDefault, world, pos);
        }
        String mob = s.split(",")[random.nextInt(s.split(",").length)].trim();
        if (mob.equalsIgnoreCase("slime")) {
            EntitySlime slime = new EntitySlime(world);
            slime.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            if (!new EntitySlime(world).func_70601_bi()) {
                return this.getMobString(this.spawnerDefault, world, pos);
            }
        }
        return mob;
    }

    public void setBox(World world, Random random, BlockPos pos, int width, int height, IBlockState block) {
        for (int x = -width; x <= width; ++x) {
            for (int y = height; y >= -height; --y) {
                for (int z = -width; z <= width; ++z) {
                    BlockPos delta = pos.func_177971_a((Vec3i)new BlockPos(x, y, z));
                    if (y == height || Math.abs(x) == width && Math.abs(z) == width && y >= 0) {
                        world.func_180501_a(delta, Blocks.field_150417_aV.func_176223_P(), 3);
                        world.func_180501_a(delta.func_177984_a(), FloatingRuins.harderDungeons ? Blocks.field_150357_h.func_176223_P() : Blocks.field_150417_aV.func_176223_P(), 3);
                    }
                    if (y >= 1 && Math.abs(x) == width ^ Math.abs(z) == width) {
                        world.func_180501_a(delta, block, 3);
                    }
                    if (y > 0 && y < height && Math.abs(z) < width && Math.abs(x) < width) {
                        world.func_175698_g(delta);
                    }
                    if (y == -1 || y == 0) {
                        world.func_180501_a(delta, Blocks.field_150417_aV.func_176223_P(), 3);
                    }
                    if (y >= -1) continue;
                    int yg = CommonUtils.getHighestGroundBlock((World)world, (BlockPos)delta);
                    if (Math.abs(x) != width && Math.abs(z) != width || world.func_175677_d(delta, false) || yg >= y + pos.func_177956_o() || yg < pos.func_177956_o() - height) continue;
                    world.func_180501_a(delta, Blocks.field_150417_aV.func_176223_P(), 3);
                }
            }
        }
    }

    private void setIgloo(World world, BlockPos pos, int range, IBlockState block) {
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    int dist = (int)Math.round(Math.sqrt(CommonUtils.sqr((int)x) + CommonUtils.sqr((int)y) + CommonUtils.sqr((int)z)));
                    if (dist > range) continue;
                    BlockPos delta = pos.func_177971_a((Vec3i)new BlockPos(x, y, z));
                    if (y >= 0) {
                        if (dist == range) {
                            world.func_180501_a(delta, FloatingRuins.harderDungeons && y > 2 ? Blocks.field_150357_h.func_176223_P() : block, 3);
                        }
                        if (y == 0 && dist < range) {
                            world.func_180501_a(delta, Blocks.field_150349_c.func_176223_P(), 3);
                        }
                        if (y <= 0 || dist >= range) continue;
                        world.func_175698_g(delta);
                        if (y != 1) continue;
                        world.func_180501_a(delta, Blocks.field_150431_aC.func_176223_P(), 3);
                        continue;
                    }
                    if (y == -1) {
                        world.func_180501_a(delta, block, 3);
                    }
                    int yg = CommonUtils.getHighestGroundBlock((World)world, (BlockPos)delta);
                    if (dist != range || world.func_175677_d(delta, false) || yg >= y + pos.func_177956_o() || yg < pos.func_177956_o() - range) continue;
                    world.func_180501_a(delta, block, 3);
                }
            }
        }
    }

    private void setPyramid(World world, BlockPos pos, int range, IBlockState block) {
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos delta = pos.func_177971_a((Vec3i)new BlockPos(x, y, z));
                    if (y >= 0) {
                        if (Math.abs(x) == range - y && Math.abs(x) >= Math.abs(z) || Math.abs(z) == range - y && Math.abs(z) >= Math.abs(x) || y == 0) {
                            world.func_180501_a(delta, FloatingRuins.harderDungeons && y > 2 ? Blocks.field_150357_h.func_176223_P() : block, 3);
                            continue;
                        }
                        if ((Math.abs(x) >= range - y || Math.abs(x) < Math.abs(z)) && (Math.abs(z) >= range - y || Math.abs(z) < Math.abs(x))) continue;
                        world.func_175698_g(delta);
                        continue;
                    }
                    if (y == -1) {
                        world.func_180501_a(delta, block, 3);
                    }
                    int yg = CommonUtils.getHighestGroundBlock((World)world, (BlockPos)delta);
                    if (Math.abs(x) != range && Math.abs(z) != range || world.func_175677_d(delta, false) || yg >= y + pos.func_177956_o() || yg < pos.func_177956_o() - range) continue;
                    world.func_180501_a(delta, block, 3);
                }
            }
        }
    }

    static {
        helmWeights = new ArrayList();
        plateWeights = new ArrayList();
        leggingWeights = new ArrayList();
        bootWeights = new ArrayList();
        skelWeapWeights = new ArrayList();
        zombWeapWeights = new ArrayList();
        helmWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151024_Q, 1, 0), 3));
        helmWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151028_Y, 1, 0), 7));
        helmWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151020_U, 1, 0), 9));
        helmWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151169_ag, 1, 0), 12));
        helmWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151161_ac, 1, 0), 16));
        plateWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151027_R, 1, 0), 3));
        plateWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151030_Z, 1, 0), 7));
        plateWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151023_V, 1, 0), 9));
        plateWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151171_ah, 1, 0), 12));
        plateWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151163_ad, 1, 0), 16));
        leggingWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151026_S, 1, 0), 3));
        leggingWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151165_aa, 1, 0), 7));
        leggingWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151022_W, 1, 0), 9));
        leggingWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151149_ai, 1, 0), 12));
        leggingWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151173_ae, 1, 0), 16));
        bootWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151021_T, 1, 0), 3));
        bootWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151167_ab, 1, 0), 7));
        bootWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151029_X, 1, 0), 9));
        bootWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151151_aj, 1, 0), 12));
        bootWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151175_af, 1, 0), 16));
        skelWeapWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack((Item)Items.field_151031_f, 1, 0), 46));
        skelWeapWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack(Items.field_151040_l, 1, 0), 11));
        skelWeapWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack(Items.field_151048_u, 1, 0), 2));
        skelWeapWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack(Items.field_151010_B, 1, 0), 5));
        zombWeapWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack(Items.field_151052_q, 1, 0), 10));
        zombWeapWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack(Items.field_151048_u, 1, 0), 4));
        zombWeapWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack(Items.field_151010_B, 1, 0), 10));
        zombWeapWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack(Items.field_151041_m, 1, 0), 5));
        zombWeapWeights.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(new ItemStack(Items.field_151040_l, 1, 0), 11));
        allowedCtgys = new String[]{"dungeonChest", "mineshaftCorridor", "pyramidDesertyChest", "pyramidJungleChest", "strongholdLibrary", "villageBlacksmith"};
    }
}

