/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.bezier;

import ivorius.ivtoolkit.bezier.IvBezierPath3D;
import ivorius.ivtoolkit.bezier.IvBezierPoint3DCachedStep;
import ivorius.ivtoolkit.math.IvMathHelper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class IvBezierPath3DRendererTexture {
    private double lineWidth = 1.0;
    private double stepSize = 0.1;
    private double textureShift;

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(double stepSize) {
        this.stepSize = stepSize;
    }

    public double getTextureShift() {
        return this.textureShift;
    }

    public void setTextureShift(double textureShift) {
        this.textureShift = textureShift;
    }

    public void render(IvBezierPath3D path) {
        if (path.isDirty()) {
            path.buildDistances();
        }
        WorldRenderer renderer = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179147_l();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        for (double progress = 0.0; progress < 1.0 + this.stepSize; progress += this.stepSize) {
            boolean isVeryFirst = progress == 0.0;
            boolean isVeryLast = progress >= 1.0;
            double totalProgress = Math.min(progress, 1.0);
            IvBezierPoint3DCachedStep cachedStep = path.getCachedStep(totalProgress);
            double[] position = cachedStep.getPosition();
            double[] pVector = path.getPVector(cachedStep, this.stepSize);
            double red = IvMathHelper.mix(cachedStep.getLeftPoint().getRed(), cachedStep.getRightPoint().getRed(), cachedStep.getInnerProgress());
            double green = IvMathHelper.mix(cachedStep.getLeftPoint().getGreen(), cachedStep.getRightPoint().getGreen(), cachedStep.getInnerProgress());
            double blue = IvMathHelper.mix(cachedStep.getLeftPoint().getBlue(), cachedStep.getRightPoint().getBlue(), cachedStep.getInnerProgress());
            double alpha = IvMathHelper.mix(cachedStep.getLeftPoint().getAlpha(), cachedStep.getRightPoint().getAlpha(), cachedStep.getInnerProgress());
            double textureX = totalProgress + this.textureShift;
            if (!isVeryFirst) {
                renderer.func_181666_a((float)red, (float)green, (float)blue, (float)alpha);
                renderer.func_181662_b(position[0] - pVector[0] * this.lineWidth, position[1] - pVector[1] * this.lineWidth, position[2] - pVector[2] * this.lineWidth).func_181673_a(textureX, 0.0).func_181675_d();
                renderer.func_181662_b(position[0] + pVector[0] * this.lineWidth, position[1] + pVector[1] * this.lineWidth, position[2] + pVector[2] * this.lineWidth).func_181673_a(textureX, 1.0).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
            }
            if (isVeryLast) continue;
            renderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            renderer.func_181666_a((float)red, (float)green, (float)blue, (float)alpha);
            renderer.func_181662_b(position[0] + pVector[0] * this.lineWidth, position[1] + pVector[1] * this.lineWidth, position[2] + pVector[2] * this.lineWidth).func_181673_a(textureX, 1.0).func_181675_d();
            renderer.func_181662_b(position[0] - pVector[0] * this.lineWidth, position[1] - pVector[1] * this.lineWidth, position[2] - pVector[2] * this.lineWidth).func_181673_a(textureX, 0.0).func_181675_d();
        }
        GlStateManager.func_179084_k();
    }
}

