/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.blocks;

import com.google.common.collect.ImmutableSet;
import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.IvBlockMapper;
import ivorius.ivtoolkit.raytracing.IvRaytraceableAxisAlignedBox;
import ivorius.ivtoolkit.raytracing.IvRaytracedIntersection;
import ivorius.ivtoolkit.raytracing.IvRaytracer;
import ivorius.ivtoolkit.tools.MCRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class IvBlockCollection {
    public final int width;
    public final int height;
    public final int length;
    private final IBlockState[] blockStates;

    public IvBlockCollection(int width, int height, int length) {
        this(IvBlockCollection.airArray(width, height, length), width, height, length);
    }

    public IvBlockCollection(IBlockState[] blockStates, int width, int height, int length) {
        this.blockStates = blockStates;
        this.width = width;
        this.height = height;
        this.length = length;
    }

    public IvBlockCollection(NBTTagCompound compound, MCRegistry registry) {
        this.width = compound.func_74762_e("width");
        this.height = compound.func_74762_e("height");
        this.length = compound.func_74762_e("length");
        IvBlockMapper mapper = new IvBlockMapper(compound, "mapping", registry);
        Block[] blocks = mapper.createBlocksFromNBT(compound.func_74775_l("blocks"));
        byte[] metas = compound.func_74770_j("metadata");
        if (blocks.length != this.width * this.height * this.length) {
            throw new RuntimeException("Block collection length is " + blocks.length + " but should be " + this.width + " * " + this.height + " * " + this.length);
        }
        if (metas.length != this.width * this.height * this.length) {
            throw new RuntimeException("Block collection length is " + metas.length + " but should be " + this.width + " * " + this.height + " * " + this.length);
        }
        this.blockStates = new IBlockState[this.width * this.height * this.length];
        for (int i = 0; i < this.blockStates.length; ++i) {
            this.blockStates[i] = blocks[i].func_176203_a((int)metas[i]);
        }
    }

    private static IBlockState[] airArray(int width, int height, int length) {
        Object[] blocks = new IBlockState[width * height * length];
        Arrays.fill(blocks, Blocks.field_150350_a.func_176223_P());
        return blocks;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLength() {
        return this.length;
    }

    public IBlockState getBlockState(BlockPos coord) {
        if (!this.hasCoord(coord)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        IBlockState block = this.blockStates[this.indexFromCoord(coord)];
        return block != null ? block : Blocks.field_150350_a.func_176223_P();
    }

    public void setBlockState(BlockPos coord, IBlockState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        if (!this.hasCoord(coord)) {
            return;
        }
        int index = this.indexFromCoord(coord);
        this.blockStates[index] = state;
    }

    private int indexFromCoord(BlockPos coord) {
        return (coord.func_177952_p() * this.height + coord.func_177956_o()) * this.width + coord.func_177958_n();
    }

    public boolean hasCoord(BlockPos coord) {
        return coord.func_177958_n() >= 0 && coord.func_177958_n() < this.width && coord.func_177956_o() >= 0 && coord.func_177956_o() < this.height && coord.func_177952_p() >= 0 && coord.func_177952_p() < this.length;
    }

    public boolean shouldRenderSide(BlockPos coord, EnumFacing side) {
        BlockPos sideCoord = coord.func_177982_a(side.func_82601_c(), side.func_96559_d(), side.func_82599_e());
        IBlockState block = this.getBlockState(sideCoord);
        return !block.func_177230_c().func_149662_c();
    }

    public MovingObjectPosition rayTrace(Vec3 position, Vec3 direction) {
        IvRaytraceableAxisAlignedBox containingBox = new IvRaytraceableAxisAlignedBox(null, 0.001, 0.001, 0.001, (double)this.width - 0.002, (double)this.height - 0.002, (double)this.length - 0.002);
        IvRaytracedIntersection intersection = IvRaytracer.getFirstIntersection(Collections.singletonList(containingBox), position.field_72450_a, position.field_72448_b, position.field_72449_c, direction.field_72450_a, direction.field_72448_b, direction.field_72449_c);
        if (intersection != null) {
            position = new Vec3(intersection.getX(), intersection.getY(), intersection.getZ());
            BlockPos curCoord = new BlockPos(MathHelper.func_76128_c((double)position.field_72450_a), MathHelper.func_76128_c((double)position.field_72448_b), MathHelper.func_76128_c((double)position.field_72449_c));
            EnumFacing hitSide = ((EnumFacing)intersection.getHitInfo()).func_176734_d();
            while (this.hasCoord(curCoord)) {
                double dirLength;
                if (this.getBlockState(curCoord).func_177230_c().func_149688_o() != Material.field_151579_a) {
                    return new MovingObjectPosition(position, hitSide.func_176734_d(), new BlockPos(curCoord.func_177958_n(), curCoord.func_177956_o(), curCoord.func_177952_p()));
                }
                hitSide = this.getExitSide(position, direction);
                if (hitSide.func_82601_c() != 0) {
                    double offX = hitSide.func_82601_c() > 0 ? 1.0001 : -1.0E-4;
                    dirLength = ((double)curCoord.func_177958_n() + offX - position.field_72450_a) / direction.field_72450_a;
                    position = new Vec3((double)curCoord.func_177958_n() + offX, position.field_72448_b + direction.field_72448_b * dirLength, position.field_72449_c + direction.field_72449_c * dirLength);
                } else if (hitSide.func_96559_d() != 0) {
                    double offY = hitSide.func_96559_d() > 0 ? 1.0001 : -1.0E-4;
                    dirLength = ((double)curCoord.func_177956_o() + offY - position.field_72448_b) / direction.field_72448_b;
                    position = new Vec3(position.field_72450_a + direction.field_72450_a * dirLength, (double)curCoord.func_177956_o() + offY, position.field_72449_c + direction.field_72449_c * dirLength);
                } else {
                    double offZ = hitSide.func_82599_e() > 0 ? 1.0001 : -1.0E-4;
                    dirLength = ((double)curCoord.func_177952_p() + offZ - position.field_72449_c) / direction.field_72449_c;
                    position = new Vec3(position.field_72450_a + direction.field_72450_a * dirLength, position.field_72448_b + direction.field_72448_b * dirLength, (double)curCoord.func_177952_p() + offZ);
                }
                curCoord = curCoord.func_177982_a(hitSide.func_82601_c(), hitSide.func_96559_d(), hitSide.func_82599_e());
            }
        }
        return null;
    }

    private EnumFacing getExitSide(Vec3 position, Vec3 direction) {
        double zDist;
        double innerX = (position.field_72450_a % 1.0 + 1.0) % 1.0;
        double innerY = (position.field_72448_b % 1.0 + 1.0) % 1.0;
        double innerZ = (position.field_72449_c % 1.0 + 1.0) % 1.0;
        double xDist = direction.field_72450_a > 0.0 ? (1.0 - innerX) / direction.field_72450_a : innerX / -direction.field_72450_a;
        double yDist = direction.field_72448_b > 0.0 ? (1.0 - innerY) / direction.field_72448_b : innerY / -direction.field_72448_b;
        double d = zDist = direction.field_72449_c > 0.0 ? (1.0 - innerZ) / direction.field_72449_c : innerZ / -direction.field_72449_c;
        if (xDist < yDist && xDist < zDist) {
            return direction.field_72450_a > 0.0 ? EnumFacing.EAST : EnumFacing.WEST;
        }
        if (yDist < zDist) {
            return direction.field_72448_b > 0.0 ? EnumFacing.UP : EnumFacing.DOWN;
        }
        return direction.field_72449_c > 0.0 ? EnumFacing.SOUTH : EnumFacing.NORTH;
    }

    public int getBlockMultiplicity() {
        return new ImmutableSet.Builder().addAll(Arrays.asList(this.blockStates)).build().size();
    }

    public NBTTagCompound createTagCompound() {
        NBTTagCompound compound = new NBTTagCompound();
        IvBlockMapper mapper = new IvBlockMapper();
        compound.func_74768_a("width", this.width);
        compound.func_74768_a("height", this.height);
        compound.func_74768_a("length", this.length);
        byte[] metas = new byte[this.blockStates.length];
        for (int i = 0; i < metas.length; ++i) {
            metas[i] = (byte)this.blockStates[i].func_177230_c().func_176201_c(this.blockStates[i]);
        }
        compound.func_74773_a("metadata", metas);
        List<Block> blockList = Stream.of(this.blockStates).map(IBlockState::func_177230_c).collect(Collectors.toList());
        mapper.addMapping(blockList);
        compound.func_74782_a("mapping", (NBTBase)mapper.createTagList());
        compound.func_74782_a("blocks", (NBTBase)mapper.createNBTForBlocks(blockList));
        return compound;
    }

    public String toString() {
        return "IvBlockCollection{length=" + this.length + ", height=" + this.height + ", width=" + this.width + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IvBlockCollection that = (IvBlockCollection)o;
        if (this.height != that.height) {
            return false;
        }
        if (this.length != that.length) {
            return false;
        }
        if (this.width != that.width) {
            return false;
        }
        return Arrays.equals(this.blockStates, that.blockStates);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.blockStates);
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.length;
        return result;
    }

    public BlockArea area() {
        return new BlockArea(BlockPos.field_177992_a, new BlockPos(this.width - 1, this.height - 1, this.length - 1));
    }
}

