/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.blocks;

import ivorius.ivtoolkit.blocks.IvTileEntityMultiBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class IvBlockMultiblock
extends Block {
    protected IvBlockMultiblock(Material par2Material) {
        super(par2Material);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IvTileEntityMultiBlock) {
            IvTileEntityMultiBlock tileEntityMultiBlock = (IvTileEntityMultiBlock)tileEntity;
            if (!tileEntityMultiBlock.multiblockInvalid) {
                tileEntityMultiBlock.multiblockInvalid = true;
                if (tileEntityMultiBlock.isParent()) {
                    this.destroyChildrenOf(world, pos, state, tileEntityMultiBlock);
                } else {
                    this.destroyParentOf(tileEntityMultiBlock);
                }
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public void destroyChildrenOf(World world, BlockPos pos, IBlockState state, IvTileEntityMultiBlock tileEntityMultiBlock) {
        if (!world.field_72995_K) {
            this.parentBlockDropItemContents(world, tileEntityMultiBlock, pos, state);
        }
        BlockPos[] toDestroy = tileEntityMultiBlock.getActiveChildCoords();
        TileEntity[] destroyTEs = new TileEntity[toDestroy.length];
        for (int i = 0; i < toDestroy.length; ++i) {
            TileEntity otherTE = world.func_175625_s(toDestroy[i]);
            if (!(otherTE instanceof IvTileEntityMultiBlock) || ((IvTileEntityMultiBlock)otherTE).multiblockInvalid) continue;
            destroyTEs[i] = otherTE;
            ((IvTileEntityMultiBlock)otherTE).multiblockInvalid = true;
        }
        for (TileEntity destroyTE : destroyTEs) {
            if (destroyTE == null) continue;
            this.triggerBlockDestroyEffects(world, destroyTE.func_174877_v());
            world.func_175698_g(destroyTE.func_174877_v());
        }
    }

    protected void triggerBlockDestroyEffects(World world, BlockPos pos) {
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)world.func_180495_p(pos)));
    }

    public void destroyParentOf(IvTileEntityMultiBlock tileEntityMultiBlock) {
        World world = tileEntityMultiBlock.func_145831_w();
        TileEntity parentTE = world.func_175625_s(tileEntityMultiBlock.getActiveParentCoords());
        if (parentTE instanceof IvTileEntityMultiBlock && !((IvTileEntityMultiBlock)parentTE).multiblockInvalid) {
            this.triggerBlockDestroyEffects(world, parentTE.func_174877_v());
            world.func_175698_g(parentTE.func_174877_v());
        }
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        IvTileEntityMultiBlock tileEntityMultiBlock = IvBlockMultiblock.getValidatedTotalParent(this, (IBlockAccess)world, pos);
        if (tileEntityMultiBlock != null && !world.field_72995_K && willHarvest) {
            this.parentBlockHarvestItem(world, tileEntityMultiBlock, pos, world.func_180495_p(pos));
        }
        return super.removedByPlayer(world, pos, player, willHarvest);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        IvTileEntityMultiBlock tileEntityMultiBlock = IvBlockMultiblock.getValidatedTotalParent(this, (IBlockAccess)world, pos);
        if (tileEntityMultiBlock != null && !world.field_72995_K) {
            this.parentBlockHarvestItem(world, tileEntityMultiBlock, pos, world.func_180495_p(pos));
        }
        super.onBlockExploded(world, pos, explosion);
    }

    public void parentBlockDropItemContents(World world, IvTileEntityMultiBlock tileEntity, BlockPos pos, IBlockState state) {
    }

    public void parentBlockHarvestItem(World world, IvTileEntityMultiBlock tileEntity, BlockPos pos, IBlockState state) {
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(worldIn, pos, state, chance, fortune);
    }

    public static boolean validateMultiblock(Block block, IBlockAccess access, BlockPos pos) {
        if (access.func_180495_p(pos) != block) {
            return false;
        }
        boolean isValidChild = false;
        boolean destroy = false;
        TileEntity tileEntity = access.func_175625_s(pos);
        if (tileEntity instanceof IvTileEntityMultiBlock) {
            IvTileEntityMultiBlock tileEntityMultiBlock = (IvTileEntityMultiBlock)tileEntity;
            IvTileEntityMultiBlock parent = tileEntityMultiBlock.getParent();
            isValidChild = tileEntityMultiBlock.isParent() || parent != null && parent.isParent();
            boolean bl = destroy = !isValidChild && !tileEntityMultiBlock.multiblockInvalid;
        }
        if (destroy && access instanceof World) {
            ((World)access).func_175698_g(pos);
        }
        return isValidChild;
    }

    public static IvTileEntityMultiBlock getValidatedIfParent(Block block, World world, BlockPos pos) {
        if (IvBlockMultiblock.validateMultiblock(block, (IBlockAccess)world, pos)) {
            IvTileEntityMultiBlock tileEntity = (IvTileEntityMultiBlock)world.func_175625_s(pos);
            return tileEntity.isParent() ? tileEntity : null;
        }
        return null;
    }

    public static IvTileEntityMultiBlock getValidatedTotalParent(Block block, IBlockAccess access, BlockPos pos) {
        TileEntity tileEntity;
        if (IvBlockMultiblock.validateMultiblock(block, access, pos) && (tileEntity = access.func_175625_s(pos)) instanceof IvTileEntityMultiBlock) {
            return ((IvTileEntityMultiBlock)tileEntity).getTotalParent();
        }
        return null;
    }
}

