/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.math;

import net.minecraft.util.MathHelper;

public class IvBytePacker {
    public static byte getRequiredBitLength(int maxValue) {
        byte bits = 0;
        while (maxValue > 0) {
            maxValue >>>= 1;
            bits = (byte)(bits + 1);
        }
        return bits;
    }

    public static byte[] packValues(int[] values, byte bitLength) {
        byte[] packed = new byte[MathHelper.func_76123_f((float)((float)(values.length * bitLength) / 8.0f))];
        int currentArrayIndex = 0;
        long currentVal = 0L;
        int currentSavedBits = 0;
        for (int value : values) {
            currentVal = currentVal << bitLength | (long)value;
            currentSavedBits = (byte)(currentSavedBits + bitLength);
            while (currentSavedBits >= 8) {
                packed[currentArrayIndex] = (byte)(currentVal >>> currentSavedBits - 8);
                currentSavedBits = (byte)(currentSavedBits - 8);
                currentVal = IvBytePacker.deleteLeftBits(currentVal, 64 - currentSavedBits);
                ++currentArrayIndex;
            }
        }
        if (currentSavedBits > 0) {
            packed[currentArrayIndex] = (byte)(currentVal << 8 - currentSavedBits);
        }
        return packed;
    }

    public static int[] unpackValues(byte[] packed, byte bitLength, int valueCount) {
        int[] values = new int[valueCount];
        int currentArrayIndex = 0;
        long currentVal = 0L;
        byte currentSavedBits = 0;
        for (byte value : packed) {
            currentVal = currentVal << 8 | IvBytePacker.moveMSBToBytePos(value);
            currentSavedBits = (byte)(currentSavedBits + 8);
            while (currentSavedBits >= bitLength && currentArrayIndex < valueCount) {
                values[currentArrayIndex] = (int)(currentVal >>> currentSavedBits - bitLength);
                currentSavedBits = (byte)(currentSavedBits - bitLength);
                currentVal = IvBytePacker.deleteLeftBits(currentVal, 64 - currentSavedBits);
                ++currentArrayIndex;
            }
        }
        return values;
    }

    private static long moveMSBToBytePos(long value) {
        return value >>> 56 & 0x80L | value & 0x7FL;
    }

    private static long deleteLeftBits(long val, int bits) {
        return bits >= 64 ? 0L : val << bits >>> bits;
    }
}

