/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze.components;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import ivorius.ivtoolkit.IvToolkitCoreContainer;
import ivorius.ivtoolkit.maze.components.ConnectionStrategy;
import ivorius.ivtoolkit.maze.components.MazeComponents;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazePredicate;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.MorphingMazeComponent;
import ivorius.ivtoolkit.maze.components.ShiftedMazeComponent;
import ivorius.ivtoolkit.maze.components.WeightedMazeComponent;
import ivorius.ivtoolkit.random.WeightedShuffler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;

public class MazeComponentConnector {
    public static int INFINITE_REVERSES = -1;

    public static <M extends WeightedMazeComponent<C>, C> List<ShiftedMazeComponent<M, C>> randomlyConnect(MorphingMazeComponent<C> maze, List<M> components, ConnectionStrategy<C> connectionStrategy, MazePredicate<M, C> predicate, Random random, int reverses) {
        ArrayList<ReverseInfo> placeOrder = new ArrayList<ReverseInfo>();
        ReverseInfo reversing = null;
        ArrayList<ShiftedMazeComponent> result = new ArrayList<ShiftedMazeComponent>();
        Object exitStack = new ArrayDeque<Triple<MazeRoom, MazePassage, C>>();
        Predicate<ShiftedMazeComponent> componentPredicate = MazeComponents.compatibilityPredicate(maze, connectionStrategy).and(input -> predicate.canPlace(maze, input));
        MazeComponentConnector.addAllExits(predicate, exitStack, maze.exits().entrySet());
        while (((ArrayDeque)exitStack).size() > 0) {
            if (reversing == null) {
                if (maze.rooms().contains(((ArrayDeque)exitStack).peekLast().getLeft())) {
                    ((ArrayDeque)exitStack).removeLast();
                    continue;
                }
                reversing = new ReverseInfo();
                reversing.exitStack = ((ArrayDeque)exitStack).clone();
                reversing.maze = maze.copy();
                reversing.shuffleSeed = random.nextLong();
            } else {
                predicate.willUnplace(maze, reversing.placed);
                exitStack = reversing.exitStack.clone();
                maze.set(reversing.maze);
                predicate.didUnplace(maze, reversing.placed);
                result.remove(result.size() - 1);
            }
            Triple triple = (Triple)((ArrayDeque)exitStack).removeLast();
            MazeRoom room = (MazeRoom)triple.getLeft();
            MazePassage exit = (MazePassage)((Object)triple.getMiddle());
            Object connection = triple.getRight();
            ArrayList shuffled = Lists.newArrayList((Iterable)components.stream().flatMap(MazeComponents.shiftAllFunction(exit, connection, connectionStrategy)).collect(Collectors.toList()));
            WeightedShuffler.shuffle(new Random(reversing.shuffleSeed), shuffled, shifted -> ((WeightedMazeComponent)shifted.getComponent()).getWeight() * (double)MazeComponents.connectWeight(maze, shifted, connectionStrategy));
            if (reversing.triedIndices > shuffled.size()) {
                throw new RuntimeException("Maze component selection not static.");
            }
            ShiftedMazeComponent placing = null;
            while (!(placing != null && componentPredicate.test(placing) || reversing.triedIndices >= shuffled.size())) {
                placing = (ShiftedMazeComponent)shuffled.get(reversing.triedIndices++);
            }
            if (reversing.triedIndices >= shuffled.size()) {
                placing = null;
            }
            if (placing == null) {
                if (reverses == 0) {
                    IvToolkitCoreContainer.logger.warn("Did not find fitting component for maze!");
                    IvToolkitCoreContainer.logger.warn("Suggested: X with exits " + maze.exits().entrySet().stream().filter(MazeComponentConnector.entryConnectsTo(room)).collect(Collectors.toList()));
                    reversing = null;
                    continue;
                }
                if (reverses > 0) {
                    --reverses;
                }
                if (placeOrder.size() == 0) {
                    IvToolkitCoreContainer.logger.warn("Maze is not completable!");
                    IvToolkitCoreContainer.logger.warn("Switching to flawed mode.");
                    reverses = 0;
                    reversing = null;
                    continue;
                }
                reversing = (ReverseInfo)placeOrder.remove(placeOrder.size() - 1);
                continue;
            }
            reversing.placed = placing;
            predicate.willPlace(maze, placing);
            MazeComponentConnector.addAllExits(predicate, exitStack, placing.exits().entrySet());
            maze.add(placing);
            result.add(placing);
            predicate.didPlace(maze, placing);
            placeOrder.add(reversing);
            reversing = null;
        }
        return ImmutableList.builder().addAll(result).build();
    }

    private static Predicate<Map.Entry<MazePassage, ?>> entryConnectsTo(MazeRoom finalRoom) {
        return input -> input != null && ((MazePassage)((Object)((Object)input.getKey()))).has(finalRoom);
    }

    private static <M extends WeightedMazeComponent<C>, C> void addAllExits(MazePredicate<M, C> placementStrategy, Deque<Triple<MazeRoom, MazePassage, C>> exitStack, Set<Map.Entry<MazePassage, C>> entries) {
        for (Map.Entry<MazePassage, C> exit : entries) {
            MazePassage connection = exit.getKey();
            C c = exit.getValue();
            if (placementStrategy.isDirtyConnection(connection.getLeft(), connection.getRight(), c)) {
                exitStack.add(Triple.of((Object)connection.getLeft(), (Object)((Object)connection), c));
            }
            if (!placementStrategy.isDirtyConnection(connection.getRight(), connection.getLeft(), c)) continue;
            exitStack.add(Triple.of((Object)connection.getRight(), (Object)((Object)connection), c));
        }
    }

    private static class ReverseInfo<M extends WeightedMazeComponent<C>, C> {
        public long shuffleSeed;
        public int triedIndices;
        public MorphingMazeComponent<C> maze;
        public ArrayDeque<Triple<MazeRoom, MazePassage, C>> exitStack;
        public ShiftedMazeComponent<M, C> placed;

        private ReverseInfo() {
        }
    }
}

