/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze.components;

import com.google.common.collect.Sets;
import ivorius.ivtoolkit.maze.components.ConnectionStrategy;
import ivorius.ivtoolkit.maze.components.MazeComponent;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.ShiftedMazeComponent;
import ivorius.ivtoolkit.tools.GuavaCollectors;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class MazeComponents {
    public static <M extends MazeComponent<C>, C> Function<M, Stream<ShiftedMazeComponent<M, C>>> shiftAllFunction(MazePassage connection, C connector, ConnectionStrategy<C> strategy) {
        return component -> component.exits().entrySet().stream().map(entry -> {
            MazeRoom dist = ((MazePassage)((Object)((Object)((Object)entry.getKey())))).inverseDistance(connection);
            if (dist != null && strategy.connect(connection, connector, entry.getValue()) >= 0.0f) {
                return MazeComponents.shift(component, dist);
            }
            return null;
        }).filter(Objects::nonNull);
    }

    public static <M extends MazeComponent<C>, C> ShiftedMazeComponent<M, C> shift(M component, MazeRoom shift) {
        return new ShiftedMazeComponent<M, Object>(component, shift, component.rooms().stream().map(r -> r != null ? r.add(shift) : null).collect(GuavaCollectors.immutableSet()), component.exits().keySet().stream().collect(GuavaCollectors.toMap(c1 -> c1 != null ? c1.add(shift) : null, component.exits()::get)), component.reachability().keySet().stream().collect(GuavaCollectors.toMultimap(c -> c.add(shift), c -> component.reachability().get((Object)c).stream().map(c2 -> c2.add(shift))::iterator)));
    }

    public static <C> Predicate<? extends MazeComponent<C>> compatibilityPredicate(MazeComponent<C> component, ConnectionStrategy<C> strategy) {
        return input -> MazeComponents.componentsCompatible(component, input, strategy);
    }

    public static <C> boolean componentsCompatible(MazeComponent<C> existing, MazeComponent<C> add, ConnectionStrategy<C> strategy) {
        return !MazeComponents.overlap(existing, add) && MazeComponents.allExitsCompatible(existing, add, strategy);
    }

    public static boolean overlap(MazeComponent<?> left, MazeComponent<?> right) {
        return Sets.intersection(left.rooms(), right.rooms()).size() > 0;
    }

    public static <C> boolean allExitsCompatible(MazeComponent<C> existing, MazeComponent<C> add, ConnectionStrategy<C> strategy) {
        return add.exits().entrySet().stream().allMatch(input -> strategy.connect((MazePassage)((Object)((Object)input.getKey())), existing.exits().get((Object)((MazePassage)((Object)((Object)input.getKey()))).inverse()), input.getValue()) >= 0.0f);
    }

    public static <C> float connectWeight(MazeComponent<C> existing, MazeComponent<C> add, ConnectionStrategy<C> strategy) {
        return add.exits().entrySet().stream().reduce(Float.valueOf(0.0f), (weight, input) -> Float.valueOf(strategy.connect((MazePassage)((Object)((Object)input.getKey())), existing.exits().get((Object)((MazePassage)((Object)((Object)input.getKey()))).inverse()), input.getValue())), (w1, w2) -> Float.valueOf(w1.floatValue() < 0.0f || w2.floatValue() < 0.0f ? -1.0f : w1.floatValue() * w2.floatValue())).floatValue();
    }
}

