/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.models;

import ivorius.ivtoolkit.models.Material;
import ivorius.ivtoolkit.models.Mesh;
import ivorius.ivtoolkit.models.MeshPart;
import ivorius.ivtoolkit.models.Model;
import ivorius.ivtoolkit.models.NodePart;
import ivorius.ivtoolkit.models.attributes.BlendingAttribute;
import ivorius.ivtoolkit.models.attributes.ColorAttribute;
import ivorius.ivtoolkit.models.attributes.TextureAttribute;
import ivorius.ivtoolkit.models.data.IndexData;
import ivorius.ivtoolkit.models.data.VertexAttribute;
import ivorius.ivtoolkit.models.data.VertexAttributes;
import ivorius.ivtoolkit.models.data.VertexData;
import ivorius.ivtoolkit.models.textures.Texture;
import ivorius.ivtoolkit.models.utils.MathUtils;
import ivorius.ivtoolkit.models.utils.MatrixMathUtils;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector4f;

public class ModelRenderer {
    private static final FloatBuffer MATRIX_BUFFER = GLAllocation.func_74529_h((int)16);
    private static final Matrix4f TEMP_MATRIX = new Matrix4f();
    private static final Vector4f TEMP_VEC = new Vector4f();
    private static final float[] WHITE = new float[]{1.0f, 1.0f, 1.0f};

    public static void renderModelDirectly(Model model) {
        WorldRenderer renderer = Tessellator.func_178181_a().func_178180_c();
        model.calculateTransforms();
        model.nodes.stream().filter(node -> node.parts.size() > 0).forEach(node -> {
            GlStateManager.func_179094_E();
            MatrixMathUtils.setTRS(TEMP_MATRIX, node.translation, node.rotation, node.scale);
            ModelRenderer.glMultMatrix(TEMP_MATRIX);
            for (NodePart nodePart : node.parts) {
                ModelRenderer.renderNodePart(renderer, nodePart);
            }
            GlStateManager.func_179121_F();
        });
    }

    private static void renderNodePart(WorldRenderer renderer, NodePart nodePart) {
        MeshPart meshPart = nodePart.meshPart;
        Material material = nodePart.material;
        Matrix4f[] bones = nodePart.bones;
        Mesh mesh = meshPart.mesh;
        IndexData indexData = mesh.getIndices();
        ShortBuffer indexBuf = indexData.getBuffer();
        VertexData vertexData = mesh.getVertices();
        FloatBuffer vertexBuf = vertexData.getBuffer();
        VertexAttributes vertexAttributes = vertexData.getAttributes();
        VertexAttribute posAttr = vertexAttributes.findByUsage(1);
        int vertexLengthInFloats = vertexAttributes.vertexSize >> 2;
        VertexAttribute textureCoordAttr = null;
        float[] rgb = WHITE;
        Texture texture = null;
        float[] uvs = null;
        if (material.has(TextureAttribute.Diffuse)) {
            TextureAttribute textureAttr = material.get(TextureAttribute.class, TextureAttribute.Diffuse);
            texture = textureAttr.texture;
            textureCoordAttr = vertexAttributes.findByUsageAndUnit(16, 0);
            if (textureCoordAttr == null) {
                uvs = ModelRenderer.guessUVs(meshPart.primitiveType, texture, meshPart.numVertices);
            }
        } else if (material.has(ColorAttribute.Diffuse)) {
            ColorAttribute diffuse = material.get(ColorAttribute.class, ColorAttribute.Diffuse);
            rgb = new float[]{(float)diffuse.color.getRed() / 255.0f, (float)diffuse.color.getGreen() / 255.0f, (float)diffuse.color.getBlue() / 255.0f};
        }
        BlendingAttribute blend = material.get(BlendingAttribute.class, BlendingAttribute.Type);
        if (blend != null) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)blend.sourceFunction, (int)blend.destFunction);
            GlStateManager.func_179131_c((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)blend.opacity);
        } else {
            GlStateManager.func_179124_c((float)rgb[0], (float)rgb[1], (float)rgb[2]);
        }
        if (texture != null) {
            texture.bindTexture();
        } else {
            GlStateManager.func_179090_x();
        }
        ArrayList<VertexAttribute> boneWeightAttributes = new ArrayList<VertexAttribute>();
        for (VertexAttribute attribute : vertexAttributes) {
            if (attribute.usage != 64) continue;
            boneWeightAttributes.add(attribute);
        }
        renderer.func_181668_a(meshPart.primitiveType, DefaultVertexFormats.field_181707_g);
        for (int i = meshPart.indexOffset; i < meshPart.numVertices + meshPart.indexOffset; ++i) {
            int vertexIndex = indexBuf.get(i) * vertexLengthInFloats;
            if (texture != null) {
                if (textureCoordAttr != null) {
                    int textureIndex = vertexIndex + (textureCoordAttr.offset >> 2);
                    renderer.func_181673_a((double)MathUtils.mix(texture.minU(), texture.maxU(), vertexBuf.get(textureIndex)), (double)MathUtils.mix(texture.minV(), texture.maxV(), vertexBuf.get(textureIndex + 1)));
                } else if (uvs != null) {
                    renderer.func_181673_a((double)uvs[i * 2], (double)uvs[i * 2 + 1]);
                }
            }
            int posIndex = vertexIndex + (posAttr.offset >> 2);
            float vertexX = vertexBuf.get(posIndex);
            float vertexY = vertexBuf.get(posIndex + 1);
            float vertexZ = vertexBuf.get(posIndex + 2);
            if (boneWeightAttributes.size() > 0) {
                ModelRenderer.buildMatrix(TEMP_MATRIX, boneWeightAttributes, vertexBuf, vertexIndex, bones);
                TEMP_VEC.set(vertexX, vertexY, vertexZ, 1.0f);
                Matrix4f.transform((Matrix4f)TEMP_MATRIX, (Vector4f)TEMP_VEC, (Vector4f)TEMP_VEC);
                renderer.func_181662_b((double)ModelRenderer.TEMP_VEC.x, (double)ModelRenderer.TEMP_VEC.y, (double)ModelRenderer.TEMP_VEC.z).func_181675_d();
                continue;
            }
            renderer.func_181662_b((double)vertexX, (double)vertexY, (double)vertexZ).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
        if (texture == null) {
            GlStateManager.func_179098_w();
        }
        if (blend != null) {
            GlStateManager.func_179084_k();
        }
    }

    public static void buildMatrix(Matrix4f dst, Collection<VertexAttribute> boneWeightAttributes, FloatBuffer floatBuffer, int vertexIndex, Matrix4f[] bones) {
        dst.setZero();
        for (VertexAttribute attribute : boneWeightAttributes) {
            int attributeIndex = vertexIndex + (attribute.offset >> 2);
            float alpha = floatBuffer.get(attributeIndex + 1);
            if (!(alpha > 1.0E-5f)) continue;
            Matrix4f bone = bones[(int)floatBuffer.get(attributeIndex)];
            MatrixMathUtils.add(bone, dst, alpha);
        }
    }

    public static void glMultMatrix(Matrix4f matrix4f) {
        matrix4f.store(MATRIX_BUFFER);
        MATRIX_BUFFER.position(0);
        GlStateManager.func_179110_a((FloatBuffer)MATRIX_BUFFER);
        MATRIX_BUFFER.rewind();
    }

    public static float[] guessUVs(int primitiveType, Texture texture, int length) {
        float[] uvs = new float[length * 2];
        block6: for (int i = 0; i < uvs.length / 2; ++i) {
            switch (i % 4) {
                case 0: {
                    uvs[i * 2] = texture.minU();
                    uvs[i * 2 + 1] = texture.minV();
                    continue block6;
                }
                case 1: {
                    uvs[i * 2] = texture.maxU();
                    uvs[i * 2 + 1] = texture.minV();
                    continue block6;
                }
                case 2: {
                    uvs[i * 2] = texture.maxU();
                    uvs[i * 2 + 1] = texture.maxV();
                    continue block6;
                }
                case 3: {
                    uvs[i * 2] = texture.minU();
                    uvs[i * 2 + 1] = texture.maxV();
                }
            }
        }
        return uvs;
    }
}

