/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.network;

import io.netty.channel.Channel;
import ivorius.ivtoolkit.network.PacketExtendedEntityPropertiesData;
import ivorius.ivtoolkit.network.PacketTileEntityData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class IvNetworkHelperServer {
    public static <UTileEntity extends TileEntity> void sendTileEntityUpdatePacket(UTileEntity tileEntity, String context, SimpleNetworkWrapper network, EntityPlayer player, Object ... params) {
        if (!(player instanceof EntityPlayerMP)) {
            throw new UnsupportedOperationException();
        }
        network.sendTo((IMessage)PacketTileEntityData.packetEntityData(tileEntity, context, params), (EntityPlayerMP)player);
    }

    public static <UTileEntity extends TileEntity> void sendTileEntityUpdatePacket(UTileEntity tileEntity, String context, SimpleNetworkWrapper network, Object ... params) {
        IvNetworkHelperServer.sendToPlayersWatchingChunk(tileEntity.func_145831_w(), tileEntity.func_174877_v().func_177958_n() / 16, tileEntity.func_174877_v().func_177952_p() / 16, network, PacketTileEntityData.packetEntityData(tileEntity, context, params));
    }

    public static void sendToPlayersWatchingChunk(World world, int chunkX, int chunkZ, SimpleNetworkWrapper network, IMessage message) {
        List<EntityPlayerMP> playersWatching = IvNetworkHelperServer.getPlayersWatchingChunk(world, chunkX, chunkZ);
        for (EntityPlayerMP playerMP : playersWatching) {
            network.sendTo(message, playerMP);
        }
    }

    public static void sendToPlayersWatchingChunk(World world, int chunkX, int chunkZ, Channel channel, Object message) {
        List<EntityPlayerMP> playersWatching = IvNetworkHelperServer.getPlayersWatchingChunk(world, chunkX, chunkZ);
        for (EntityPlayerMP playerMP : playersWatching) {
            IvNetworkHelperServer.sendToPlayer(channel, playerMP, message);
        }
    }

    public static void sendToPlayersWatchingChunk(World world, int chunkX, int chunkZ, Packet packet) {
        List<EntityPlayerMP> playersWatching = IvNetworkHelperServer.getPlayersWatchingChunk(world, chunkX, chunkZ);
        for (EntityPlayerMP playerMP : playersWatching) {
            playerMP.field_71135_a.func_147359_a(packet);
        }
    }

    public static void sendToPlayer(Channel channel, EntityPlayerMP playerMP, Object message) {
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)playerMP);
        channel.writeAndFlush(message);
    }

    public static List<EntityPlayerMP> getPlayersWatchingChunk(World world, int chunkX, int chunkZ) {
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return Collections.emptyList();
        }
        ArrayList<EntityPlayerMP> playersWatching = new ArrayList<EntityPlayerMP>();
        WorldServer server = (WorldServer)world;
        PlayerManager playerManager = server.func_73040_p();
        List players = server.field_73010_i;
        List mpplayers = players.stream().filter(p -> p instanceof EntityPlayerMP).collect(Collectors.toList());
        playersWatching.addAll(mpplayers.stream().filter(player -> playerManager.func_72694_a(player, chunkX, chunkZ)).collect(Collectors.toList()));
        return playersWatching;
    }

    public static void sendEEPUpdatePacketToPlayer(Entity entity, String eepKey, String context, SimpleNetworkWrapper network, EntityPlayer player, Object ... params) {
        if (!(player instanceof EntityPlayerMP)) {
            throw new UnsupportedOperationException();
        }
        network.sendTo((IMessage)PacketExtendedEntityPropertiesData.packetEntityData(entity, eepKey, context, params), (EntityPlayerMP)player);
    }

    public static void sendEEPUpdatePacket(Entity entity, String eepKey, String context, SimpleNetworkWrapper network, Object ... params) {
        if (entity.field_70170_p.field_72995_K) {
            throw new UnsupportedOperationException();
        }
        for (EntityPlayer player : ((WorldServer)entity.field_70170_p).func_73039_n().getTrackingPlayers(entity)) {
            IvNetworkHelperServer.sendEEPUpdatePacketToPlayer(entity, eepKey, context, network, player, params);
        }
        if (entity instanceof EntityPlayerMP) {
            IvNetworkHelperServer.sendEEPUpdatePacketToPlayer(entity, eepKey, context, network, (EntityPlayer)entity, params);
        }
    }
}

