/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import ivorius.ivtoolkit.network.IvPacketHelper;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import net.minecraft.entity.Entity;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketExtendedEntityPropertiesData
implements IMessage {
    private int entityID;
    private String context;
    private String eepKey;
    private ByteBuf payload;

    public PacketExtendedEntityPropertiesData() {
    }

    public PacketExtendedEntityPropertiesData(int entityID, String context, String eepKey, ByteBuf payload) {
        this.entityID = entityID;
        this.context = context;
        this.eepKey = eepKey;
        this.payload = payload;
    }

    public static PacketExtendedEntityPropertiesData packetEntityData(Entity entity, String eepKey, String context, Object ... params) {
        IExtendedEntityProperties eep = entity.getExtendedProperties(eepKey);
        if (!(eep instanceof PartialUpdateHandler)) {
            throw new IllegalArgumentException("IExtendedEntityProperties must implement IExtendedEntityPropertiesUpdateData to send update packets!");
        }
        ByteBuf buf = Unpooled.buffer();
        ((PartialUpdateHandler)eep).writeUpdateData(buf, context, params);
        return new PacketExtendedEntityPropertiesData(entity.func_145782_y(), context, eepKey, buf);
    }

    public int getEntityID() {
        return this.entityID;
    }

    public void setEntityID(int entityID) {
        this.entityID = entityID;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getEepKey() {
        return this.eepKey;
    }

    public void setEepKey(String eepKey) {
        this.eepKey = eepKey;
    }

    public ByteBuf getPayload() {
        return this.payload;
    }

    public void setPayload(ByteBuf payload) {
        this.payload = payload;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.context = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.eepKey = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.payload = IvPacketHelper.readByteBuffer(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.context);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.eepKey);
        IvPacketHelper.writeByteBuffer(buf, this.payload);
    }
}

