/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.network.IvPacketHelper;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketTileEntityData
implements IMessage {
    private BlockPos pos;
    private String context;
    private ByteBuf payload;

    public PacketTileEntityData() {
    }

    public PacketTileEntityData(BlockPos pos, String context, ByteBuf payload) {
        this.pos = pos;
        this.context = context;
        this.payload = payload;
    }

    public static <UTileEntity extends TileEntity> PacketTileEntityData packetEntityData(UTileEntity entity, String context, Object ... params) {
        ByteBuf buf = Unpooled.buffer();
        ((PartialUpdateHandler)entity).writeUpdateData(buf, context, params);
        return new PacketTileEntityData(entity.func_174877_v(), context, buf);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public ByteBuf getPayload() {
        return this.payload;
    }

    public void setPayload(ByteBuf payload) {
        this.payload = payload;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPositions.readFromBuffer(buf);
        this.context = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.payload = IvPacketHelper.readByteBuffer(buf);
    }

    public void toBytes(ByteBuf buf) {
        BlockPositions.writeToBuffer(this.pos, buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.context);
        IvPacketHelper.writeByteBuffer(buf, this.payload);
    }
}

