/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.rendering.grid;

import com.google.common.base.Function;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.BufferUtils;

public class GridQuadCache<T>
implements Iterable<CachedQuadLevel<T>> {
    protected final List<CachedQuadLevel<T>> cachedQuadLevels = new ArrayList<CachedQuadLevel<T>>();
    protected float[] size;

    public static int[] getCacheAxes(EnumFacing direction, int ... axes) {
        switch (direction) {
            case DOWN: 
            case UP: {
                return new int[]{axes[1], axes[0], axes[2]};
            }
            case WEST: 
            case EAST: {
                return new int[]{axes[0], axes[2], axes[1]};
            }
            case NORTH: 
            case SOUTH: {
                return new int[]{axes[2], axes[1], axes[0]};
            }
        }
        throw new IllegalArgumentException();
    }

    public static int[] getNormalAxes(EnumFacing direction, int ... axes) {
        return GridQuadCache.getCacheAxes(direction, axes);
    }

    public static float[] getCacheAxes(EnumFacing direction, float ... axes) {
        switch (direction) {
            case DOWN: 
            case UP: {
                return new float[]{axes[1], axes[0], axes[2]};
            }
            case WEST: 
            case EAST: {
                return new float[]{axes[0], axes[2], axes[1]};
            }
            case NORTH: 
            case SOUTH: {
                return new float[]{axes[2], axes[1], axes[0]};
            }
        }
        throw new IllegalArgumentException();
    }

    public static float[] getNormalAxes(EnumFacing direction, float ... axes) {
        return GridQuadCache.getCacheAxes(direction, axes);
    }

    public static <T> GridQuadCache<T> createQuadCache(int[] size, float[] scale, Function<Pair<BlockPos, EnumFacing>, T> mapper) {
        return GridQuadCache.createQuadCacheGreedy(size, scale, mapper);
    }

    protected static <T> GridQuadCache<T> createQuadCacheGreedy(int[] size, float[] scale, Function<Pair<BlockPos, EnumFacing>, T> mapper) {
        HashMap<QuadContext<T>, CoordGrid> partialCache = new HashMap<QuadContext<T>, CoordGrid>();
        for (int x = 0; x < size[0]; ++x) {
            for (int y = 0; y < size[1]; ++y) {
                for (int z = 0; z < size[2]; ++z) {
                    BlockPos coord = new BlockPos(x, y, z);
                    GridQuadCache.addToCache(partialCache, mapper, EnumFacing.UP, coord);
                    GridQuadCache.addToCache(partialCache, mapper, EnumFacing.DOWN, coord);
                    GridQuadCache.addToCache(partialCache, mapper, EnumFacing.NORTH, coord);
                    GridQuadCache.addToCache(partialCache, mapper, EnumFacing.EAST, coord);
                    GridQuadCache.addToCache(partialCache, mapper, EnumFacing.SOUTH, coord);
                    GridQuadCache.addToCache(partialCache, mapper, EnumFacing.WEST, coord);
                }
            }
        }
        Set quads = partialCache.entrySet();
        GridQuadCache<T> cache = new GridQuadCache<T>();
        cache.size = new float[3];
        for (int i = 0; i < 3; ++i) {
            cache.size[i] = (float)size[i] * scale[i];
        }
        for (Map.Entry entry : quads) {
            QuadContext context = (QuadContext)entry.getKey();
            int[] sAxes = GridQuadCache.getCacheAxes(context.direction, size);
            float[] scAxes = GridQuadCache.getCacheAxes(context.direction, scale);
            QuadCollection mesh = ((CoordGrid)((Object)entry.getValue())).computeMesh(0, 0, sAxes[1], sAxes[2]);
            FloatBuffer cachedQuadCoords = BufferUtils.createFloatBuffer((int)(mesh.quadCount() * 4));
            float pxAxis = scAxes[1];
            float pzAxis = scAxes[2];
            for (int i = 0; i < mesh.quadCount(); ++i) {
                cachedQuadCoords.put((float)mesh.x1(i) * pxAxis).put((float)mesh.y1(i) * pzAxis).put((float)(mesh.x2(i) + 1) * pxAxis).put((float)(mesh.y2(i) + 1) * pzAxis);
            }
            cachedQuadCoords.position(0);
            float zLevel = (float)(context.direction.func_82601_c() + context.direction.func_96559_d() + context.direction.func_82599_e() > 0 ? context.layer + 1 : context.layer) * scAxes[0];
            cache.cachedQuadLevels.add(new CachedQuadLevel(zLevel, context.direction, context.t, cachedQuadCoords));
        }
        return cache;
    }

    protected static <T> void addToCache(Map<QuadContext<T>, CoordGrid> cache, Function<Pair<BlockPos, EnumFacing>, T> mapper, EnumFacing direction, BlockPos coord) {
        Object t = mapper.apply((Object)Pair.of((Object)coord, (Object)direction));
        if (t != null) {
            int[] sAxes = GridQuadCache.getCacheAxes(direction, coord.func_177958_n(), coord.func_177956_o(), coord.func_177952_p());
            GridQuadCache.addToCache(cache, new QuadContext<Object>(sAxes[0], direction, t), sAxes[1], sAxes[2]);
        }
    }

    protected static <T> void addToCache(Map<QuadContext<T>, CoordGrid> cache, QuadContext<T> context, int x, int y) {
        CoordGrid quad = cache.get(context);
        if (quad == null) {
            quad = new CoordGrid();
            cache.put(context, quad);
        }
        quad.addCoord(x, y);
    }

    public float[] getSize() {
        return (float[])this.size.clone();
    }

    @Override
    public Iterator<CachedQuadLevel<T>> iterator() {
        return this.cachedQuadLevels.iterator();
    }

    public static class CachedQuadLevel<T> {
        public final float zLevel;
        public final EnumFacing direction;
        public final T t;
        public final FloatBuffer quads;

        public CachedQuadLevel(float zLevel, EnumFacing direction, T t, FloatBuffer quads) {
            this.zLevel = zLevel;
            this.direction = direction;
            this.t = t;
            this.quads = quads;
        }
    }

    public static class QuadCollection
    extends TIntArrayList {
        public QuadCollection() {
        }

        public QuadCollection(int capacity) {
            super(capacity);
        }

        public QuadCollection(int capacity, int no_entry_value) {
            super(capacity, no_entry_value);
        }

        public QuadCollection(TIntCollection collection) {
            super(collection);
        }

        public QuadCollection(int[] values) {
            super(values);
        }

        public QuadCollection(int[] values, int no_entry_value, boolean wrap) {
            super(values, no_entry_value, wrap);
        }

        public void addQuad(int x1, int y1, int x2, int y2) {
            this.add(x1);
            this.add(y1);
            this.add(x2);
            this.add(y2);
        }

        public int x1(int index) {
            return this.get(index * 4);
        }

        public int x2(int index) {
            return this.get(index * 4 + 2);
        }

        public int y1(int index) {
            return this.get(index * 4 + 1);
        }

        public int y2(int index) {
            return this.get(index * 4 + 3);
        }

        public int quadCount() {
            return this.size() / 4;
        }
    }

    public static class CoordGrid
    extends TIntArrayList {
        public CoordGrid() {
        }

        public CoordGrid(int capacity) {
            super(capacity);
        }

        public CoordGrid(int capacity, int no_entry_value) {
            super(capacity, no_entry_value);
        }

        public CoordGrid(TIntCollection collection) {
            super(collection);
        }

        public CoordGrid(int[] values) {
            super(values);
        }

        public CoordGrid(int[] values, int no_entry_value, boolean wrap) {
            super(values, no_entry_value, wrap);
        }

        private static boolean isFree(boolean[][] mask, int lX, int hX, int y) {
            for (int tX = lX; tX <= hX; ++tX) {
                if (mask[tX][y]) continue;
                return false;
            }
            return true;
        }

        public void addCoord(int x, int y) {
            this.add(x);
            this.add(y);
        }

        public int coordCount() {
            return this.size() / 2;
        }

        public int x(int index) {
            return this.get(index * 2);
        }

        public int y(int index) {
            return this.get(index * 2 + 1);
        }

        public QuadCollection computeMesh(int minX, int minY, int maxX, int maxY) {
            boolean[][] mask = new boolean[maxX - minX][maxY - minY];
            QuadCollection collection = new QuadCollection();
            for (int c = 0; c < this.coordCount(); ++c) {
                mask[this.x((int)c)][this.y((int)c)] = true;
            }
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    int lX;
                    if (!mask[x][y]) continue;
                    int hX = x;
                    int lY = y;
                    int hY = y;
                    for (lX = x; lX > minX && mask[lX - 1][y]; --lX) {
                    }
                    while (hX < maxX - 1 && mask[hX + 1][y]) {
                        ++hX;
                    }
                    while (lY > minY && CoordGrid.isFree(mask, lX, hX, lY - 1)) {
                        --lY;
                    }
                    while (hY < maxY - 1 && CoordGrid.isFree(mask, lX, hX, hY + 1)) {
                        ++hY;
                    }
                    for (int tX = lX; tX <= hX; ++tX) {
                        for (int tY = lY; tY <= hY; ++tY) {
                            mask[tX][tY] = false;
                        }
                    }
                    collection.addQuad(lX, lY, hX, hY);
                }
            }
            return collection;
        }
    }

    public static class QuadContext<T> {
        public final int layer;
        public final EnumFacing direction;
        public final T t;

        public QuadContext(int layer, EnumFacing direction, T t) {
            this.layer = layer;
            this.direction = direction;
            this.t = t;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QuadContext that = (QuadContext)o;
            if (this.layer != that.layer) {
                return false;
            }
            if (this.direction != that.direction) {
                return false;
            }
            return this.t.equals(that.t);
        }

        public int hashCode() {
            int result = this.layer;
            result = 31 * result + this.direction.hashCode();
            result = 31 * result + this.t.hashCode();
            return result;
        }
    }
}

