/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.tools;

import ivorius.ivtoolkit.IvToolkitCoreContainer;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.ivtoolkit.tools.NBTWalker;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;

public class NBTStateInjector {
    public static final String ID_FIX_TAG_KEY = "SG_ID_FIX_TAG";

    public static void recursivelyInject(NBTBase nbt) {
        NBTWalker.walkCompounds(nbt, cmp -> {
            NBTStateInjector.inject(cmp);
            return true;
        });
    }

    public static void inject(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        NBTStateInjector.injectTEBlockFixTags(compound, "vanishingTileEntity", list, "BlockID");
        NBTStateInjector.injectTEBlockFixTags(compound, "fenceGateTileEntity", list, "camoBlock");
        NBTStateInjector.injectTEBlockFixTags(compound, "mixedBlockTileEntity", list, "block1", "block2");
        NBTStateInjector.injectTEBlockFixTags(compound, "customDoorTileEntity", list, "frame", "topMaterial", "bottomMaterial");
        if (list.func_74745_c() > 0) {
            compound.func_74782_a(ID_FIX_TAG_KEY, (NBTBase)list);
        }
    }

    private static boolean hasPrimitive(NBTTagCompound compound, String key) {
        return compound.func_74764_b(key) && compound.func_74781_a(key) instanceof NBTBase.NBTPrimitive;
    }

    public static void injectTEBlockFixTags(NBTTagCompound compound, String tileEntityID, NBTTagList list, String ... keys) {
        if (tileEntityID.equals(compound.func_74779_i("id"))) {
            for (String key : keys) {
                if (!NBTStateInjector.hasPrimitive(compound, key)) continue;
                NBTStateInjector.addBlockTag(compound.func_74762_e(key), list, key);
            }
        }
    }

    public static void addBlockTag(int blockID, NBTTagList tagList, String tagDest) {
        Block block = Block.func_149729_e((int)blockID);
        if (block != null) {
            String stringID = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
            NBTTagCompound idCompound = new NBTTagCompound();
            idCompound.func_74778_a("type", "block");
            idCompound.func_74778_a("tagDest", tagDest);
            idCompound.func_74778_a("blockID", stringID);
            tagList.func_74742_a((NBTBase)idCompound);
        } else {
            IvToolkitCoreContainer.logger.warn("Failed to apply block tag for structure with ID '" + blockID + "'");
        }
    }

    public static void recursivelyApply(NBTBase nbt, MCRegistry registry, boolean remove) {
        NBTWalker.walkCompounds(nbt, cmp -> {
            NBTStateInjector.apply(cmp, registry);
            if (remove) {
                cmp.func_82580_o(ID_FIX_TAG_KEY);
            }
            return true;
        });
    }

    public static void apply(NBTTagCompound compound, MCRegistry registry) {
        if (compound.func_74764_b(ID_FIX_TAG_KEY)) {
            NBTTagList list = compound.func_150295_c(ID_FIX_TAG_KEY, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTStateInjector.applyIDFixTag(compound, registry, list.func_150305_b(i));
            }
        }
    }

    public static void applyIDFixTag(NBTTagCompound compound, MCRegistry registry, NBTTagCompound fixTag) {
        String type;
        switch (type = fixTag.func_74779_i("type")) {
            case "item": {
                String dest = fixTag.func_74779_i("tagDest");
                String stringID = fixTag.func_74779_i("itemID");
                Item item = registry.itemFromID(new ResourceLocation(stringID));
                if (item != null) {
                    compound.func_74768_a(dest, Item.func_150891_b((Item)item));
                } else {
                    IvToolkitCoreContainer.logger.warn("Failed to fix item tag from structure with ID '" + stringID + "'");
                }
                registry.modifyItemStackCompound(compound, new ResourceLocation(stringID));
                break;
            }
            case "block": {
                String dest = fixTag.func_74779_i("tagDest");
                String stringID = fixTag.func_74779_i("blockID");
                Block block = registry.blockFromID(new ResourceLocation(stringID));
                if (block != null) {
                    compound.func_74768_a(dest, Block.func_149682_b((Block)block));
                    break;
                }
                IvToolkitCoreContainer.logger.warn("Failed to fix block tag from structure with ID '" + stringID + "'");
                break;
            }
            default: {
                IvToolkitCoreContainer.logger.warn("Unrecognized ID fix tag in structure with type '" + type + "'");
            }
        }
    }
}

