/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.transform;

import com.google.common.collect.ImmutableSet;
import ivorius.ivtoolkit.blocks.BlockTransformable;
import ivorius.ivtoolkit.blocks.Directions;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.tools.EntityCreatureAccessor;
import ivorius.ivtoolkit.tools.EntityHangingAccessor;
import ivorius.ivtoolkit.transform.AreaTransformable;
import ivorius.ivtoolkit.transform.Mover;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityHanging;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class PosTransformer {
    public static void transformTileEntityPos(TileEntity tileEntity, AxisAlignedTransform2D transform, int[] size) {
        if (tileEntity instanceof AreaTransformable) {
            ((AreaTransformable)tileEntity).transform(transform.getRotation(), transform.isMirrorX(), size);
        } else {
            Mover.setTileEntityPos(tileEntity, transform.apply(tileEntity.func_174877_v(), size));
        }
    }

    public static void transformEntityPos(Entity entity, AxisAlignedTransform2D transform, int[] size) {
        if (entity instanceof AreaTransformable) {
            ((AreaTransformable)entity).transform(transform.getRotation(), transform.isMirrorX(), size);
        } else {
            double[] newEntityPos = transform.apply(new double[]{entity.field_70165_t, entity.field_70163_u, entity.field_70161_v}, size);
            entity.func_70107_b(newEntityPos[0], newEntityPos[1], newEntityPos[2]);
            if (entity instanceof EntityHanging) {
                EntityHanging entityHanging = (EntityHanging)entity;
                BlockPos hangingCoord = entityHanging.func_174857_n();
                BlockPos newHangingCoord = transform.apply(hangingCoord, size);
                entityHanging.func_70107_b((double)newHangingCoord.func_177958_n(), (double)newHangingCoord.func_177956_o(), (double)newHangingCoord.func_177952_p());
                EntityHangingAccessor.setHangingDirection(entityHanging, Directions.rotate(entityHanging.field_174860_b, transform));
            }
            if (entity instanceof EntityCreature) {
                EntityCreature entityCreature = (EntityCreature)entity;
                EntityCreatureAccessor.setHomePosition(entityCreature, transform.apply(entityCreature.func_180486_cf(), size));
            }
        }
    }

    public static void transformBlock(AxisAlignedTransform2D transform, World world, IBlockState state, BlockPos coord, Block block) {
        if (block instanceof BlockTransformable) {
            ((BlockTransformable)block).transform(world, coord, state, transform.getRotation(), transform.isMirrorX());
        } else {
            PosTransformer.transformBlockDefault(transform, world, state, coord, block);
        }
    }

    public static void transformBlockDefault(AxisAlignedTransform2D transform, World world, IBlockState state, BlockPos coord, Block block) {
        IBlockState newState = state;
        ImmutableSet propertySet = state.func_177228_b().entrySet();
        for (Map.Entry entry : propertySet) {
            IProperty property = (IProperty)entry.getKey();
            if (property.func_177699_b() != EnumFacing.class || !property.func_177700_c().containsAll(Arrays.asList(EnumFacing.field_176754_o))) continue;
            EnumFacing value = (EnumFacing)entry.getValue();
            newState = newState.func_177226_a(property, (Comparable)transform.apply(value));
        }
        if (newState != state) {
            world.func_175656_a(coord, newState);
        }
    }
}

