/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import greymerk.roguelike.treasure.loot.PotionType;
import greymerk.roguelike.treasure.loot.provider.ItemNovelty;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum Potion {
    HEALING,
    HARM,
    REGEN,
    POISON,
    STRENGTH,
    WEAKNESS,
    SLOWNESS,
    SWIFTNESS,
    FIRERESIST;

    public static final int SPLASH = 16384;
    public static final int REGULAR = 8192;
    public static final int UPGRADE = 32;
    public static final int EXTEND = 64;

    public static ItemStack getRandom(Random rand) {
        if (rand.nextInt(200) == 0) {
            return ItemNovelty.getItem(ItemNovelty.AVIDYA);
        }
        Potion effect = Potion.values()[rand.nextInt(Potion.values().length)];
        return Potion.getSpecific(rand, PotionType.REGULAR, effect);
    }

    public static ItemStack getSpecific(Random rand, PotionType type, Potion effect) {
        return Potion.getSpecific(rand, type, effect, rand.nextBoolean(), rand.nextBoolean());
    }

    public static ItemStack getSpecific(Random rand, PotionType type, Potion effect, boolean upgrade, boolean extend) {
        int id = Potion.getPotionID(effect);
        if (upgrade && !extend) {
            id = Potion.upgrade(effect, id);
        }
        if (extend && !upgrade) {
            id = Potion.extend(effect, id);
        }
        if (upgrade && extend) {
            id = rand.nextBoolean() ? Potion.upgrade(effect, id) : Potion.extend(effect, id);
        }
        id = type == PotionType.SPLASH ? (id |= 0x4000) : (id |= 0x2000);
        return new ItemStack((Item)Items.field_151068_bn, 1, id);
    }

    public static int getPotionID(Potion effect) {
        switch (effect) {
            case REGEN: {
                return 1;
            }
            case SWIFTNESS: {
                return 2;
            }
            case FIRERESIST: {
                return 3;
            }
            case POISON: {
                return 4;
            }
            case HEALING: {
                return 5;
            }
            case WEAKNESS: {
                return 8;
            }
            case STRENGTH: {
                return 9;
            }
            case SLOWNESS: {
                return 10;
            }
            case HARM: {
                return 12;
            }
        }
        return 0;
    }

    private static int upgrade(Potion effect, int id) {
        if (effect == FIRERESIST) {
            return id;
        }
        return (id &= 0xF) | 0x20;
    }

    private static int extend(Potion effect, int id) {
        if (effect == HEALING || effect == HARM) {
            return id;
        }
        return (id &= 0xF) | 0x40;
    }
}

