/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.util;

import greymerk.roguelike.citadel.Citadel;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.settings.ISettings;
import greymerk.roguelike.treasure.loot.provider.ItemNovelty;
import greymerk.roguelike.util.ArgumentParser;
import greymerk.roguelike.util.TextFormat;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.List;
import java.util.Random;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class CommandSpawnDungeon
extends CommandBase {
    public String func_71517_b() {
        return "roguelike";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        return "";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        ArgumentParser ap = new ArgumentParser(args);
        if (!ap.hasEntry(0)) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Usage: roguelike [dungeon | give | config]", TextFormat.GRAY)));
            return;
        }
        if (ap.match(0, "config")) {
            if (!ap.hasEntry(1)) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Usage: roguelike config reload", TextFormat.GRAY)));
                return;
            }
            if (ap.match(1, "reload")) {
                RogueConfig.reload(true);
                sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Success: Configurations Reloaded", TextFormat.GREEN)));
                return;
            }
            return;
        }
        if (ap.match(0, "dim")) {
            int dim = sender.func_130014_f_().field_73011_w.func_177502_q();
            sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Dimension id: " + Integer.toString(dim), TextFormat.GOLD)));
            return;
        }
        if (ap.match(0, "settings")) {
            if (!ap.hasEntry(1)) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Usage: roguelike settings [reload | list]", TextFormat.GRAY)));
                return;
            }
            if (ap.match(1, "reload")) {
                Dungeon.initResolver();
                sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Success: Settings Reloaded", TextFormat.GREEN)));
                return;
            }
            if (ap.match(1, "list")) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply(Dungeon.settingsResolver.toString(), TextFormat.GREEN)));
                return;
            }
            return;
        }
        if (ap.match(0, "give")) {
            if (!ap.hasEntry(1)) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Usage: roguelike give novelty_name", TextFormat.GRAY)));
                return;
            }
            EntityPlayerMP player = null;
            try {
                player = CommandSpawnDungeon.func_71521_c((ICommandSender)sender);
            }
            catch (PlayerNotFoundException e) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Failed: Player error", TextFormat.RED)));
                return;
            }
            ItemStack item = ItemNovelty.getItemByName(ap.get(1));
            if (item == null) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Failed: No such item", TextFormat.RED)));
                return;
            }
            EntityItem drop = player.func_70099_a(item, 0.0f);
            drop.func_174868_q();
            sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Success: Given " + item.func_82833_r(), TextFormat.GREEN)));
            return;
        }
        if (ap.match(0, "dungeon")) {
            int z;
            int x;
            if (!ap.hasEntry(1)) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Usage: roguelike dungeon {X Z | here} [setting]", TextFormat.GRAY)));
                return;
            }
            String settingName = null;
            if (ap.match(1, "here")) {
                EntityPlayerMP player = null;
                try {
                    player = CommandSpawnDungeon.func_71521_c((ICommandSender)sender);
                }
                catch (PlayerNotFoundException e) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Failure: Cannot find player", TextFormat.RED)));
                    return;
                }
                x = (int)player.field_70165_t;
                z = (int)player.field_70161_v;
                if (ap.hasEntry(2)) {
                    settingName = ap.get(2);
                }
            } else {
                if (ap.match(1, "nearby")) {
                    EntityPlayerMP player = null;
                    try {
                        player = CommandSpawnDungeon.func_71521_c((ICommandSender)sender);
                    }
                    catch (PlayerNotFoundException e) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Failure: Cannot find player", TextFormat.RED)));
                        return;
                    }
                    int x2 = (int)player.field_70165_t;
                    int z2 = (int)player.field_70161_v;
                    if (ap.hasEntry(2)) {
                        int num = 0;
                        try {
                            num = CommandSpawnDungeon.func_175755_a((String)ap.get(2));
                        }
                        catch (NumberInvalidException e) {
                            sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Failure: Third argument must be a whole number", TextFormat.RED)));
                            return;
                        }
                        if (num <= 0) {
                            sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Failure: Third argument must be greater than zero.", TextFormat.RED)));
                            return;
                        }
                        for (int i = 0; i < num; ++i) {
                            WorldEditor editor = new WorldEditor(player.field_70170_p);
                            Dungeon toGenerate = new Dungeon(editor);
                            Random rand = new Random();
                            toGenerate.generateNear(rand, x2, z2);
                        }
                        sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Success: Dungeons generated all over the place!", TextFormat.GREEN)));
                        return;
                    }
                    WorldEditor editor = new WorldEditor(player.field_70170_p);
                    Dungeon toGenerate = new Dungeon(editor);
                    Random rand = Dungeon.getRandom(editor, x2, z2);
                    toGenerate.generateNear(rand, x2, z2);
                    try {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Success: Dungeon generated at " + toGenerate.getPosition().toString(), TextFormat.GREEN)));
                    }
                    catch (Exception e) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Failure: Unable to generate dungeon", TextFormat.RED)));
                    }
                    return;
                }
                try {
                    x = CommandSpawnDungeon.func_175755_a((String)ap.get(1));
                    z = CommandSpawnDungeon.func_175755_a((String)ap.get(2));
                }
                catch (NumberInvalidException e) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Failure: Invalid Coords: X Z", TextFormat.RED)));
                    return;
                }
                if (ap.hasEntry(3)) {
                    settingName = ap.get(3);
                }
            }
            World world = sender.func_130014_f_();
            WorldEditor editor = new WorldEditor(world);
            if (settingName != null) {
                Dungeon.initResolver();
                ISettings settings = Dungeon.settingsResolver.getWithDefault(settingName);
                if (settings == null) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Failed: " + settingName + " not found.", TextFormat.RED)));
                    return;
                }
                Dungeon dungeon = new Dungeon(editor);
                dungeon.generate(settings, x, z);
                try {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Success: \"" + settingName + "\" Dungeon generated at " + dungeon.getPosition().toString(), TextFormat.GREEN)));
                }
                catch (Exception e) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Failure: Unable to generate dungeon", TextFormat.RED)));
                }
                return;
            }
            Random rand = Dungeon.getRandom(editor, x, z);
            ISettings settings = Dungeon.settingsResolver.getSettings(editor, rand, new Coord(x, 0, z));
            if (settings != null) {
                Dungeon dungeon = new Dungeon(editor);
                dungeon.generate(settings, x, z);
                sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Success: Dungeon generated at " + Integer.toString(x) + " " + Integer.toString(z), TextFormat.GREEN)));
                return;
            }
            Dungeon dungeon = new Dungeon(editor);
            dungeon.generate(Dungeon.settingsResolver.getDefaultSettings(), x, z);
            sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Success: Dungeon generated at " + Integer.toString(x) + " " + Integer.toString(z), TextFormat.GREEN)));
            return;
        }
        if (ap.match(0, "citadel")) {
            int z;
            int x;
            try {
                x = CommandSpawnDungeon.func_175755_a((String)ap.get(1));
                z = CommandSpawnDungeon.func_175755_a((String)ap.get(2));
            }
            catch (NumberInvalidException e) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Failure: Invalid Coords: X Z", TextFormat.RED)));
                return;
            }
            World world = sender.func_130014_f_();
            Citadel.generate(new WorldEditor(world), x, z);
            return;
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText(TextFormat.apply("Usage: roguelike [dungeon | give | config]", TextFormat.GRAY)));
    }

    public List addTabCompletionOptions(ICommandSender par1ICommandSender, String[] par2ArrayOfStr) {
        return null;
    }

    public boolean func_82358_a(String[] par1ArrayOfStr, int par2) {
        return par2 == 0;
    }
}

