/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.worldgen.BlockBase;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;

public class MetaBlock
extends BlockBase
implements IBlockState {
    private IBlockState state;
    private int flag;

    public MetaBlock(Block block) {
        this.state = block.func_176223_P();
        this.flag = 2;
    }

    public MetaBlock(IBlockState state) {
        this.state = state;
        this.flag = 2;
    }

    public MetaBlock(Block block, IProperty ... properties) {
        BlockState s = new BlockState(block, properties);
        this.state = s.func_177621_b();
    }

    public MetaBlock(JsonElement e) {
        JsonObject json = (JsonObject)e;
        String name = json.get("name").getAsString();
        ResourceLocation location = new ResourceLocation(name);
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)location);
        int meta = json.has("meta") ? json.get("meta").getAsInt() : 0;
        this.state = block.func_176203_a(meta);
        this.flag = json.has("flag") ? json.get("flag").getAsInt() : 2;
    }

    public void setState(IBlockState state) {
        this.state = state;
    }

    public boolean set(IWorldEditor editor, Coord pos) {
        return editor.setBlock(pos, this, true, true);
    }

    @Override
    public boolean set(IWorldEditor editor, Random rand, Coord pos, boolean fillAir, boolean replaceSolid) {
        return editor.setBlock(pos, this, fillAir, replaceSolid);
    }

    public Collection<IProperty> func_177227_a() {
        return this.state.func_177227_a();
    }

    public <T extends Comparable<T>> T func_177229_b(IProperty<T> property) {
        return (T)this.state.func_177229_b(property);
    }

    public <T extends Comparable<T>, V extends T> IBlockState func_177226_a(IProperty<T> property, V value) {
        this.state = this.state.func_177226_a(property, value);
        return this.state;
    }

    public IBlockState func_177231_a(IProperty property) {
        return this.state.func_177231_a(property);
    }

    public ImmutableMap<IProperty, Comparable> func_177228_b() {
        return this.state.func_177228_b();
    }

    public IBlockState getState() {
        return this.state;
    }

    public Block func_177230_c() {
        return this.state.func_177230_c();
    }

    public int getFlag() {
        return this.flag;
    }

    public String toString() {
        return this.state.func_177230_c().func_149739_a();
    }

    public Material getMaterial() {
        return this.state.func_177230_c().func_149688_o();
    }

    public boolean isOpaqueCube() {
        return this.state.func_177230_c().func_149662_c();
    }
}

