/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.blocks;

import greymerk.roguelike.worldgen.MetaBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.block.BlockRedSandstone;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum BlockType {
    AIR,
    WATER_STILL,
    WATER_FLOWING,
    LAVA_STILL,
    LAVA_FLOWING,
    FIRE,
    IRON_BAR,
    STONE_SMOOTH,
    GRANITE,
    GRANITE_POLISHED,
    DIORITE,
    DIORITE_POLISHED,
    ANDESITE,
    ANDESITE_POLISHED,
    GRASS,
    DIRT,
    DIRT_COARSE,
    DIRT_PODZOL,
    COBBLESTONE,
    COBBLESTONE_WALL,
    BEDROCK,
    SAND,
    SAND_RED,
    GRAVEL,
    ORE_GOLD,
    ORE_IRON,
    ORE_COAL,
    GLASS,
    ORE_LAPIS,
    ORE_EMERALD,
    LAPIS_BLOCK,
    SANDSTONE,
    SANDSTONE_CHISELED,
    SANDSTONE_SMOOTH,
    GOLD_BLOCK,
    IRON_BLOCK,
    BRICK,
    COBBLESTONE_MOSSY,
    OBSIDIAN,
    ORE_DIAMOND,
    DIAMOND_BLOCK,
    FARMLAND,
    ORE_REDSTONE,
    ICE,
    SNOW,
    CLAY,
    NETHERRACK,
    SOUL_SAND,
    GLOWSTONE,
    STONE_BRICK,
    STONE_BRICK_MOSSY,
    STONE_BRICK_CRACKED,
    STONE_BRICK_CHISELED,
    MYCELIUM,
    NETHERBRICK,
    END_STONE,
    EMERALD_BLOCK,
    ORE_QUARTZ,
    PRISMITE,
    PRISMARINE,
    PRISMARINE_DARK,
    SEA_LANTERN,
    COAL_BLOCK,
    ICE_PACKED,
    SANDSTONE_RED,
    SANDSTONE_RED_CHISELED,
    SANDSTONE_RED_SMOOTH,
    QUARTZ,
    REDSTONE_BLOCK,
    PRESSURE_PLATE_STONE,
    PRESSURE_PLATE_WOODEN,
    SHELF,
    REDSTONE_WIRE,
    COCAO,
    REEDS,
    CRAFTING_TABLE,
    NOTEBLOCK,
    REDSTONE_LAMP,
    REDSTONE_LAMP_LIT,
    JUKEBOX,
    FENCE,
    TNT,
    ENCHANTING_TABLE,
    FENCE_NETHER_BRICK,
    WEB,
    PUMPKIN_LIT,
    VINE,
    ENDERCHEST;


    public static MetaBlock get(BlockType type) {
        switch (type) {
            case AIR: {
                return new MetaBlock(Blocks.field_150350_a);
            }
            case WATER_STILL: {
                return new MetaBlock((Block)Blocks.field_150355_j);
            }
            case WATER_FLOWING: {
                return new MetaBlock((Block)Blocks.field_150358_i);
            }
            case LAVA_STILL: {
                return new MetaBlock((Block)Blocks.field_150353_l);
            }
            case LAVA_FLOWING: {
                return new MetaBlock((Block)Blocks.field_150356_k);
            }
            case FIRE: {
                return new MetaBlock((Block)Blocks.field_150480_ab);
            }
            case IRON_BAR: {
                return new MetaBlock(Blocks.field_150411_aY);
            }
            case STONE_SMOOTH: {
                return new MetaBlock(Blocks.field_150348_b);
            }
            case GRANITE: {
                MetaBlock block = new MetaBlock(Blocks.field_150348_b);
                block.func_177226_a(BlockStone.field_176247_a, BlockStone.EnumType.GRANITE);
                return block;
            }
            case GRANITE_POLISHED: {
                MetaBlock block = new MetaBlock(Blocks.field_150348_b);
                block.func_177226_a(BlockStone.field_176247_a, BlockStone.EnumType.GRANITE_SMOOTH);
                return block;
            }
            case DIORITE: {
                MetaBlock block = new MetaBlock(Blocks.field_150348_b);
                block.func_177226_a(BlockStone.field_176247_a, BlockStone.EnumType.DIORITE);
                return block;
            }
            case DIORITE_POLISHED: {
                MetaBlock block = new MetaBlock(Blocks.field_150348_b);
                block.func_177226_a(BlockStone.field_176247_a, BlockStone.EnumType.DIORITE_SMOOTH);
                return block;
            }
            case ANDESITE: {
                MetaBlock block = new MetaBlock(Blocks.field_150348_b);
                block.func_177226_a(BlockStone.field_176247_a, BlockStone.EnumType.ANDESITE);
                return block;
            }
            case ANDESITE_POLISHED: {
                MetaBlock block = new MetaBlock(Blocks.field_150348_b);
                block.func_177226_a(BlockStone.field_176247_a, BlockStone.EnumType.ANDESITE_SMOOTH);
                return block;
            }
            case GRASS: {
                return new MetaBlock((Block)Blocks.field_150349_c);
            }
            case DIRT: {
                return new MetaBlock(Blocks.field_150346_d);
            }
            case DIRT_COARSE: {
                MetaBlock block = new MetaBlock(Blocks.field_150346_d);
                block.func_177226_a(BlockDirt.field_176386_a, BlockDirt.DirtType.COARSE_DIRT);
                return block;
            }
            case DIRT_PODZOL: {
                MetaBlock block = new MetaBlock(Blocks.field_150346_d);
                block.func_177226_a(BlockDirt.field_176386_a, BlockDirt.DirtType.PODZOL);
                return block;
            }
            case COBBLESTONE: {
                return new MetaBlock(Blocks.field_150347_e);
            }
            case COBBLESTONE_WALL: {
                return new MetaBlock(Blocks.field_150463_bK);
            }
            case BEDROCK: {
                return new MetaBlock(Blocks.field_150357_h);
            }
            case SAND: {
                return new MetaBlock((Block)Blocks.field_150354_m);
            }
            case SAND_RED: {
                MetaBlock block = new MetaBlock((Block)Blocks.field_150354_m);
                block.func_177226_a(BlockSand.field_176504_a, BlockSand.EnumType.RED_SAND);
                return block;
            }
            case GRAVEL: {
                return new MetaBlock(Blocks.field_150351_n);
            }
            case ORE_GOLD: {
                return new MetaBlock(Blocks.field_150352_o);
            }
            case ORE_IRON: {
                return new MetaBlock(Blocks.field_150366_p);
            }
            case GLASS: {
                return new MetaBlock(Blocks.field_150359_w);
            }
            case ORE_LAPIS: {
                return new MetaBlock(Blocks.field_150369_x);
            }
            case LAPIS_BLOCK: {
                return new MetaBlock(Blocks.field_150368_y);
            }
            case ORE_EMERALD: {
                return new MetaBlock(Blocks.field_150412_bA);
            }
            case SANDSTONE: {
                return new MetaBlock(Blocks.field_150322_A);
            }
            case SANDSTONE_CHISELED: {
                MetaBlock block = new MetaBlock(Blocks.field_150322_A);
                block.func_177226_a(BlockSandStone.field_176297_a, BlockSandStone.EnumType.CHISELED);
                return block;
            }
            case SANDSTONE_SMOOTH: {
                MetaBlock block = new MetaBlock(Blocks.field_150322_A);
                block.func_177226_a(BlockSandStone.field_176297_a, BlockSandStone.EnumType.SMOOTH);
                return block;
            }
            case GOLD_BLOCK: {
                return new MetaBlock(Blocks.field_150340_R);
            }
            case IRON_BLOCK: {
                return new MetaBlock(Blocks.field_150339_S);
            }
            case BRICK: {
                return new MetaBlock(Blocks.field_150336_V);
            }
            case COBBLESTONE_MOSSY: {
                return new MetaBlock(Blocks.field_150341_Y);
            }
            case OBSIDIAN: {
                return new MetaBlock(Blocks.field_150343_Z);
            }
            case ORE_DIAMOND: {
                return new MetaBlock(Blocks.field_150482_ag);
            }
            case DIAMOND_BLOCK: {
                return new MetaBlock(Blocks.field_150484_ah);
            }
            case FARMLAND: {
                return new MetaBlock(Blocks.field_150458_ak);
            }
            case ORE_REDSTONE: {
                return new MetaBlock(Blocks.field_150450_ax);
            }
            case ICE: {
                return new MetaBlock(Blocks.field_150432_aD);
            }
            case SNOW: {
                return new MetaBlock(Blocks.field_150433_aE);
            }
            case CLAY: {
                return new MetaBlock(Blocks.field_150435_aG);
            }
            case NETHERRACK: {
                return new MetaBlock(Blocks.field_150424_aL);
            }
            case SOUL_SAND: {
                return new MetaBlock(Blocks.field_150425_aM);
            }
            case GLOWSTONE: {
                return new MetaBlock(Blocks.field_150426_aN);
            }
            case STONE_BRICK: {
                return new MetaBlock(Blocks.field_150417_aV);
            }
            case STONE_BRICK_MOSSY: {
                MetaBlock block = new MetaBlock(Blocks.field_150417_aV);
                block.func_177226_a(BlockStoneBrick.field_176249_a, BlockStoneBrick.EnumType.MOSSY);
                return block;
            }
            case STONE_BRICK_CRACKED: {
                MetaBlock block = new MetaBlock(Blocks.field_150417_aV);
                block.func_177226_a(BlockStoneBrick.field_176249_a, BlockStoneBrick.EnumType.CRACKED);
                return block;
            }
            case STONE_BRICK_CHISELED: {
                MetaBlock block = new MetaBlock(Blocks.field_150417_aV);
                block.func_177226_a(BlockStoneBrick.field_176249_a, BlockStoneBrick.EnumType.CHISELED);
                return block;
            }
            case MYCELIUM: {
                return new MetaBlock((Block)Blocks.field_150391_bh);
            }
            case NETHERBRICK: {
                return new MetaBlock(Blocks.field_150385_bj);
            }
            case END_STONE: {
                return new MetaBlock(Blocks.field_150377_bs);
            }
            case EMERALD_BLOCK: {
                return new MetaBlock(Blocks.field_150475_bE);
            }
            case ORE_QUARTZ: {
                return new MetaBlock(Blocks.field_150449_bY);
            }
            case PRISMITE: {
                MetaBlock block = new MetaBlock(Blocks.field_180397_cI);
                block.func_177226_a(BlockPrismarine.field_176332_a, BlockPrismarine.EnumType.ROUGH);
                return block;
            }
            case PRISMARINE: {
                MetaBlock block = new MetaBlock(Blocks.field_180397_cI);
                block.func_177226_a(BlockPrismarine.field_176332_a, BlockPrismarine.EnumType.BRICKS);
                return block;
            }
            case PRISMARINE_DARK: {
                MetaBlock block = new MetaBlock(Blocks.field_180397_cI);
                block.func_177226_a(BlockPrismarine.field_176332_a, BlockPrismarine.EnumType.DARK);
                return block;
            }
            case SEA_LANTERN: {
                return new MetaBlock(Blocks.field_180398_cJ);
            }
            case COAL_BLOCK: {
                return new MetaBlock(Blocks.field_150402_ci);
            }
            case ICE_PACKED: {
                return new MetaBlock(Blocks.field_150403_cj);
            }
            case SANDSTONE_RED: {
                return new MetaBlock(Blocks.field_180395_cM);
            }
            case SANDSTONE_RED_CHISELED: {
                MetaBlock block = new MetaBlock(Blocks.field_180395_cM);
                block.func_177226_a(BlockRedSandstone.field_176336_a, BlockRedSandstone.EnumType.CHISELED);
                return block;
            }
            case SANDSTONE_RED_SMOOTH: {
                MetaBlock block = new MetaBlock(Blocks.field_180395_cM);
                block.func_177226_a(BlockRedSandstone.field_176336_a, BlockRedSandstone.EnumType.SMOOTH);
                return block;
            }
            case QUARTZ: {
                return new MetaBlock(Blocks.field_150371_ca);
            }
            case REDSTONE_BLOCK: {
                return new MetaBlock(Blocks.field_150451_bX);
            }
            case PRESSURE_PLATE_STONE: {
                return new MetaBlock(Blocks.field_150456_au);
            }
            case PRESSURE_PLATE_WOODEN: {
                return new MetaBlock(Blocks.field_150452_aw);
            }
            case SHELF: {
                return new MetaBlock(Blocks.field_150342_X);
            }
            case REDSTONE_WIRE: {
                return new MetaBlock((Block)Blocks.field_150488_af);
            }
            case COCAO: {
                return new MetaBlock(Blocks.field_150375_by);
            }
            case REEDS: {
                return new MetaBlock((Block)Blocks.field_150436_aH);
            }
            case CRAFTING_TABLE: {
                return new MetaBlock(Blocks.field_150462_ai);
            }
            case NOTEBLOCK: {
                return new MetaBlock(Blocks.field_150323_B);
            }
            case REDSTONE_LAMP: {
                return new MetaBlock(Blocks.field_150379_bu);
            }
            case REDSTONE_LAMP_LIT: {
                return new MetaBlock(Blocks.field_150374_bv.func_176223_P());
            }
            case JUKEBOX: {
                return new MetaBlock(Blocks.field_150421_aI);
            }
            case FENCE: {
                return new MetaBlock(Blocks.field_180407_aO);
            }
            case TNT: {
                return new MetaBlock(Blocks.field_150335_W);
            }
            case ENCHANTING_TABLE: {
                return new MetaBlock(Blocks.field_150381_bn);
            }
            case FENCE_NETHER_BRICK: {
                return new MetaBlock(Blocks.field_150386_bk);
            }
            case WEB: {
                return new MetaBlock(Blocks.field_150321_G);
            }
            case PUMPKIN_LIT: {
                return new MetaBlock(Blocks.field_150428_aP);
            }
            case VINE: {
                return new MetaBlock(Blocks.field_150395_bd);
            }
            case ENDERCHEST: {
                return new MetaBlock(Blocks.field_150477_bB);
            }
        }
        return new MetaBlock(Blocks.field_150350_a);
    }

    public static ItemStack getItem(BlockType type) {
        MetaBlock block = BlockType.get(type);
        Block b = block.func_177230_c();
        Item i = Item.func_150898_a((Block)b);
        ItemStack item = new ItemStack(i);
        return item;
    }
}

