/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.blocks;

import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.blocks.Log;
import greymerk.roguelike.worldgen.blocks.WoodBlock;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;

public enum Wood {
    OAK,
    SPRUCE,
    BIRCH,
    JUNGLE,
    ACACIA,
    DARKOAK;


    public static MetaBlock get(WoodBlock block) {
        return Wood.get(OAK, block);
    }

    public static MetaBlock get(Wood type, WoodBlock block) {
        switch (block) {
            case LOG: {
                return Log.getLog(type);
            }
            case PLANK: {
                return Wood.getPlank(type);
            }
            case FENCE: {
                return Wood.getFence(type);
            }
        }
        return Log.getLog(OAK);
    }

    public static MetaBlock getPlank(Wood type) {
        MetaBlock plank = new MetaBlock(Blocks.field_150344_f);
        switch (type) {
            case OAK: {
                plank.func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.OAK);
                break;
            }
            case SPRUCE: {
                plank.func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.SPRUCE);
                break;
            }
            case BIRCH: {
                plank.func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.BIRCH);
                break;
            }
            case JUNGLE: {
                plank.func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.JUNGLE);
                break;
            }
            case ACACIA: {
                plank.func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.ACACIA);
                break;
            }
            case DARKOAK: {
                plank.func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.DARK_OAK);
            }
        }
        return plank;
    }

    public static MetaBlock getFence(Wood type) {
        MetaBlock fence;
        switch (type) {
            case OAK: {
                fence = new MetaBlock(Blocks.field_180407_aO);
                break;
            }
            case SPRUCE: {
                fence = new MetaBlock(Blocks.field_180408_aP);
                break;
            }
            case BIRCH: {
                fence = new MetaBlock(Blocks.field_180404_aQ);
                break;
            }
            case JUNGLE: {
                fence = new MetaBlock(Blocks.field_180403_aR);
                break;
            }
            case ACACIA: {
                fence = new MetaBlock(Blocks.field_180405_aT);
                break;
            }
            case DARKOAK: {
                fence = new MetaBlock(Blocks.field_180406_aS);
                break;
            }
            default: {
                fence = new MetaBlock(Blocks.field_180407_aO);
            }
        }
        return fence;
    }

    public static MetaBlock getSapling(Wood type) {
        MetaBlock sapling = new MetaBlock(Blocks.field_150345_g);
        switch (type) {
            case OAK: {
                sapling.func_177226_a(BlockSapling.field_176480_a, BlockPlanks.EnumType.OAK);
                break;
            }
            case SPRUCE: {
                sapling.func_177226_a(BlockSapling.field_176480_a, BlockPlanks.EnumType.SPRUCE);
                break;
            }
            case BIRCH: {
                sapling.func_177226_a(BlockSapling.field_176480_a, BlockPlanks.EnumType.BIRCH);
                break;
            }
            case JUNGLE: {
                sapling.func_177226_a(BlockSapling.field_176480_a, BlockPlanks.EnumType.JUNGLE);
                break;
            }
            case ACACIA: {
                sapling.func_177226_a(BlockSapling.field_176480_a, BlockPlanks.EnumType.ACACIA);
                break;
            }
            case DARKOAK: {
                sapling.func_177226_a(BlockSapling.field_176480_a, BlockPlanks.EnumType.DARK_OAK);
                break;
            }
        }
        return sapling;
    }

    public static MetaBlock applyType(MetaBlock source, MetaBlock destination) {
        destination.func_177226_a(BlockPlanks.field_176383_a, source.func_177229_b(BlockPlanks.field_176383_a));
        return destination;
    }
}

