/*
 * Decompiled with CFR 0.152.
 */
package squeek.wailaharvestability.helpers;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;

public class BlockHelper {
    private static final HashMap<String, ItemStack> testTools = new HashMap();

    public static String getEffectiveToolOf(World world, BlockPos blockPos, Block block, IBlockState blockState) {
        float hardness;
        String effectiveTool = block.getHarvestTool(blockState);
        if (effectiveTool == null && (hardness = block.func_176195_g(world, blockPos)) > 0.0f) {
            for (Map.Entry<String, ItemStack> testToolEntry : testTools.entrySet()) {
                ItemStack testTool = testToolEntry.getValue();
                if (testTool == null || !(testTool.func_77973_b() instanceof ItemTool) || !(testTool.func_150997_a(block) >= ((ItemTool)testTool.func_77973_b()).func_150913_i().func_77998_b())) continue;
                effectiveTool = testToolEntry.getKey();
                break;
            }
        }
        return effectiveTool;
    }

    public static boolean isBlockUnbreakable(Block block, World world, BlockPos blockPos) {
        return block.func_176195_g(world, blockPos) == -1.0f;
    }

    public static boolean isAdventureModeAndBlockIsUnbreakable(EntityPlayer player, Block block) {
        NetworkPlayerInfo networkplayerinfo = Minecraft.func_71410_x().func_147114_u().func_175102_a(player.func_146103_bH().getId());
        WorldSettings.GameType gameType = networkplayerinfo.func_178848_b();
        if (!gameType.func_82752_c()) {
            return false;
        }
        if (player.func_175142_cm()) {
            return false;
        }
        ItemStack heldItem = player.func_71045_bC();
        return gameType == WorldSettings.GameType.SPECTATOR || heldItem == null || !heldItem.func_179544_c(block);
    }

    public static boolean canHarvestBlock(Block block, EntityPlayer player, IBlockState state) {
        if (block.func_149688_o().func_76229_l()) {
            return true;
        }
        ItemStack stack = player.field_71071_by.func_70448_g();
        String tool = block.getHarvestTool(state);
        if (stack == null || tool == null) {
            return player.func_146099_a(block);
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool);
        if (toolLevel < 0) {
            return player.func_146099_a(block);
        }
        return toolLevel >= block.getHarvestLevel(state);
    }

    static {
        testTools.put("pickaxe", new ItemStack(Items.field_151039_o));
        testTools.put("shovel", new ItemStack(Items.field_151038_n));
        testTools.put("axe", new ItemStack(Items.field_151053_p));
    }
}

