/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaks;
import invtweaks.InvTweaksConfig;
import invtweaks.InvTweaksConfigSortingRule;
import invtweaks.InvTweaksConfigSortingRuleType;
import invtweaks.InvTweaksItemTree;
import invtweaks.InvTweaksObfuscation;
import invtweaks.api.IItemTreeItem;
import invtweaks.api.container.ContainerSection;
import invtweaks.container.ContainerSectionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;

public class InvTweaksHandlerAutoRefill
extends InvTweaksObfuscation {
    private static final Logger log = InvTweaks.log;
    private InvTweaksConfig config = null;

    public InvTweaksHandlerAutoRefill(Minecraft mc_, InvTweaksConfig config_) {
        super(mc_);
        this.config = config_;
    }

    public void setConfig(InvTweaksConfig config_) {
        this.config = config_;
    }

    public void autoRefillSlot(int slot, String wantedId, int wantedDamage) throws Exception {
        ContainerSectionManager container = new ContainerSectionManager(ContainerSection.INVENTORY);
        ItemStack replacementStack = null;
        int replacementStackSlot = -1;
        boolean refillBeforeBreak = this.config.getProperty("autoRefillBeforeBreak").equals("true");
        boolean hasSubtypes = false;
        Item original = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(wantedId));
        if (original != null) {
            hasSubtypes = original.func_77614_k();
        }
        ArrayList<InvTweaksConfigSortingRule> matchingRules = new ArrayList<InvTweaksConfigSortingRule>();
        List<InvTweaksConfigSortingRule> rules = this.config.getRules();
        InvTweaksItemTree tree = this.config.getTree();
        if (!tree.isItemUnknown(wantedId, wantedDamage)) {
            List<IItemTreeItem> items = tree.getItems(wantedId, wantedDamage);
            for (IItemTreeItem item : items) {
                if (hasSubtypes && item.getDamage() != wantedDamage && item.getDamage() != Short.MAX_VALUE) continue;
                matchingRules.add(new InvTweaksConfigSortingRule(tree, "D" + (slot - 26), item.getName(), 36, 9));
            }
            block1: for (InvTweaksConfigSortingRule rule : rules) {
                if (rule.getType() != InvTweaksConfigSortingRuleType.SLOT && rule.getType() != InvTweaksConfigSortingRuleType.COLUMN) continue;
                for (int preferredSlot : rule.getPreferredSlots()) {
                    if (slot != preferredSlot) continue;
                    matchingRules.add(rule);
                    continue block1;
                }
            }
            for (InvTweaksConfigSortingRule rule : matchingRules) {
                for (int i = 0; i < 36; ++i) {
                    List<IItemTreeItem> candidateItems;
                    ItemStack candidateStack = container.getItemStack(i);
                    if (candidateStack == null || !tree.matches(candidateItems = tree.getItems(((ResourceLocation)Item.field_150901_e.func_177774_c((Object)candidateStack.func_77973_b())).toString(), candidateStack.func_77952_i()), rule.getKeyword())) continue;
                    if (candidateStack.func_77976_d() == 1) {
                        if (replacementStack != null && candidateStack.func_77952_i() <= replacementStack.func_77952_i() || refillBeforeBreak && candidateStack.func_77958_k() - candidateStack.func_77952_i() <= this.config.getIntProperty("autoRefillDamageThreshhold")) continue;
                        replacementStack = candidateStack;
                        replacementStackSlot = i;
                        continue;
                    }
                    if (replacementStack != null && candidateStack.field_77994_a >= replacementStack.field_77994_a) continue;
                    replacementStack = candidateStack;
                    replacementStackSlot = i;
                }
            }
        } else {
            for (int i = 0; i < 36; ++i) {
                ItemStack candidateStack = container.getItemStack(i);
                if (candidateStack == null || !Objects.equals(((ResourceLocation)Item.field_150901_e.func_177774_c((Object)candidateStack.func_77973_b())).toString(), wantedId) || candidateStack.func_77952_i() != wantedDamage) continue;
                replacementStack = candidateStack;
                replacementStackSlot = i;
                break;
            }
        }
        if (replacementStack != null || refillBeforeBreak && container.getSlot(slot).func_75211_c() != null) {
            log.info("Automatic stack replacement.");
            InvTweaks.getInstance().addScheduledTask(new Runnable(){
                private ContainerSectionManager containerMgr;
                private int targetedSlot;
                private int i;
                private String expectedItemId;
                private boolean refillBeforeBreak;

                public Runnable init(int i_, int currentItem, boolean refillBeforeBreak_) throws Exception {
                    this.containerMgr = new ContainerSectionManager(ContainerSection.INVENTORY);
                    this.targetedSlot = currentItem;
                    if (i_ != -1) {
                        this.i = i_;
                        this.expectedItemId = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.containerMgr.getItemStack(this.i).func_77973_b())).toString();
                    } else {
                        this.i = this.containerMgr.getFirstEmptyIndex();
                        this.expectedItemId = null;
                    }
                    this.refillBeforeBreak = refillBeforeBreak_;
                    return this;
                }

                @Override
                public void run() {
                    if (this.i < 0 || this.targetedSlot < 0) {
                        return;
                    }
                    ItemStack stack = this.containerMgr.getItemStack(this.i);
                    if (stack != null && StringUtils.equals((CharSequence)((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString(), (CharSequence)this.expectedItemId) || this.refillBeforeBreak) {
                        if (this.containerMgr.move(this.targetedSlot, this.i) || this.containerMgr.move(this.i, this.targetedSlot)) {
                            if (!InvTweaksHandlerAutoRefill.this.config.getProperty("enableSounds").equals("false")) {
                                InvTweaksHandlerAutoRefill.this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("mob.chicken.plop"), (float)1.0f));
                            }
                            if (this.containerMgr.getItemStack(this.i) != null && this.i >= 27) {
                                for (int j = 0; j < 36; ++j) {
                                    if (this.containerMgr.getItemStack(j) != null) continue;
                                    this.containerMgr.move(this.i, j);
                                    break;
                                }
                            }
                            this.containerMgr.applyChanges();
                        } else {
                            log.warn("Failed to move stack for autoreplace, despite of prior tests.");
                        }
                    }
                }
            }.init(replacementStackSlot, slot, refillBeforeBreak));
        }
    }
}

