/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.gui;

public class GuiSimpleScrollBar
extends avp {
    private int value = 0;
    private int maxValue = 100;
    private int backColour = 0x44FFFFFF;
    private int foreColour = -1;
    private boolean mouseOver = false;
    private boolean dragging = false;
    private int mouseDownValue = 0;
    private int mouseDownY = 0;

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = Math.min(Math.max(value, 0), this.maxValue);
    }

    public void offsetValue(int offset) {
        this.setValue(this.value + offset);
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = Math.max(0, maxValue);
        this.value = Math.min(this.value, this.maxValue);
    }

    public boolean wasMouseOver() {
        return this.mouseOver;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    public void drawScrollBar(int mouseX, int mouseY, float partialTicks, int xPosition, int yPosition, int width, int height, int totalHeight) {
        GuiSimpleScrollBar.a((int)xPosition, (int)yPosition, (int)(xPosition + width), (int)(yPosition + height), (int)this.backColour);
        if (totalHeight > 0) {
            int slideHeight = height - 2;
            float pct = Math.min(1.0f, (float)slideHeight / (float)totalHeight);
            int barHeight = (int)(pct * (float)slideHeight);
            int barTravel = slideHeight - barHeight;
            int barPosition = yPosition + 1 + (this.maxValue > 0 ? (int)((float)this.value / (float)this.maxValue * (float)barTravel) : 0);
            GuiSimpleScrollBar.a((int)(xPosition + 1), (int)barPosition, (int)(xPosition + width - 1), (int)(barPosition + barHeight), (int)this.foreColour);
            this.mouseOver = mouseX > xPosition && mouseX < xPosition + width && mouseY > barPosition && mouseY < barPosition + barHeight;
            this.handleDrag(mouseY, barTravel);
        }
    }

    public void handleDrag(int mouseY, int barTravel) {
        if (this.dragging) {
            float valuePerPixel = (float)this.maxValue / (float)barTravel;
            this.setValue((int)((float)this.mouseDownValue + (float)(mouseY - this.mouseDownY) * valuePerPixel));
        } else {
            this.mouseDownY = mouseY;
            this.mouseDownValue = this.value;
        }
    }
}

