/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mojang.authlib.GameProfile;
import com.mumfrey.liteloader.core.LiteLoaderEventBroker;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public abstract class Proxy {
    private static LiteLoaderEventBroker<?, ?> broker;

    protected Proxy() {
    }

    protected static void onStartupComplete() {
        broker = LiteLoaderEventBroker.broker;
        if (broker == null) {
            throw new RuntimeException("LiteLoader failed to start up properly. The game is in an unstable state and must shut down now. Check the developer log for startup errors");
        }
    }

    public static void onInitializePlayerConnection(lx source, ek netManager, lf player) {
        broker.onInitializePlayerConnection(source, netManager, player);
    }

    public static void onPlayerLogin(lx source, lf player) {
        broker.onPlayerLogin(source, player);
    }

    public static void onPlayerLogout(lx source, lf player) {
        broker.onPlayerLogout(source, player);
    }

    public static void onSpawnPlayer(CallbackInfoReturnable<lf> cir, lx source, GameProfile profile) {
        broker.onSpawnPlayer(source, cir.getReturnValue(), profile);
    }

    public static void onRespawnPlayer(CallbackInfoReturnable<lf> cir, lx source, lf oldPlayer, int dimension, boolean won) {
        broker.onRespawnPlayer(source, cir.getReturnValue(), oldPlayer, dimension, won);
    }

    public static void onServerTick(MinecraftServer mcServer) {
        broker.onServerTick(mcServer);
    }

    public static void onPlaceBlock(CallbackInfo ci, lm netHandler, ja packet) {
        if (!broker.onPlaceBlock(netHandler, netHandler.b, packet.a(), cq.a((int)packet.b()))) {
            ci.cancel();
        }
    }

    public static void onClickedAir(CallbackInfo ci, lm netHandler, iy packet) {
        if (!broker.onClickedAir(netHandler)) {
            ci.cancel();
        }
    }

    public static void onPlayerDigging(CallbackInfo ci, lm netHandler, ir packet) {
        if (packet.c() == ir.a.a && !broker.onPlayerDigging(netHandler, packet.a(), netHandler.b)) {
            ci.cancel();
        }
    }

    public static void onUseItem(CallbackInfoReturnable<Boolean> ci, wn player, adm world, zx itemStack, cj pos, cq side, float par8, float par9, float par10) {
        if (!(player instanceof lf)) {
            return;
        }
        if (!broker.onUseItem(pos, side, (lf)player)) {
            ci.setReturnValue(false);
        }
    }

    public static void onBlockClicked(CallbackInfo ci, lg manager, cj pos, cq side) {
        if (!broker.onBlockClicked(pos, side, manager)) {
            ci.cancel();
        }
    }

    public static void onPlayerMoved(CallbackInfo ci, lm netHandler, ip packet, le world, double oldPosX, double oldPosY, double oldPosZ) {
        if (!broker.onPlayerMove(netHandler, packet, netHandler.b, world)) {
            ci.cancel();
        }
    }

    public static void onPlayerMoved(CallbackInfo ci, lm netHandler, ip packet, le world, double oldPosX, double oldPosY, double oldPosZ, double deltaMoveSq, double deltaX, double deltaY, double deltaZ) {
        if (!broker.onPlayerMove(netHandler, packet, netHandler.b, world)) {
            ci.cancel();
        }
    }
}

