/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core.api;

import com.mumfrey.liteloader.api.EnumeratorModule;
import com.mumfrey.liteloader.common.LoadingProgress;
import com.mumfrey.liteloader.core.api.LoadableModClassPath;
import com.mumfrey.liteloader.interfaces.LoadableMod;
import com.mumfrey.liteloader.interfaces.ModularEnumerator;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class EnumeratorModuleClassPath
implements EnumeratorModule {
    private final String[] classPathEntries;
    private final List<LoadableMod<File>> loadableMods = new ArrayList<LoadableMod<File>>();
    private boolean loadTweaks;

    public EnumeratorModuleClassPath() {
        this.classPathEntries = this.readClassPath();
    }

    public String toString() {
        return "<Java Class Path>";
    }

    @Override
    public void init(LoaderEnvironment environment, LoaderProperties properties) {
        this.loadTweaks = properties.loadTweaksEnabled();
    }

    @Override
    public void writeSettings(LoaderEnvironment environment, LoaderProperties properties) {
    }

    private String[] readClassPath() {
        LiteLoaderLogger.info("Enumerating class path...", new Object[0]);
        String classPath = System.getProperty("java.class.path");
        String classPathSeparator = System.getProperty("path.separator");
        String[] classPathEntries = classPath.split(classPathSeparator);
        LiteLoaderLogger.info("Class path separator=\"%s\"", classPathSeparator);
        LiteLoaderLogger.info("Class path entries=(\n   classpathEntry=%s\n)", classPath.replace(classPathSeparator, "\n   classpathEntry="));
        return classPathEntries;
    }

    @Override
    public void enumerate(ModularEnumerator enumerator, String profile) {
        if (this.loadTweaks) {
            LiteLoaderLogger.info("Discovering tweaks on class path...", new Object[0]);
            for (String classPathPart : this.classPathEntries) {
                try {
                    File packagePath = new File(classPathPart);
                    if (!packagePath.exists()) continue;
                    LoadableModClassPath classPathMod = new LoadableModClassPath(packagePath);
                    if (enumerator.registerModContainer(classPathMod)) {
                        this.loadableMods.add(classPathMod);
                        if (!classPathMod.requiresPreInitInjection()) continue;
                        enumerator.registerTweakContainer(classPathMod);
                        continue;
                    }
                    LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Mod %s is disabled or missing a required dependency, not injecting tranformers", classPathMod.getIdentifier());
                }
                catch (Throwable th) {
                    LiteLoaderLogger.warning(th, "Error encountered whilst inspecting %s", classPathPart);
                }
            }
        }
    }

    @Override
    public void injectIntoClassLoader(ModularEnumerator enumerator, LaunchClassLoader classLoader) {
    }

    @Override
    public void registerMods(ModularEnumerator enumerator, LaunchClassLoader classLoader) {
        LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Discovering mods on class path...", new Object[0]);
        LoadingProgress.incTotalLiteLoaderProgress(this.loadableMods.size());
        for (LoadableMod<File> classPathMod : this.loadableMods) {
            LiteLoaderLogger.info("Searching %s...", classPathMod);
            LoadingProgress.incLiteLoaderProgress("Searching for mods in " + classPathMod.getModName() + "...");
            try {
                enumerator.registerModsFrom(classPathMod, true);
            }
            catch (Exception ex) {
                LiteLoaderLogger.warning(ex, "Error encountered whilst searching in %s...", classPathMod);
            }
        }
    }
}

