/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers.event;

import com.mumfrey.liteloader.core.event.Cancellable;
import com.mumfrey.liteloader.core.event.EventCancellationException;
import com.mumfrey.liteloader.transformers.event.ReturnEventInfo;
import org.objectweb.asm.Type;

public class EventInfo<S>
implements Cancellable {
    protected static final String STRING = "Ljava/lang/String;";
    protected static final String OBJECT = "Ljava/lang/Object;";
    private final String name;
    private final S source;
    private final boolean cancellable;
    private boolean cancelled;

    public EventInfo(String name, S source, boolean cancellable) {
        this.name = name;
        this.source = source;
        this.cancellable = cancellable;
    }

    public S getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    protected String getSourceClass() {
        return this.source != null ? this.source.getClass().getSimpleName() : null;
    }

    public String toString() {
        return String.format("EventInfo(TYPE=%s,NAME=%s,SOURCE=%s,CANCELLABLE=%s)", this.getClass().getSimpleName(), this.name, this.getSourceClass(), this.cancellable);
    }

    @Override
    public final boolean isCancellable() {
        return this.cancellable;
    }

    @Override
    public final boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void cancel() throws EventCancellationException {
        if (!this.cancellable) {
            throw new EventCancellationException(String.format("The event %s is not cancellable.", this.name));
        }
        this.cancelled = true;
    }

    protected static String getEventInfoClassName() {
        return EventInfo.class.getName();
    }

    protected static String getEventInfoClassName(Type returnType) {
        return returnType.equals((Object)Type.VOID_TYPE) ? EventInfo.class.getName() : ReturnEventInfo.class.getName();
    }

    public static String getConstructorDescriptor(Type returnType) {
        if (returnType.equals((Object)Type.VOID_TYPE)) {
            return EventInfo.getConstructorDescriptor();
        }
        if (returnType.getSort() == 10) {
            return String.format("(%s%sZ%s)V", STRING, OBJECT, OBJECT);
        }
        return String.format("(%s%sZ%s)V", STRING, OBJECT, returnType.getDescriptor());
    }

    public static String getConstructorDescriptor() {
        return String.format("(%s%sZ)V", STRING, OBJECT);
    }

    public static String getIsCancelledMethodName() {
        return "isCancelled";
    }

    public static String getIsCancelledMethodSig() {
        return "()Z";
    }
}

