/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers.event;

import com.mumfrey.liteloader.transformers.ObfProvider;
import com.mumfrey.liteloader.transformers.event.Event;
import com.mumfrey.liteloader.transformers.event.EventTransformer;
import com.mumfrey.liteloader.transformers.event.InjectionPoint;
import com.mumfrey.liteloader.transformers.event.MethodInfo;
import net.minecraft.launchwrapper.IClassTransformer;

public abstract class EventInjectionTransformer
implements IClassTransformer {
    public EventInjectionTransformer() {
        try {
            this.addEvents();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        return basicClass;
    }

    protected abstract void addEvents();

    protected final Event addEvent(String eventName, MethodInfo targetMethod, InjectionPoint injectionPoint) {
        return this.addEvent(Event.getOrCreate(eventName), targetMethod, injectionPoint);
    }

    protected final Event addEvent(Event event, MethodInfo targetMethod, InjectionPoint injectionPoint) {
        if (event == null) {
            throw new IllegalArgumentException("Event cannot be null!");
        }
        if (injectionPoint == null) {
            throw new IllegalArgumentException("Injection point cannot be null for event " + event.getName());
        }
        if ("true".equals(System.getProperty("mcpenv"))) {
            EventTransformer.addEvent(event, targetMethod.owner, targetMethod.sig, injectionPoint);
        } else {
            EventTransformer.addEvent(event, targetMethod.owner, targetMethod.sigSrg, injectionPoint);
            EventTransformer.addEvent(event, targetMethod.ownerObf, targetMethod.sigObf, injectionPoint);
        }
        event.addPendingInjection(targetMethod);
        return event;
    }

    protected final void addAccessor(String interfaceName) {
        EventTransformer.addAccessor(interfaceName);
    }

    protected final void addAccessor(String interfaceName, ObfProvider obfProvider) {
        EventTransformer.addAccessor(interfaceName, obfProvider);
    }
}

