/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers.event;

import com.mumfrey.liteloader.core.event.EventCancellationException;
import com.mumfrey.liteloader.transformers.event.EventInfo;
import org.objectweb.asm.Type;

public class ReturnEventInfo<S, R>
extends EventInfo<S> {
    private R returnValue;

    public ReturnEventInfo(String name, S source, boolean cancellable) {
        super(name, source, cancellable);
        this.returnValue = null;
    }

    public ReturnEventInfo(String name, S source, boolean cancellable, R returnValue) {
        super(name, source, cancellable);
        this.returnValue = returnValue;
    }

    public ReturnEventInfo(String name, S source, boolean cancellable, byte returnValue) {
        super(name, source, cancellable);
        this.returnValue = returnValue;
    }

    public ReturnEventInfo(String name, S source, boolean cancellable, char returnValue) {
        super(name, source, cancellable);
        this.returnValue = Character.valueOf(returnValue);
    }

    public ReturnEventInfo(String name, S source, boolean cancellable, double returnValue) {
        super(name, source, cancellable);
        this.returnValue = returnValue;
    }

    public ReturnEventInfo(String name, S source, boolean cancellable, float returnValue) {
        super(name, source, cancellable);
        this.returnValue = Float.valueOf(returnValue);
    }

    public ReturnEventInfo(String name, S source, boolean cancellable, int returnValue) {
        super(name, source, cancellable);
        this.returnValue = returnValue;
    }

    public ReturnEventInfo(String name, S source, boolean cancellable, long returnValue) {
        super(name, source, cancellable);
        this.returnValue = returnValue;
    }

    public ReturnEventInfo(String name, S source, boolean cancellable, short returnValue) {
        super(name, source, cancellable);
        this.returnValue = returnValue;
    }

    public ReturnEventInfo(String name, S source, boolean cancellable, boolean returnValue) {
        super(name, source, cancellable);
        this.returnValue = returnValue;
    }

    public void setReturnValue(R returnValue) throws EventCancellationException {
        super.cancel();
        this.returnValue = returnValue;
    }

    public R getReturnValue() {
        return this.returnValue;
    }

    public byte getReturnValueB() {
        if (this.returnValue == null) {
            return 0;
        }
        return (Byte)this.returnValue;
    }

    public char getReturnValueC() {
        if (this.returnValue == null) {
            return '\u0000';
        }
        return ((Character)this.returnValue).charValue();
    }

    public double getReturnValueD() {
        if (this.returnValue == null) {
            return 0.0;
        }
        return (Double)this.returnValue;
    }

    public float getReturnValueF() {
        if (this.returnValue == null) {
            return 0.0f;
        }
        return ((Float)this.returnValue).floatValue();
    }

    public int getReturnValueI() {
        if (this.returnValue == null) {
            return 0;
        }
        return (Integer)this.returnValue;
    }

    public long getReturnValueJ() {
        if (this.returnValue == null) {
            return 0L;
        }
        return (Long)this.returnValue;
    }

    public short getReturnValueS() {
        if (this.returnValue == null) {
            return 0;
        }
        return (Short)this.returnValue;
    }

    public boolean getReturnValueZ() {
        if (this.returnValue == null) {
            return false;
        }
        return (Boolean)this.returnValue;
    }

    public static String getReturnAccessor(Type returnType) {
        if (returnType.getSort() == 10) {
            return "getReturnValue";
        }
        return String.format("getReturnValue%s", returnType.getDescriptor());
    }

    public static String getReturnDescriptor(Type returnType) {
        if (returnType.getSort() == 10) {
            return String.format("()%s", "Ljava/lang/Object;");
        }
        return String.format("()%s", returnType.getDescriptor());
    }
}

