/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers.event.json;

import com.google.gson.annotations.SerializedName;
import com.mumfrey.liteloader.core.runtime.Obf;
import com.mumfrey.liteloader.transformers.event.MethodInfo;
import com.mumfrey.liteloader.transformers.event.json.InvalidEventJsonException;
import com.mumfrey.liteloader.transformers.event.json.JsonObfuscationTable;
import java.io.Serializable;
import java.util.UUID;

public class JsonDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @SerializedName(value="id")
    private String key;
    @SerializedName(value="owner")
    private String owner;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="return")
    private String returnType;
    @SerializedName(value="args")
    private String[] argumentTypes;

    public String getKey() {
        if (this.key == null) {
            this.key = "UserDescriptor" + UUID.randomUUID().toString();
        }
        return this.key;
    }

    public MethodInfo parse(JsonObfuscationTable obfTable) {
        Object[] args;
        if (this.owner == null || this.name == null) {
            throw new InvalidEventJsonException("Method descriptor was invalid, must specify owner and name!");
        }
        Obf owner = obfTable.parseClass(this.owner);
        Obf name = obfTable.parseMethod(this.name);
        if (this.argumentTypes == null && this.returnType == null) {
            return new MethodInfo(owner, name);
        }
        Object returnType = obfTable.parseType(this.returnType == null ? "VOID" : this.returnType);
        Object[] objectArray = args = this.argumentTypes != null ? new Object[this.argumentTypes.length] : new Object[]{};
        if (this.argumentTypes != null) {
            for (int arg = 0; arg < this.argumentTypes.length; ++arg) {
                args[arg] = obfTable.parseType(this.argumentTypes[arg]);
            }
        }
        return new MethodInfo(owner, name, returnType, args);
    }
}

