/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.InnerClassNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.MixinException;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.InterfaceInfo;
import org.spongepowered.asm.mixin.transformer.InterfaceMixinPreProcessor;
import org.spongepowered.asm.mixin.transformer.InvalidMixinException;
import org.spongepowered.asm.mixin.transformer.MixinClassNode;
import org.spongepowered.asm.mixin.transformer.MixinConfig;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessor;
import org.spongepowered.asm.mixin.transformer.MixinReloadException;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.TreeInfo;
import org.spongepowered.asm.util.ASMHelper;

class MixinInfo
extends TreeInfo
implements Comparable<MixinInfo>,
IMixinInfo {
    static int mixinOrder = 0;
    static final Set<String> invalidClasses = MixinInfo.$getInvalidClassesSet();
    private final transient Logger logger = LogManager.getLogger((String)"mixin");
    private final transient MixinConfig parent;
    private final String name;
    private final String className;
    private final int priority;
    private final List<ClassInfo> targetClasses;
    private final List<String> targetClassNames;
    private final transient int order = mixinOrder++;
    private final transient IMixinConfigPlugin plugin;
    private final transient MixinEnvironment.Phase phase;
    private final transient ClassInfo info;
    private final transient boolean isInterfaceMixin;
    private transient ValidationState uninitialisedState;
    private transient ValidationState validationState;

    MixinInfo(MixinConfig parent, String mixinName, boolean runTransformers, IMixinConfigPlugin plugin, boolean suppressPlugin) throws ClassNotFoundException {
        this.parent = parent;
        this.name = mixinName;
        this.className = parent.getMixinPackage() + mixinName;
        this.plugin = plugin;
        this.phase = MixinEnvironment.getCurrentEnvironment().getPhase();
        byte[] mixinBytes = this.loadMixinClass(this.className, runTransformers);
        this.uninitialisedState = new ValidationState(mixinBytes);
        this.info = this.uninitialisedState.classInfo;
        this.isInterfaceMixin = this.info.isInterface();
        ClassNode classNode = this.uninitialisedState.getClassNode(0);
        this.priority = this.readPriority(classNode);
        this.targetClasses = this.readTargetClasses(classNode, suppressPlugin);
        this.targetClassNames = Collections.unmodifiableList(Lists.transform(this.targetClasses, (Function)Functions.toStringFunction()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validate() {
        try {
            ClassNode classNode = this.uninitialisedState.classNode;
            this.uninitialisedState.detachedSuper = this.validateTargetClasses(classNode);
            this.validateMixin(this.uninitialisedState);
            this.readImplementations(this.uninitialisedState);
            this.readInnerClasses(this.uninitialisedState);
            if (this.uninitialisedState instanceof ReloadedState) {
                ((ReloadedState)this.uninitialisedState).validateChanges();
            } else {
                this.createPreProcessor(classNode).prepare();
            }
            this.uninitialisedState.classNode = null;
            this.validationState = this.uninitialisedState;
        }
        finally {
            this.uninitialisedState = null;
        }
    }

    protected List<ClassInfo> readTargetClasses(ClassNode classNode, boolean suppressPlugin) {
        AnnotationNode mixin = ASMHelper.getInvisibleAnnotation(classNode, Mixin.class);
        if (mixin == null) {
            throw new InvalidMixinException(this, String.format("The mixin '%s' is missing an @Mixin annotation", this.className));
        }
        ArrayList<ClassInfo> targets = new ArrayList<ClassInfo>();
        List publicTargets = (List)ASMHelper.getAnnotationValue(mixin, "value");
        List privateTargets = (List)ASMHelper.getAnnotationValue(mixin, "targets");
        if (publicTargets != null) {
            this.readTargets(targets, Lists.transform((List)publicTargets, (Function)new Function<Type, String>(){

                public String apply(Type input) {
                    return input.getClassName();
                }
            }), suppressPlugin, false);
        }
        if (privateTargets != null) {
            this.readTargets(targets, Lists.transform((List)privateTargets, (Function)new Function<String, String>(){

                public String apply(String input) {
                    return MixinInfo.this.getParent().remapClassName(MixinInfo.this.getClassRef(), input);
                }
            }), suppressPlugin, true);
        }
        return targets;
    }

    private void readTargets(List<ClassInfo> outTargets, List<String> inTargets, boolean suppressPlugin, boolean checkPublic) {
        for (String targetClassName : inTargets) {
            targetClassName = targetClassName.replace('/', '.');
            if (this.plugin != null && !suppressPlugin && !this.plugin.shouldApplyMixin(targetClassName, this.className)) continue;
            ClassInfo targetInfo = ClassInfo.forName(targetClassName);
            this.checkTarget(targetClassName, targetInfo, checkPublic);
            if (outTargets.contains(targetInfo)) continue;
            outTargets.add(targetInfo);
            targetInfo.addMixin(this);
        }
    }

    private void checkTarget(String targetClassName, ClassInfo targetInfo, boolean checkPublic) throws InvalidMixinException {
        if (targetInfo == null) {
            throw new MixinException("@Mixin target " + targetClassName + " was not found " + this);
        }
        boolean targetIsInterface = targetInfo.isInterface();
        if (targetIsInterface != this.isInterfaceMixin) {
            String not = targetIsInterface ? "" : "not ";
            throw new InvalidMixinException(this, "@Mixin target type mismatch: " + targetClassName + " is " + not + "an interface in " + this);
        }
        if (checkPublic && targetInfo.isPublic()) {
            throw new InvalidMixinException(this, "@Mixin target " + targetClassName + " is public in " + this + " and must be specified in value");
        }
    }

    protected int readPriority(ClassNode classNode) {
        AnnotationNode mixin = ASMHelper.getInvisibleAnnotation(classNode, Mixin.class);
        if (mixin == null) {
            throw new InvalidMixinException(this, String.format("The mixin '%s' is missing an @Mixin annotation", this.className));
        }
        Integer priority = (Integer)ASMHelper.getAnnotationValue(mixin, "priority");
        return priority == null ? this.parent.getDefaultMixinPriority() : priority.intValue();
    }

    private boolean validateTargetClasses(ClassNode classNode) {
        if (this.isInterfaceMixin) {
            return this.validateInterfaceMixinTargets(classNode);
        }
        return this.validateClassMixinTargets(classNode);
    }

    private boolean validateInterfaceMixinTargets(ClassNode classNode) {
        if (!"java/lang/Object".equals(classNode.superName)) {
            throw new InvalidMixinException(this, "Super class of " + this + " is invalid, found " + classNode.superName.replace('/', '.'));
        }
        return false;
    }

    private boolean validateClassMixinTargets(ClassNode classNode) {
        boolean detached = false;
        for (ClassInfo targetClass : this.targetClasses) {
            if (classNode.superName.equals(targetClass.getSuperName())) continue;
            if (!targetClass.hasSuperClass(classNode.superName, ClassInfo.Traversal.SUPER)) {
                ClassInfo superClass = ClassInfo.forName(classNode.superName);
                if (superClass.isMixin()) {
                    for (ClassInfo superTarget : superClass.getTargets()) {
                        if (!this.targetClasses.contains(superTarget)) continue;
                        throw new InvalidMixinException(this, "Illegal hierarchy detected. Derived mixin " + this + " targets the same class " + superTarget.getClassName() + " as its superclass " + superClass.getClassName());
                    }
                }
                throw new InvalidMixinException(this, "Super class '" + classNode.superName.replace('/', '.') + "' of " + this.name + " was not found in the hierarchy of target class '" + targetClass + "'");
            }
            detached = true;
        }
        return detached;
    }

    private void validateMixin(ValidationState state) {
        this.validateType();
        this.validateInner(state);
        this.validateClassVersion(state);
        this.validateRemappables(state);
    }

    private void validateType() {
        if (this.isInterfaceMixin && !MixinEnvironment.getCompatibilityLevel().supportsMethodsInInterfaces()) {
            throw new InvalidMixinException(this, "Interface mixin not supported in current enviromnment");
        }
    }

    private void validateInner(ValidationState state) {
        if (!state.classInfo.isProbablyStatic()) {
            throw new InvalidMixinException(this, "Inner class mixin must be declared static");
        }
    }

    private void validateClassVersion(ValidationState state) {
        if (state.classNode.version > MixinEnvironment.getCompatibilityLevel().classVersion()) {
            String helpText = ".";
            for (MixinEnvironment.CompatibilityLevel level : MixinEnvironment.CompatibilityLevel.values()) {
                if (level.classVersion() < state.classNode.version) continue;
                helpText = String.format(". Mixin requires compatibility level %s or above.", level.name());
            }
            throw new InvalidMixinException(this, "Unsupported mixin class version " + state.classNode.version + helpText);
        }
    }

    private void validateRemappables(ValidationState state) {
        if (this.targetClasses.size() > 1) {
            for (FieldNode field : state.classNode.fields) {
                this.checkRemappable(Shadow.class, field.name, ASMHelper.getVisibleAnnotation(field, Shadow.class));
            }
            for (MethodNode method : state.classNode.methods) {
                this.checkRemappable(Shadow.class, method.name, ASMHelper.getVisibleAnnotation(method, Shadow.class));
                AnnotationNode overwrite = ASMHelper.getVisibleAnnotation(method, Overwrite.class);
                if (overwrite == null || (method.access & 8) != 0 && (method.access & 1) != 0) continue;
                throw new InvalidMixinException(this, "Found @Overwrite annotation on " + method.name + " in " + this);
            }
        }
    }

    private void checkRemappable(Class<Shadow> annotationClass, String name, AnnotationNode annotation) {
        if (annotation != null && ASMHelper.getAnnotationValue(annotation, "remap", Boolean.TRUE).booleanValue()) {
            throw new InvalidMixinException(this, "Found a remappable @" + annotationClass.getSimpleName() + " annotation on " + name + " in " + this);
        }
    }

    private void readImplementations(ValidationState state) {
        state.interfaces.addAll(state.classNode.interfaces);
        AnnotationNode implementsAnnotation = ASMHelper.getInvisibleAnnotation(state.classNode, Implements.class);
        if (implementsAnnotation == null) {
            return;
        }
        List interfaces = (List)ASMHelper.getAnnotationValue(implementsAnnotation);
        if (interfaces == null) {
            return;
        }
        for (AnnotationNode interfaceNode : interfaces) {
            InterfaceInfo interfaceInfo = InterfaceInfo.fromAnnotation(this, interfaceNode);
            state.softImplements.add(interfaceInfo);
            state.interfaces.add(interfaceInfo.getInternalName());
            if (state instanceof ReloadedState) continue;
            state.classInfo.addInterface(interfaceInfo.getInternalName());
        }
    }

    private void readInnerClasses(ValidationState state) {
        for (InnerClassNode inner : state.classNode.innerClasses) {
            ClassInfo innerClass = ClassInfo.forName(inner.name);
            if (!innerClass.isSynthetic() || !innerClass.isProbablyStatic()) continue;
            if (inner.outerName != null && inner.outerName.equals(state.classInfo.getName()) || inner.name.startsWith(state.classNode.name + "$")) {
                state.syntheticInnerClasses.add(inner.name);
                continue;
            }
            throw new InvalidMixinException(this, "Unhandled synthetic inner class found: " + inner.name);
        }
    }

    private ValidationState getCurrentState() {
        if (this.validationState == null) {
            return this.uninitialisedState;
        }
        return this.validationState;
    }

    ClassInfo getClassInfo() {
        return this.info;
    }

    @Override
    public IMixinConfig getConfig() {
        return this.parent;
    }

    public MixinConfig getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getClassRef() {
        return this.getClassInfo().getName();
    }

    @Override
    public byte[] getClassBytes() {
        return this.getCurrentState().mixinBytes;
    }

    @Override
    public boolean isDetachedSuper() {
        return this.getCurrentState().detachedSuper;
    }

    public Level getLoggingLevel() {
        return this.parent.getLoggingLevel();
    }

    @Override
    public MixinEnvironment.Phase getPhase() {
        return this.phase;
    }

    @Override
    public boolean isInterfaceMixin() {
        return this.isInterfaceMixin;
    }

    @Override
    public ClassNode getClassNode(int flags) {
        return this.getCurrentState().getClassNode(flags);
    }

    @Override
    public List<String> getTargetClasses() {
        return this.targetClassNames;
    }

    List<InterfaceInfo> getSoftImplements() {
        return Collections.unmodifiableList(this.getCurrentState().softImplements);
    }

    public Set<String> getSyntheticInnerClasses() {
        return Collections.unmodifiableSet(this.getCurrentState().syntheticInnerClasses);
    }

    public List<ClassInfo> getTargets() {
        return Collections.unmodifiableList(this.getTargets0());
    }

    protected List<ClassInfo> getTargets0() {
        return this.targetClasses;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public Set<String> getInterfaces() {
        return this.getCurrentState().interfaces;
    }

    public MixinTargetContext createContextFor(TargetClassContext target) {
        ClassNode classNode = this.getClassNode(8);
        return this.createPreProcessor(classNode).prepare().createContextFor(target);
    }

    private MixinPreProcessor createPreProcessor(ClassNode classNode) {
        if (this.isInterfaceMixin) {
            return new InterfaceMixinPreProcessor(this, classNode);
        }
        return new MixinPreProcessor(this, classNode);
    }

    private byte[] loadMixinClass(String mixinClassName, boolean runTransformers) throws ClassNotFoundException {
        byte[] mixinBytes = null;
        try {
            mixinBytes = TreeInfo.loadClass(mixinClassName, runTransformers);
        }
        catch (ClassNotFoundException ex) {
            throw new ClassNotFoundException(String.format("The specified mixin '%s' was not found", mixinClassName));
        }
        catch (IOException ex) {
            this.logger.warn("Failed to load mixin %s, the specified mixin will not be applied", new Object[]{mixinClassName});
            throw new InvalidMixinException(this, "An error was encountered whilst loading the mixin class", (Throwable)ex);
        }
        if (invalidClasses != null) {
            invalidClasses.add(mixinClassName);
        }
        return mixinBytes;
    }

    void reloadMixin(byte[] mixinBytes) {
        if (this.uninitialisedState != null) {
            throw new IllegalStateException("Cannot reload mixin while it is initialising");
        }
        this.uninitialisedState = new ReloadedState(this.validationState, mixinBytes);
        this.validate();
    }

    @Override
    public int compareTo(MixinInfo other) {
        if (other == null) {
            return 0;
        }
        if (other.priority == this.priority) {
            return this.order - other.order;
        }
        return this.priority - other.priority;
    }

    public void preApply(String transformedName, ClassNode targetClass) {
        if (this.plugin != null) {
            this.plugin.preApply(transformedName, targetClass, this.className, this);
        }
    }

    public void postApply(String transformedName, ClassNode targetClass) {
        if (this.plugin != null) {
            this.plugin.postApply(transformedName, targetClass, this.className, this);
        }
        this.parent.postApply(transformedName, targetClass);
    }

    public String toString() {
        return String.format("%s:%s", this.parent.getName(), this.name);
    }

    private static Set<String> $getInvalidClassesSet() {
        try {
            Field invalidClasses = LaunchClassLoader.class.getDeclaredField("invalidClasses");
            invalidClasses.setAccessible(true);
            return (Set)invalidClasses.get(Launch.classLoader);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private class ReloadedState
    extends ValidationState {
        private final ValidationState previous;

        ReloadedState(ValidationState previous, byte[] mixinBytes) {
            super(mixinBytes, previous.classInfo);
            this.previous = previous;
        }

        void validateChanges() {
            if (!this.syntheticInnerClasses.equals(this.previous.syntheticInnerClasses)) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change inner classes");
            }
            if (!this.interfaces.equals(this.previous.interfaces)) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change interfaces");
            }
            if (!new HashSet(this.softImplements).equals(new HashSet<InterfaceInfo>(this.previous.softImplements))) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change soft interfaces");
            }
            List<ClassInfo> targets = MixinInfo.this.readTargetClasses(this.classNode, true);
            if (!new HashSet<ClassInfo>(targets).equals(new HashSet<ClassInfo>(MixinInfo.this.getTargets0()))) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change target classes");
            }
            int priority = MixinInfo.this.readPriority(this.classNode);
            if (priority != MixinInfo.this.getPriority()) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change mixin priority");
            }
        }
    }

    private class ValidationState {
        byte[] mixinBytes;
        final Set<String> interfaces = new HashSet<String>();
        final List<InterfaceInfo> softImplements = new ArrayList<InterfaceInfo>();
        final Set<String> syntheticInnerClasses = new HashSet<String>();
        final ClassInfo classInfo;
        boolean detachedSuper;
        ClassNode classNode;

        ValidationState(byte[] mixinBytes, ClassInfo classInfo) {
            this.mixinBytes = mixinBytes;
            this.classNode = this.getClassNode(0);
            this.classInfo = classInfo;
        }

        ValidationState(byte[] mixinBytes) {
            this.mixinBytes = mixinBytes;
            this.classNode = this.getClassNode(0);
            this.classInfo = ClassInfo.fromClassNode(this.classNode);
        }

        ClassNode getClassNode(int flags) {
            MixinClassNode classNode = new MixinClassNode(MixinInfo.this);
            ClassReader classReader = new ClassReader(this.mixinBytes);
            classReader.accept(classNode, flags);
            return classNode;
        }
    }
}

