/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.obfuscation;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import joptsimple.internal.Strings;
import org.spongepowered.asm.mixin.MixinException;
import org.spongepowered.asm.obfuscation.SrgField;
import org.spongepowered.asm.obfuscation.SrgMethod;

public class SrgContainer {
    private final BiMap<String, String> packageMap = HashBiMap.create();
    private final BiMap<String, String> classMap = HashBiMap.create();
    private final BiMap<SrgField, SrgField> fieldMap = HashBiMap.create();
    private final BiMap<SrgMethod, SrgMethod> methodMap = HashBiMap.create();

    public void readSrg(File srg) throws IOException {
        for (String line : Files.readLines((File)srg, (Charset)Charset.defaultCharset())) {
            if (Strings.isNullOrEmpty((String)line) || line.startsWith("#")) continue;
            String type = line.substring(0, 2);
            String[] args = line.substring(4).split(" ");
            if (type.equals("PK")) {
                this.packageMap.forcePut((Object)args[0], (Object)args[1]);
                continue;
            }
            if (type.equals("CL")) {
                this.classMap.forcePut((Object)args[0], (Object)args[1]);
                continue;
            }
            if (type.equals("FD")) {
                this.fieldMap.forcePut((Object)new SrgField(args[0]), (Object)new SrgField(args[1]));
                continue;
            }
            if (type.equals("MD")) {
                this.methodMap.forcePut((Object)new SrgMethod(args[0], args[1]), (Object)new SrgMethod(args[2], args[3]));
                continue;
            }
            throw new MixinException("Invalid SRG file: " + srg);
        }
    }

    public SrgMethod getMethodMapping(SrgMethod methodName) {
        return (SrgMethod)this.methodMap.get((Object)methodName);
    }

    public SrgField getFieldMapping(SrgField fieldName) {
        return (SrgField)this.fieldMap.get((Object)fieldName);
    }

    public String getClassMapping(String className) {
        return (String)this.classMap.get((Object)className);
    }

    public String getPackageMapping(String packageName) {
        return (String)this.packageMap.get((Object)packageName);
    }
}

