/*
 * Decompiled with CFR 0.152.
 */
package com.huaji.LH_Lshen.huajimod.potion;

import com.huaji.LH_Lshen.huajimod.common.ConfigLoader;
import com.huaji.LH_Lshen.huajimod.potion.PotionHuaji;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.potion.Potion;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class PotionLoader {
    public static Potion potionHuaji;

    public PotionLoader(FMLPreInitializationEvent event) {
        if (PotionLoader.expandPotionTypes()) {
            int p = ConfigLoader.potionHuajiId;
            if (p > 0 && p < 256 && Potion.field_76425_a[p] == null) {
                potionHuaji = new PotionHuaji();
            } else {
                event.getModLog().error("Duplicate or illegal potion id: {}, the registry of class '{}' will be skipped. ", new Object[]{p, PotionHuaji.class.getName()});
            }
        } else {
            event.getModLog().error("Find error while resizing potionTypes, the registry of potions will be skipped. ");
        }
    }

    public static boolean expandPotionTypes() {
        for (Field field : Potion.class.getDeclaredFields()) {
            field.setAccessible(true);
            if (!Potion.class.equals(field.getType().getComponentType())) continue;
            try {
                Field fieldmodifiers = Field.class.getDeclaredField("modifiers");
                fieldmodifiers.setAccessible(true);
                fieldmodifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                Potion[] potionTypes = (Potion[])field.get(null);
                field.set(null, Arrays.copyOf(potionTypes, 256));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

