/*
 * Decompiled with CFR 0.152.
 */
package clover.common;

import clover.MagicClover;
import clover.common.Registry;
import java.io.File;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public class Config {
    public static Configuration config;
    public static int dropChance;
    public static int creeperChance;
    private static final String[] defaultBanned;
    private static final String[] defaultWhitelisted;
    private static final String[] defaultRare;
    private static final Pattern digitsOnly;

    public static void init(File file) {
        if (config == null) {
            config = new Configuration(file);
            Config.load();
        }
    }

    public static void load() {
        Property chanceToDrop = config.get("general", "Chance to drop from grass", 6);
        chanceToDrop.comment = "Chance to drop clover from grass (10 is vanilla seeds chance).\nCan be set to 0 for no drop.";
        dropChance = chanceToDrop.getInt();
        Property chanceForCreeper = config.get("general", "Chance to spawn creeper", 2);
        chanceForCreeper.comment = "Chance to spawn creeper from clover (in range 0-100)";
        creeperChance = chanceForCreeper.getInt();
        Property rare = config.get("general", "Rare Items", defaultRare);
        rare.comment = "These items will rarely drop from clover.\nAccepts item names only (like minecraft:nether_star).\nSupports wildcards (*).";
        if (rare.isList()) {
            String[] items;
            for (String s : items = rare.getStringList()) {
                if (digitsOnly.matcher(s).matches()) {
                    int id = Integer.parseInt(s);
                    MagicClover.LOGGER.log(Level.WARN, String.format("MagicClover: Item ids are not supported (%s).", id));
                    continue;
                }
                Registry.registerRareItem(s);
            }
        }
        Property banned = config.get("general", "Banned Items", defaultBanned);
        banned.comment = "These items will not drop from clover.\nAccepts item names only (like minecraft:stone or thaumcraft:amber).\nSupports wildcards (*).";
        if (banned.isList()) {
            String[] items;
            for (String s : items = banned.getStringList()) {
                if (digitsOnly.matcher(s).matches()) {
                    int id = Integer.parseInt(s);
                    MagicClover.LOGGER.log(Level.WARN, String.format("MagicClover: Item ids are not supported (%s)!", id));
                    continue;
                }
                Registry.registerBannedItem(s);
            }
        }
        Property whitelist = config.get("general", "Item Whitelist", defaultWhitelisted);
        whitelist.comment = "If not empty, these items will be the only ones that drop from clover.\nFormatted like other lists in this config.\nAccepts item names only (like minecraft:dirt or buildcraft:pipeWire).\nSupports wildcards (*).";
        if (whitelist.isList()) {
            String[] items;
            for (String s : items = whitelist.getStringList()) {
                if (digitsOnly.matcher(s).matches()) {
                    int id = Integer.parseInt(s);
                    MagicClover.LOGGER.log(Level.WARN, String.format("MagicClover: Item ids are not supported (%s)!", id));
                    continue;
                }
                Registry.registerWhitelistItem(s);
            }
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        defaultBanned = new String[]{"minecraft:flowing_lava", "minecraft:web", "minecraft:powered_comparator", "minecraft:water", "minecraft:flowing_water", "minecraft:lava", "minecraft:tripwire", "minecraft:farmland", "minecraft:unpowered_comparator", "minecraft:vine", "minecraft:standing_sign", "minecraft:bed", "minecraft:end_portal_frame", "minecraft:piston_extension", "minecraft:cauldron", "minecraft:pumpkin_stem", "minecraft:potatoes", "minecraft:unpowered_repeater", "minecraft:brewing_stand", "minecraft:melon_stem", "minecraft:end_portal", "minecraft:flower_pot", "minecraft:reeds", "minecraft:command_block", "minecraft:bedrock", "minecraft:piston_head", "minecraft:redstone_wire", "minecraft:wall_sign", "minecraft:nether_wart", "minecraft:spawn_egg", "minecraft:portal", "minecraft:iron_door", "minecraft:wheat", "minecraft:wooden_door", "minecraft:deadbush", "minecraft:mob_spawner", "minecraft:carrots", "minecraft:cocoa", "minecraft:powered_repeater", "minecraft:enchanted_book", "minecraft:tripwire_hook", "minecraft:netherrack", "minecraft:tallgrass", "minecraft:command_block_minecart", "minecraft:farmland", "minecraft:lit_furnace", "minecraft:barrier", "minecraft:written_book", "minecraft:firework_charge", "minecraft:fireworks", "minecraft:log:[4-5]", "minecraft:log2:[0-3]", "minecraft:stone_slab:2", "minecraft:cooked_fish:[2-3]", "minecraft:leaves:[4-5]", "minecraft:leaves2:[0-3]", "minecraft:map", "minecraft:tipped_arrow", "minecraft:chorus_plant", "minecraft:repeating_command_block", "minecraft:chain_command_block"};
        defaultWhitelisted = new String[]{"minecraft:*", "magicclover:clover"};
        defaultRare = new String[]{"minecraft:dragon_egg", "minecraft:beacon", "minecraft:nether_star", "minecraft:diamond_block", "minecraft:emerald_block", "minecraft:enchanting_table", "minecraft:end_portal_frame", "minecraft:ender_chest", "minecraft:jukebox", "minecraft:saddle", "minecraft:golden_apple", "minecraft:diamond_shovel", "minecraft:diamond_pickaxe", "minecraft:diamond_axe", "minecraft:diamond_sword", "minecraft:diamond_helmet", "minecraft:diamond_chestplate", "minecraft:diamond_leggings", "minecraft:diamond_boots", "minecraft:diamond_hoe", "minecraft:gold_block", "minecraft:iron_block", "minecraft:elytra", "minecraft:skull", "minecraft:end_crystal", "minecraft:diamond_horse_armor"};
        digitsOnly = Pattern.compile("[0-9]+");
    }
}

