/*
 * Decompiled with CFR 0.152.
 */
package clover.common;

import clover.MagicClover;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.common.registry.GameData;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

public class Registry {
    private static final String WILDCARD = "(?:[a-zA-Z0-9_]+)?";
    private static List<String> bannedItems = Lists.newArrayList();
    private static List<String> whitelistedItems = Lists.newArrayList();
    private static List<String> rareItems = Lists.newArrayList();
    private static List<String> items = Lists.newArrayList();

    public static void registerBannedItem(String item) {
        if (item != null) {
            String[] parts = item.split(":");
            if (parts.length == 2) {
                item = item + ":[0-9]+";
            }
            bannedItems.add(item.replaceAll("\\*", WILDCARD));
        }
    }

    public static void registerWhitelistItem(String item) {
        if (item != null) {
            String[] parts = item.split(":");
            if (parts.length == 2) {
                item = item + ":[0-9]+";
            }
            whitelistedItems.add(item.replaceAll("\\*", WILDCARD));
        }
    }

    public static void registerRareItem(String item) {
        if (item != null) {
            String[] parts = item.split(":");
            if (parts.length == 2) {
                item = item + ":[0-9]+";
            }
            rareItems.add(item.replaceAll("\\*", WILDCARD));
        }
    }

    public static void clear() {
        bannedItems.clear();
        whitelistedItems.clear();
        rareItems.clear();
        items.clear();
    }

    public static void load() {
        Registry.forEachItem(new Predicate<Pair<Item, Integer>>(){

            public boolean apply(Pair<Item, Integer> item) {
                boolean canTranslate;
                String unlocalizedName = ((Item)item.getLeft()).func_77667_c(new ItemStack((Item)item.getLeft(), 1, ((Integer)item.getRight()).intValue()));
                String name = GameData.getItemRegistry().func_177774_c(item.getLeft()).toString();
                String id = name + ":" + item.getRight();
                boolean bl = canTranslate = unlocalizedName != null && StatCollector.func_94522_b((String)(unlocalizedName + ".name"));
                if ((whitelistedItems.isEmpty() || Registry.isWhitelisted(id)) && !Registry.isBanned(id) && canTranslate) {
                    items.add(id);
                }
                return false;
            }
        });
        MagicClover.LOGGER.log(Level.INFO, items.size() + " entries");
    }

    public static ItemStack getRandomItem() {
        if (items.size() > 0) {
            int randomID = MagicClover.RANDOM.nextInt(items.size());
            String itemName = items.get(randomID);
            String[] parts = itemName.split(":");
            Item item = (Item)GameData.getItemRegistry().func_82594_a((Object)new ResourceLocation(parts[0] + ":" + parts[1]));
            int meta = Integer.parseInt(parts[2]);
            if (!Registry.isRare(itemName)) {
                return new ItemStack(item, 1, meta);
            }
            if (MagicClover.RANDOM.nextInt(5) == 1) {
                return new ItemStack(item, 1, meta);
            }
            return Registry.getRandomItem();
        }
        return new ItemStack(Blocks.field_150348_b);
    }

    private static void forEachItem(Predicate<Pair<Item, Integer>> predicate) {
        for (Object obj : GameData.getItemRegistry()) {
            int meta;
            Item item = (Item)obj;
            if (item.func_77614_k()) {
                ArrayList names = Lists.newArrayList();
                for (meta = 0; meta < 15; ++meta) {
                    String next;
                    String current;
                    try {
                        current = item.func_77667_c(new ItemStack(item, 1, meta));
                    }
                    catch (Exception e) {
                        --meta;
                        break;
                    }
                    try {
                        next = item.func_77667_c(new ItemStack(item, 1, meta + 1));
                    }
                    catch (Exception e) {
                        break;
                    }
                    if (current == null || next == null || names.contains(next) || current.equals(next)) break;
                    names.add(current);
                }
            }
            for (int i = 0; i <= meta; ++i) {
                predicate.apply((Object)new ImmutablePair((Object)item, (Object)i));
            }
        }
    }

    private static boolean isBanned(String item) {
        for (String entry : bannedItems) {
            try {
                if (!item.matches(entry)) continue;
                return true;
            }
            catch (PatternSyntaxException e) {
                MagicClover.LOGGER.log(Level.WARN, "Item " + item + " has bad characters in it's internal name, silently omitting it.");
                return true;
            }
        }
        return false;
    }

    private static boolean isWhitelisted(String item) {
        for (String entry : whitelistedItems) {
            try {
                if (!item.matches(entry)) continue;
                return true;
            }
            catch (PatternSyntaxException e) {
                MagicClover.LOGGER.log(Level.WARN, "Item " + item + " has bad characters in it's internal name, silently omitting it.");
            }
        }
        return false;
    }

    private static boolean isRare(String item) {
        for (String entry : rareItems) {
            try {
                if (!item.matches(entry)) continue;
                return true;
            }
            catch (PatternSyntaxException e) {
                MagicClover.LOGGER.log(Level.WARN, "Item " + item + " has bad characters in it's internal name, silently omitting it.");
            }
        }
        return false;
    }
}

